/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.xml.parsers.ParserConfigurationException;
import org.jfree.report.modules.gui.config.model.ClassConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.EnumConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.TextConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.xml.DOMUtilities;
import org.jfree.report.modules.gui.config.xml.DOMWriter;
import org.jfree.report.util.CharacterEntityParser;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.StringUtil;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.writer.AttributeList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigDescriptionModel
extends AbstractListModel {
    private final ArrayList content = new ArrayList();

    public void add(ConfigDescriptionEntry entry) {
        if (entry == null) {
            throw new NullPointerException("Entry is null.");
        }
        if (!this.content.contains(entry)) {
            this.content.add(entry);
        }
        this.updated();
    }

    private String[] collectEnumEntries(Element element) {
        NodeList nl = element.getElementsByTagName("text");
        String[] retval = new String[nl.getLength()];
        int i = 0;
        while (i < nl.getLength()) {
            retval[i] = DOMUtilities.getText((Element)nl.item(i));
            ++i;
        }
        return retval;
    }

    public boolean contains(ConfigDescriptionEntry entry) {
        if (entry == null) {
            throw new NullPointerException("The given entry is null.");
        }
        return this.content.contains(entry);
    }

    public ConfigDescriptionEntry get(int pos) {
        return (ConfigDescriptionEntry)this.content.get(pos);
    }

    private String getDescription(Element e) {
        NodeList descr = e.getElementsByTagName("description");
        if (descr.getLength() == 0) {
            return "";
        }
        return DOMUtilities.getText((Element)descr.item(0));
    }

    public Object getElementAt(int index) {
        ConfigDescriptionEntry entry = this.get(index);
        if (entry == null) {
            return null;
        }
        return entry.getKeyName();
    }

    public int getSize() {
        return this.content.size();
    }

    public void importFromConfig(ReportConfiguration config) {
        Iterator it = config.findPropertyKeys("");
        while (it.hasNext()) {
            TextConfigDescriptionEntry entry;
            String keyname = (String)it.next();
            if (((Hashtable)System.getProperties()).containsKey(keyname) || this.contains(entry = new TextConfigDescriptionEntry(keyname))) continue;
            this.add(entry);
        }
    }

    public int indexOf(ConfigDescriptionEntry entry) {
        if (entry == null) {
            throw new NullPointerException("The given entry is null.");
        }
        return this.content.indexOf(entry);
    }

    public void load(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.content.clear();
        Document doc = DOMUtilities.parseInputStream(in);
        Element e = doc.getDocumentElement();
        NodeList list = e.getElementsByTagName("key");
        int i = 0;
        while (i < list.getLength()) {
            Element keyElement = (Element)list.item(i);
            String keyName = keyElement.getAttribute("name");
            boolean keyGlobal = StringUtil.parseBoolean(keyElement.getAttribute("global"), false);
            boolean keyHidden = StringUtil.parseBoolean(keyElement.getAttribute("hidden"), false);
            String descr = this.getDescription(keyElement);
            NodeList enumNodes = keyElement.getElementsByTagName("enum");
            if (enumNodes.getLength() != 0) {
                String[] alteratives = this.collectEnumEntries((Element)enumNodes.item(0));
                EnumConfigDescriptionEntry en = new EnumConfigDescriptionEntry(keyName);
                en.setDescription(descr);
                en.setGlobal(keyGlobal);
                en.setHidden(keyHidden);
                en.setOptions(alteratives);
                this.add(en);
            } else {
                NodeList classNodes = keyElement.getElementsByTagName("class");
                if (classNodes.getLength() != 0) {
                    Class<?> baseClass;
                    Element classElement = (Element)classNodes.item(0);
                    String className = classElement.getAttribute("instanceof");
                    if (className == null) {
                        throw new SAXException("class element: instanceof attribute missing.");
                    }
                    try {
                        baseClass = ObjectUtilities.getClassLoader(this.getClass()).loadClass(className);
                    }
                    catch (Exception ex) {
                        throw new SAXException("Failed to load base class", ex);
                    }
                    ClassConfigDescriptionEntry ce = new ClassConfigDescriptionEntry(keyName);
                    ce.setBaseClass(baseClass);
                    ce.setDescription(descr);
                    ce.setGlobal(keyGlobal);
                    ce.setHidden(keyHidden);
                    this.add(ce);
                } else {
                    NodeList textNodes = keyElement.getElementsByTagName("text");
                    if (textNodes.getLength() != 0) {
                        TextConfigDescriptionEntry textEntry = new TextConfigDescriptionEntry(keyName);
                        textEntry.setDescription(descr);
                        textEntry.setGlobal(keyGlobal);
                        textEntry.setHidden(keyHidden);
                        this.add(textEntry);
                    }
                }
            }
            ++i;
        }
    }

    public void remove(ConfigDescriptionEntry entry) {
        if (entry == null) {
            throw new NullPointerException("The given entry is null.");
        }
        ((AbstractCollection)this.content).remove(entry);
        this.updated();
    }

    public void save(OutputStream out, String encoding) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, encoding));
        writer.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        writer.println("<!DOCTYPE config-description [");
        writer.println("<!ELEMENT config-description  (key*)>");
        writer.println("<!ELEMENT key                 (description?, (class | enum | text))>");
        writer.println("<!ATTLIST key");
        writer.println("   name   CDATA #REQUIRED");
        writer.println("   global CDATA #IMPLIED");
        writer.println("   hidden CDATA #IMPLIED");
        writer.println(" >");
        writer.println();
        writer.println("<!ELEMENT description         (#PCDATA)>");
        writer.println("<!ELEMENT class               EMPTY>");
        writer.println("<!ATTLIST class");
        writer.println("  instanceof CDATA #REQUIRED");
        writer.println(" >");
        writer.println();
        writer.println("<!ELEMENT enum               (text)*>");
        writer.println("<!ELEMENT text               (#PCDATA)>");
        writer.println(" ]>");
        DOMWriter dwriter = DOMWriter.getInstance();
        dwriter.writeTag(writer, "config-description");
        CharacterEntityParser parser = CharacterEntityParser.createXMLEntityParser();
        int i = 0;
        while (i < this.getSize()) {
            ConfigDescriptionEntry entry = this.get(i);
            AttributeList p = new AttributeList();
            p.setAttribute("name", entry.getKeyName());
            p.setAttribute("global", String.valueOf(entry.isGlobal()));
            p.setAttribute("hidden", String.valueOf(entry.isHidden()));
            dwriter.writeTag(writer, "key", p, false);
            if (entry.getDescription() != null) {
                dwriter.writeTag(writer, "description");
                writer.write(parser.encodeEntities(entry.getDescription()));
                dwriter.writeCloseTag(writer, "description");
            }
            if (entry instanceof ClassConfigDescriptionEntry) {
                ClassConfigDescriptionEntry ce = (ClassConfigDescriptionEntry)entry;
                if (ce.getBaseClass() != null) {
                    dwriter.writeTag(writer, "class", "instanceof", ce.getBaseClass().getName(), true);
                } else {
                    dwriter.writeTag(writer, "class", "instanceof", "java.lang.Object", true);
                }
            } else if (entry instanceof TextConfigDescriptionEntry) {
                dwriter.writeTag(writer, "text", new AttributeList(), true);
            } else if (entry instanceof EnumConfigDescriptionEntry) {
                EnumConfigDescriptionEntry en = (EnumConfigDescriptionEntry)entry;
                dwriter.writeTag(writer, "enum");
                String[] alts = en.getOptions();
                if (alts != null) {
                    int optCount = 0;
                    while (optCount < alts.length) {
                        dwriter.writeTag(writer, "text");
                        writer.write(parser.encodeEntities(alts[optCount]));
                        dwriter.writeCloseTag(writer, "text");
                        ++optCount;
                    }
                }
                dwriter.writeCloseTag(writer, "enum");
            }
            dwriter.writeCloseTag(writer, "key");
            ++i;
        }
        dwriter.writeCloseTag(writer, "config-description");
        writer.flush();
    }

    public void sort() {
        Collections.sort(this.content, new ConfigEntryComparator());
    }

    public ConfigDescriptionEntry[] toArray() {
        return this.content.toArray(new ConfigDescriptionEntry[this.content.size()]);
    }

    public void updated() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private static class ConfigEntryComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            ConfigDescriptionEntry e1 = (ConfigDescriptionEntry)o1;
            ConfigDescriptionEntry e2 = (ConfigDescriptionEntry)o2;
            return e1.getKeyName().compareTo(e2.getKeyName());
        }
    }
}

