/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config.model;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.jfree.base.modules.Module;
import org.jfree.report.modules.gui.config.model.AbstractConfigTreeNode;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.ModuleNodeFactory;
import org.jfree.report.util.ReportConfiguration;

public class ConfigTreeModuleNode
extends AbstractConfigTreeNode {
    private final String configurationPrefix;
    private final Module module;
    private final ReportConfiguration configuration;
    private final ArrayList assignedKeys = new ArrayList();

    public ConfigTreeModuleNode(Module module, ReportConfiguration config) {
        super(module.getName());
        this.configuration = config;
        this.module = module;
        this.configurationPrefix = ModuleNodeFactory.getPackage(this.module.getClass());
    }

    public void addAssignedKey(ConfigDescriptionEntry key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!this.assignedKeys.contains(key)) {
            this.assignedKeys.add(key);
        }
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public ConfigDescriptionEntry[] getAssignedKeys() {
        return this.assignedKeys.toArray(new ConfigDescriptionEntry[this.assignedKeys.size()]);
    }

    public ReportConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getConfigurationPrefix() {
        return this.configurationPrefix;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean isLeaf() {
        return true;
    }

    public void removeAssignedKey(ConfigDescriptionEntry key) {
        if (key == null) {
            throw new NullPointerException();
        }
        ((AbstractCollection)this.assignedKeys).remove(key);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ConfigTreeModule={");
        buffer.append(this.getConfigurationPrefix());
        buffer.append("}");
        return buffer.toString();
    }
}

