/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.csv;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.modules.gui.base.ExportTask;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.output.table.csv.CSVTableProcessor;
import org.jfree.report.util.Log;
import org.jfree.util.Log;

public class CSVTableExportTask
extends ExportTask {
    private final ReportProgressDialog progressDialog;
    private final String fileName;
    private final String encoding;
    private final JFreeReport report;

    public CSVTableExportTask(String fileName, String encoding, ReportProgressDialog dialog, JFreeReport report) {
        if (fileName == null) {
            throw new NullPointerException("File name is null.");
        }
        if (report == null) {
            throw new NullPointerException("Report is null.");
        }
        if (encoding == null) {
            throw new NullPointerException("Encoding is null.");
        }
        this.fileName = fileName;
        this.progressDialog = dialog;
        this.report = report;
        this.encoding = encoding;
    }

    protected void dispose() {
        super.dispose();
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
        }
    }

    protected void performExport() {
        Writer out = null;
        File file = new File(this.fileName);
        try {
            try {
                File directory = file.getAbsoluteFile().getParentFile();
                if (directory != null && !directory.exists() && !directory.mkdirs()) {
                    Log.warn("Can't create directories. Hoping and praying now..");
                }
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding));
                CSVTableProcessor target = new CSVTableProcessor(this.report);
                if (this.progressDialog != null) {
                    this.progressDialog.setModal(false);
                    ((Component)this.progressDialog).setVisible(true);
                    target.addRepaginationListener(this.progressDialog);
                }
                target.setWriter(out);
                target.processReport();
                out.close();
                out = null;
                if (this.progressDialog != null) {
                    target.removeRepaginationListener(this.progressDialog);
                }
                this.setTaskDone();
            }
            catch (ReportInterruptedException reportInterruptedException) {
                this.setTaskAborted();
                try {
                    out.close();
                    out = null;
                    if (!file.delete()) {
                        Log.warn(new Log.SimpleMessage("Unable to delete incomplete export:", (Object)file));
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (IOException iOException) {}
            }
            catch (Exception re) {
                Log.error("Exporting failed .", re);
                this.setTaskFailed(re);
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                Log.error("Unable to close the output stream.", e);
            }
            throw throwable;
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            Log.error("Unable to close the output stream.", e);
        }
        if (this.progressDialog != null) {
            ((Component)this.progressDialog).setVisible(false);
        }
    }
}

