/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.html;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.jfree.io.IOUtils;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.components.AbstractExportDialog;
import org.jfree.report.modules.gui.base.components.EncodingComboBoxModel;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.FilesystemFilter;
import org.jfree.ui.action.ActionButton;

public class HtmlExportDialog
extends AbstractExportDialog {
    public static final String HTML_OUTPUT_ENCODING = "org.jfree.report.modules.output.table.html.Encoding";
    public static final String HTML_OUTPUT_ENCODING_DEFAULT = "UTF-16";
    private JTextField txFilename;
    private JTextField txDataFilename;
    private JTextField txTitle;
    private JTextField txAuthor;
    private JComboBox cbEncoding;
    private EncodingComboBoxModel encodingModel;
    private JCheckBox cbxStrictLayout;
    private JRadioButton rbGenerateXHTML;
    private JRadioButton rbGenerateHTML4;
    private JCheckBox cbxCopyExternalReferences;
    private JFileChooser fileChooserZip;
    private JFileChooser fileChooserHtml;
    private JRadioButton rbExportToStream;
    private JRadioButton rbExportToDirectory;
    private JRadioButton rbExportToZIPFile;
    public static final int EXPORT_STREAM = 0;
    public static final int EXPORT_DIR = 1;
    public static final int EXPORT_ZIP = 2;

    public HtmlExportDialog() {
        this.initConstructor();
    }

    public HtmlExportDialog(Dialog owner) {
        super(owner);
        this.initConstructor();
    }

    public HtmlExportDialog(Frame owner) {
        super(owner);
        this.initConstructor();
    }

    public void clear() {
        this.txAuthor.setText(ReportConfiguration.getGlobalConfig().getConfigProperty("user.name", ""));
        this.txFilename.setText("");
        this.txDataFilename.setText("");
        this.txTitle.setText("");
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(ReportConfiguration.getPlatformDefaultEncoding()));
        this.cbxCopyExternalReferences.setSelected(false);
        this.cbxStrictLayout.setSelected(false);
        this.rbGenerateHTML4.setSelected(true);
        this.rbExportToDirectory.setSelected(true);
    }

    public String getAuthor() {
        return this.txAuthor.getText();
    }

    protected String getConfigurationSuffix() {
        return "_htmlexport";
    }

    public String getDataFilename() {
        return this.txDataFilename.getText();
    }

    public Properties getDialogContents() {
        Properties p = new Properties();
        p.setProperty("author", this.getAuthor());
        p.setProperty("data-file", this.getDataFilename());
        p.setProperty("filename", this.getFilename());
        p.setProperty("encoding", this.getEncoding());
        p.setProperty("html.title", this.getHTMLTitle());
        p.setProperty("selected-exportmethod", String.valueOf(this.getSelectedExportMethod()));
        p.setProperty("strict-layout", String.valueOf(this.isStrictLayout()));
        p.setProperty("generate-xhtml", String.valueOf(this.isGenerateXHTML()));
        return p;
    }

    public String getEncoding() {
        if (this.cbEncoding.getSelectedIndex() == -1) {
            return ReportConfiguration.getPlatformDefaultEncoding();
        }
        return this.encodingModel.getEncoding(this.cbEncoding.getSelectedIndex());
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    public String getHTMLTitle() {
        return this.txTitle.getText();
    }

    protected String getResourceBaseName() {
        return "org.jfree.report.modules.gui.html.resources.html-export-resources";
    }

    public int getSelectedExportMethod() {
        if (this.rbExportToStream.isSelected()) {
            return 0;
        }
        if (this.rbExportToZIPFile.isSelected()) {
            return 2;
        }
        return 1;
    }

    private void initConstructor() {
        this.setCancelAction(new CancelAction(this.getResources()));
        this.setConfirmAction(new ConfirmAction(this.getResources()));
        this.setTitle(this.getResources().getString("htmlexportdialog.dialogtitle"));
        this.initialize();
        this.clear();
    }

    public void initFromConfiguration(ReportConfiguration config) {
        String strict = config.getConfigProperty("org.jfree.report.modules.output.table.htmlStrictLayout", config.getConfigProperty("StrictLayout", "false"));
        this.setStrictLayout(strict.equals("true"));
        this.setAuthor(config.getConfigProperty("org.jfree.report.modules.output.table.htmlAuthor", this.getAuthor()));
        this.setHTMLTitle(config.getConfigProperty("org.jfree.report.modules.output.table.htmlTitle", this.getHTMLTitle()));
        String encoding = config.getConfigProperty("org.jfree.report.modules.output.table.htmlEncoding", "UTF-8");
        this.encodingModel.ensureEncodingAvailable(encoding);
        this.setEncoding(encoding);
        String isXHTML = config.getConfigProperty("org.jfree.report.modules.output.table.htmlGenerateXHTML");
        this.setGenerateXHTML("true".equals(isXHTML));
    }

    private void initialize() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblAuthor = new JLabel(this.getResources().getString("htmlexportdialog.author"));
        JLabel lblTitel = new JLabel(this.getResources().getString("htmlexportdialog.title"));
        JLabel lblEncoding = new JLabel(this.getResources().getString("htmlexportdialog.encoding"));
        JLabel lblDirFileName = new JLabel(this.getResources().getString("htmlexportdialog.filename"));
        JLabel lblDirDataFileName = new JLabel(this.getResources().getString("htmlexportdialog.datafilename"));
        JLabel lblExportMethod = new JLabel(this.getResources().getString("htmlexportdialog.exportMethod"));
        JLabel lblExportFormat = new JLabel(this.getResources().getString("htmlexportdialog.exportFormat"));
        this.txAuthor = new JTextField();
        this.txTitle = new JTextField();
        this.txFilename = new JTextField();
        this.txDataFilename = new JTextField();
        this.encodingModel = EncodingComboBoxModel.createDefaultModel();
        this.encodingModel.sort();
        this.cbEncoding = new JComboBox(this.encodingModel);
        this.cbxStrictLayout = new JCheckBox(this.getResources().getString("htmlexportdialog.strict-layout"));
        this.cbxCopyExternalReferences = new JCheckBox(this.getResources().getString("htmlexportdialog.copy-external-references"));
        this.rbGenerateHTML4 = new JRadioButton(this.getResources().getString("htmlexportdialog.generate-html4"));
        this.rbGenerateXHTML = new JRadioButton(this.getResources().getString("htmlexportdialog.generate-xhtml"));
        this.rbExportToDirectory = new JRadioButton(this.getResources().getString("htmlexportdialog.directory-export"));
        this.rbExportToStream = new JRadioButton(this.getResources().getString("htmlexportdialog.stream-export"));
        this.rbExportToZIPFile = new JRadioButton(this.getResources().getString("htmlexportdialog.zip-export"));
        ExportTypeSelectionHandler exportTypeHandler = new ExportTypeSelectionHandler();
        this.rbExportToDirectory.addActionListener(exportTypeHandler);
        this.rbExportToZIPFile.addActionListener(exportTypeHandler);
        this.rbExportToStream.addActionListener(exportTypeHandler);
        ButtonGroup bgExport = new ButtonGroup();
        bgExport.add(this.rbExportToDirectory);
        bgExport.add(this.rbExportToZIPFile);
        bgExport.add(this.rbExportToStream);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbGenerateHTML4);
        bg.add(this.rbGenerateXHTML);
        JPanel exportTypeSelectionPanel = new JPanel();
        exportTypeSelectionPanel.setLayout(new GridLayout(1, 3, 0, 0));
        exportTypeSelectionPanel.add(this.rbExportToDirectory);
        exportTypeSelectionPanel.add(this.rbExportToZIPFile);
        exportTypeSelectionPanel.add(this.rbExportToStream);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 5);
        contentPane.add((Component)lblExportMethod, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)exportTypeSelectionPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 5);
        contentPane.add((Component)lblDirFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 1;
        contentPane.add((Component)new ActionButton((Action)new ActionSelectDirFile(this.getResources())), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 5);
        contentPane.add((Component)lblDirDataFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txDataFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbxCopyExternalReferences, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(8, 1, 8, 1);
        gbc.weightx = 1.0;
        contentPane.add((Component)new JSeparator(0), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbxStrictLayout, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblExportFormat, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 0, 1);
        contentPane.add((Component)this.rbGenerateHTML4, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 1, 1, 1);
        contentPane.add((Component)this.rbGenerateXHTML, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(8, 1, 8, 1);
        gbc.weightx = 1.0;
        contentPane.add((Component)new JSeparator(0), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)lblTitel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblAuthor, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 10;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.txTitle, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 11;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txAuthor, gbc);
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout());
        buttonPanel.add((Component)btnConfirm);
        buttonPanel.add((Component)btnCancel);
        btnConfirm.setDefaultCapable(true);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke(10, 0), 1);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = 15;
        gbc.insets = new Insets(10, 0, 10, 0);
        contentPane.add((Component)buttonPanel, gbc);
        JPanel contentWithStatus = new JPanel();
        contentWithStatus.setLayout(new BorderLayout());
        contentWithStatus.add((Component)contentPane, "Center");
        contentWithStatus.add((Component)this.getStatusBar(), "South");
        this.setContentPane(contentWithStatus);
        this.getFormValidator().registerButton(this.cbxStrictLayout);
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerTextField(this.txDataFilename);
        this.getFormValidator().registerComboBox(this.cbEncoding);
        this.getFormValidator().registerButton(this.rbExportToDirectory);
        this.getFormValidator().registerButton(this.rbExportToStream);
        this.getFormValidator().registerButton(this.rbExportToZIPFile);
    }

    public boolean isGenerateXHTML() {
        return this.rbGenerateXHTML.isSelected();
    }

    public boolean isStrictLayout() {
        return this.cbxStrictLayout.isSelected();
    }

    public static void main(String[] args) {
        HtmlExportDialog dialog = new HtmlExportDialog();
        dialog.setModal(true);
        dialog.pack();
        dialog.performQueryForExport(new JFreeReport());
        System.exit(0);
    }

    protected boolean performConfirm() {
        File dataDir;
        String filename = this.getFilename();
        File f = new File(filename).getAbsoluteFile();
        if (f.exists()) {
            String key1 = "htmlexportdialog.targetOverwriteConfirmation";
            String key2 = "htmlexportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("htmlexportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("htmlexportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        if (this.rbExportToDirectory.isSelected() && !(dataDir = new File(f.getParentFile(), this.getDataFilename())).exists()) {
            String dataDirKey1 = "htmlexportdialog.targetCreateDataDirConfirmation";
            String dataDirKey2 = "htmlexportdialog.targetCreateDataDirTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("htmlexportdialog.targetCreateDataDirConfirmation"), this.getDataFilename()), this.getResources().getString("htmlexportdialog.targetCreateDataDirTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    protected void performSelectFile() {
        File file = new File(this.getFilename());
        if (this.fileChooserHtml == null) {
            this.fileChooserHtml = new JFileChooser();
            this.fileChooserHtml.addChoosableFileFilter((FileFilter)new FilesystemFilter(new String[]{".html", ".htm"}, this.getResources().getString("htmlexportdialog.html-documents"), true));
            this.fileChooserHtml.setMultiSelectionEnabled(false);
        }
        this.fileChooserHtml.setCurrentDirectory(file);
        this.fileChooserHtml.setSelectedFile(file);
        int option = this.fileChooserHtml.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooserHtml.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtil.endsWithIgnoreCase(selFileName, ".html") && !StringUtil.endsWithIgnoreCase(selFileName, ".htm")) {
                selFileName = String.valueOf(selFileName) + ".html";
            }
            this.setFilename(selFileName);
        }
    }

    protected void performSelectFileZip() {
        File file = new File(this.getFilename());
        if (this.fileChooserZip == null) {
            this.fileChooserZip = new JFileChooser();
            this.fileChooserZip.addChoosableFileFilter((FileFilter)new FilesystemFilter(new String[]{".zip", ".jar"}, this.getResources().getString("htmlexportdialog.zip-archives"), true));
            this.fileChooserZip.setMultiSelectionEnabled(false);
        }
        this.fileChooserZip.setCurrentDirectory(file);
        this.fileChooserZip.setSelectedFile(file);
        int option = this.fileChooserZip.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooserZip.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtil.endsWithIgnoreCase(selFileName, ".zip")) {
                selFileName = String.valueOf(selFileName) + ".zip";
            }
            this.setFilename(selFileName);
        }
    }

    protected void performUpdateExportTypeSelection() {
        if (this.rbExportToDirectory.isSelected()) {
            this.txDataFilename.setEnabled(true);
            this.cbxCopyExternalReferences.setEnabled(true);
        } else if (this.rbExportToStream.isSelected()) {
            this.txDataFilename.setEnabled(false);
            this.cbxCopyExternalReferences.setEnabled(false);
        } else if (this.rbExportToZIPFile.isSelected()) {
            this.txDataFilename.setEnabled(true);
            this.cbxCopyExternalReferences.setEnabled(true);
        }
    }

    public boolean performValidate() {
        block9: {
            File dataDir;
            this.getStatusBar().clear();
            String filename = this.getFilename();
            if (filename.trim().length() == 0) {
                this.getStatusBar().setStatus(3, this.getResources().getString("htmlexportdialog.targetIsEmpty"));
                return false;
            }
            File f = new File(filename);
            if (f.exists()) {
                if (!f.isFile()) {
                    this.getStatusBar().setStatus(3, this.getResources().getString("htmlexportdialog.targetIsNoFile"));
                    return false;
                }
                if (!f.canWrite()) {
                    this.getStatusBar().setStatus(3, this.getResources().getString("htmlexportdialog.targetIsNotWritable"));
                    return false;
                }
                String message = MessageFormat.format(this.getResources().getString("htmlexportdialog.targetExistsWarning"), filename);
                this.getStatusBar().setStatus(2, message);
            }
            if (this.rbExportToZIPFile.isSelected()) {
                try {
                    dataDir = new File(this.getDataFilename());
                    File baseDir = new File("");
                    if (!IOUtils.getInstance().isSubDirectory(baseDir, dataDir)) {
                        this.getStatusBar().setStatus(3, this.getResources().getString("htmlexportdialog.targetPathIsAbsolute"));
                        return false;
                    }
                    break block9;
                }
                catch (Exception exception) {
                    this.getStatusBar().setStatus(3, "error.validationfailed");
                    return false;
                }
            }
            if (this.rbExportToDirectory.isSelected() && (dataDir = new File(this.getDataFilename()).getAbsoluteFile()).exists() && !dataDir.isDirectory()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("htmlexportdialog.targetDataDirIsNoDirectory"));
                return false;
            }
        }
        return true;
    }

    public void setAuthor(String author) {
        this.txAuthor.setText(author);
    }

    public void setDataFilename(String dirFilename) {
        this.txDataFilename.setText(dirFilename);
    }

    public void setDialogContents(Properties p) {
        this.setAuthor(p.getProperty("author", this.getAuthor()));
        this.setHTMLTitle(p.getProperty("html.title", this.getHTMLTitle()));
        this.setDataFilename(p.getProperty("data-file", this.getDataFilename()));
        this.setFilename(p.getProperty("filename", this.getFilename()));
        this.setEncoding(p.getProperty("encoding", this.getEncoding()));
        this.setSelectedExportMethod(StringUtil.parseInt(p.getProperty("selected-exportmethod"), this.getSelectedExportMethod()));
        this.setStrictLayout(StringUtil.parseBoolean(p.getProperty("strict-layout"), this.isStrictLayout()));
        this.setGenerateXHTML(StringUtil.parseBoolean(p.getProperty("generate-xhtml"), this.isGenerateXHTML()));
    }

    public void setEncoding(String encoding) {
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(encoding));
    }

    public void setFilename(String dirFilename) {
        this.txFilename.setText(dirFilename);
    }

    public void setGenerateXHTML(boolean generateXHTML) {
        if (generateXHTML) {
            this.rbGenerateXHTML.setSelected(true);
        } else {
            this.rbGenerateHTML4.setSelected(true);
        }
    }

    public void setHTMLTitle(String title) {
        this.txTitle.setText(title);
    }

    public void setSelectedExportMethod(int index) {
        if (index == 1) {
            this.rbExportToDirectory.setSelected(true);
        } else if (index == 0) {
            this.rbExportToStream.setSelected(true);
        } else {
            this.rbExportToZIPFile.setSelected(true);
        }
    }

    public void setStrictLayout(boolean s) {
        this.cbxStrictLayout.setSelected(s);
    }

    public void storeToConfiguration(ReportConfiguration config) {
        config.setConfigProperty("org.jfree.report.modules.output.table.htmlEncoding", this.getEncoding());
        config.setConfigProperty("org.jfree.report.modules.output.table.htmlAuthor", this.getAuthor());
        config.setConfigProperty("org.jfree.report.modules.output.table.htmlTitle", this.getHTMLTitle());
        config.setConfigProperty("org.jfree.report.modules.output.table.htmlStrictLayout", String.valueOf(this.isStrictLayout()));
    }

    private class ConfirmAction
    extends AbstractExportDialog.AbstractConfirmAction {
        public ConfirmAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("htmlexportdialog.confirm"));
        }
    }

    private class CancelAction
    extends AbstractExportDialog.AbstractCancelAction {
        public CancelAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("htmlexportdialog.cancel"));
        }
    }

    private class ActionSelectDirFile
    extends AbstractAction {
        public ActionSelectDirFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("htmlexportdialog.selectDirFile"));
        }

        public void actionPerformed(ActionEvent e) {
            if (HtmlExportDialog.this.getSelectedExportMethod() == 2) {
                HtmlExportDialog.this.performSelectFileZip();
            } else {
                HtmlExportDialog.this.performSelectFile();
            }
        }
    }

    private class ExportTypeSelectionHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            HtmlExportDialog.this.performUpdateExportTypeSelection();
        }
    }
}

