/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.pdf;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.modules.gui.base.ExportTask;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.output.pageable.base.PageableReportProcessor;
import org.jfree.report.modules.output.pageable.pdf.PDFOutputTarget;
import org.jfree.report.util.Log;
import org.jfree.util.Log;

public class PDFExportTask
extends ExportTask {
    private final ReportProgressDialog progressDialog;
    private final String fileName;
    private final JFreeReport report;

    public PDFExportTask(String fileName, ReportProgressDialog dialog, JFreeReport report) {
        if (fileName == null) {
            throw new NullPointerException("File name is null.");
        }
        if (report == null) {
            throw new NullPointerException("Report is null.");
        }
        this.fileName = fileName;
        this.progressDialog = dialog;
        this.report = report;
    }

    protected void dispose() {
        super.dispose();
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
        }
    }

    protected void performExport() {
        OutputStream out = null;
        File file = new File(this.fileName).getAbsoluteFile();
        try {
            try {
                File directory = file.getParentFile();
                if (directory != null && !directory.exists() && !directory.mkdirs()) {
                    Log.warn("Can't create directories. Hoping and praying now..");
                }
                out = new BufferedOutputStream(new FileOutputStream(file));
                PDFOutputTarget target = new PDFOutputTarget(out);
                target.configure(this.report.getReportConfiguration());
                target.open();
                PageableReportProcessor proc = new PageableReportProcessor(this.report);
                if (this.progressDialog != null) {
                    this.progressDialog.setModal(false);
                    ((Component)this.progressDialog).setVisible(true);
                    proc.addRepaginationListener(this.progressDialog);
                }
                proc.setOutputTarget(target);
                proc.processReport();
                target.close();
                if (this.progressDialog != null) {
                    proc.removeRepaginationListener(this.progressDialog);
                }
                this.setTaskDone();
            }
            catch (ReportInterruptedException reportInterruptedException) {
                this.setTaskAborted();
                try {
                    out.close();
                    out = null;
                    if (!file.delete()) {
                        Log.warn(new Log.SimpleMessage("Unable to delete incomplete export:", (Object)file));
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (IOException iOException) {}
            }
            catch (Exception re) {
                Log.error("Exporting failed.", re);
                this.setTaskFailed(re);
            }
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                Log.error("Unable to close the output stream.", e);
                this.setTaskFailed(e);
            }
            throw throwable;
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            Log.error("Unable to close the output stream.", e);
            this.setTaskFailed(e);
        }
        if (this.progressDialog != null) {
            ((Component)this.progressDialog).setVisible(false);
        }
    }
}

