/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.print;

import java.awt.Window;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.AbstractExportPlugin;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.gui.print.PrintExportTask;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ResourceBundleSupport;

public class PrintingPlugin
extends AbstractExportPlugin {
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.print.resources.print-export-resources");
    public static final String BASE_RESOURCE_CLASS = "org.jfree.report.modules.gui.print.resources.print-export-resources";
    public static final String PROGRESS_DIALOG_ENABLE_KEY = "org.jfree.report.modules.gui.print.ProgressDialogEnabled";

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setTitle(this.resources.getString("printing-export.progressdialog.title"));
        progressDialog.setMessage(this.resources.getString("printing-export.progressdialog.message"));
        progressDialog.pack();
        RefineryUtilities.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getKeyStroke("action.print.accelerator");
    }

    public String getDisplayName() {
        return this.resources.getString("action.print.name");
    }

    public Icon getLargeIcon() {
        return this.resources.getIcon("action.print.icon");
    }

    public Integer getMnemonicKey() {
        return this.resources.getMnemonic("action.print.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public String getShortDescription() {
        return this.resources.getString("action.print.description");
    }

    public Icon getSmallIcon() {
        return this.resources.getIcon("action.print.small-icon");
    }

    public boolean isAddToToolbar() {
        return ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.print.AddToToolbar", "false").equals("true");
    }

    public boolean isSeparated() {
        return ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.print.Separated", "false").equals("true");
    }

    public boolean performExport(JFreeReport report) {
        ReportProgressDialog progressDialog = report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_KEY, "false").equals("true") ? this.createProgressDialog() : null;
        PrintExportTask task = new PrintExportTask(this.getBase().getReportPane(), progressDialog, report.getReportConfiguration().getConfigProperty("org.jfree.report.modules.gui.print.JobName"));
        task.addExportTaskListener(new AbstractExportPlugin.DefaultExportTaskListener());
        this.delegateTask(task);
        return this.handleExportResult(task);
    }
}

