/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.xls;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.AbstractExportPlugin;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.gui.xls.ExcelExportDialog;
import org.jfree.report.modules.gui.xls.ExcelExportTask;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ResourceBundleSupport;

public class ExcelExportPlugin
extends AbstractExportPlugin {
    private ExcelExportDialog exportDialog;
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.xls.resources.xls-export-resources");
    public static final String BASE_RESOURCE_CLASS = "org.jfree.report.modules.gui.xls.resources.xls-export-resources";
    public static final String PROGRESS_DIALOG_ENABLE_KEY = "org.jfree.report.modules.gui.xls.ProgressDialogEnabled";

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setTitle(this.resources.getString("excel-export.progressdialog.title"));
        progressDialog.setMessage(this.resources.getString("excel-export.progressdialog.message"));
        progressDialog.pack();
        RefineryUtilities.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getKeyStroke("action.export-to-excel.accelerator");
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-excel.name");
    }

    protected ExcelExportDialog getExportDialog() {
        if (this.exportDialog == null) {
            PreviewProxy proxy = super.getProxy();
            this.exportDialog = proxy instanceof Frame ? new ExcelExportDialog((Frame)((Object)proxy)) : (proxy instanceof Dialog ? new ExcelExportDialog((Dialog)((Object)proxy)) : new ExcelExportDialog());
            this.exportDialog.pack();
        }
        return this.exportDialog;
    }

    public Icon getLargeIcon() {
        return this.resources.getIcon("action.export-to-excel.icon");
    }

    public Integer getMnemonicKey() {
        return this.resources.getMnemonic("action.export-to-excel.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-excel.description");
    }

    public Icon getSmallIcon() {
        return this.resources.getIcon("action.export-to-excel.small-icon");
    }

    public boolean isAddToToolbar() {
        return ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.xls.AddToToolbar", "false").equals("true");
    }

    public boolean isSeparated() {
        return ReportConfiguration.getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.xls.Separated", "false").equals("true");
    }

    public boolean performExport(JFreeReport report) {
        ExcelExportDialog exportDialog = this.getExportDialog();
        boolean result = exportDialog.performQueryForExport(report);
        if (!result) {
            return this.handleExportResult(true);
        }
        ReportProgressDialog progressDialog = report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_KEY, "false").equals("true") ? this.createProgressDialog() : null;
        ExcelExportTask task = new ExcelExportTask(exportDialog.getFilename(), progressDialog, report);
        task.addExportTaskListener(new AbstractExportPlugin.DefaultExportTaskListener());
        this.delegateTask(task);
        return this.handleExportResult(task);
    }
}

