/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.beanshell;

import bsh.Interpreter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import org.jfree.report.function.AbstractExpression;
import org.jfree.report.function.Expression;
import org.jfree.report.util.Log;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class BSHExpression
extends AbstractExpression
implements Serializable {
    public static final String BSHHEADERFILE = "org/jfree/report/modules/misc/beanshell/BSHExpressionHeader.txt";
    private transient Interpreter interpreter;
    private transient boolean invalid;
    private String expression;
    static /* synthetic */ Class class$org$jfree$report$modules$misc$beanshell$BSHExpression;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BSHExpression expression = (BSHExpression)super.clone();
        expression.interpreter = null;
        return expression;
    }

    private Interpreter createInterpreter() {
        Interpreter interpreter = new Interpreter();
        try {
            InputStream in = ObjectUtilities.getResourceRelativeAsStream((String)"BSHExpressionHeader.txt", (Class)(class$org$jfree$report$modules$misc$beanshell$BSHExpression != null ? class$org$jfree$report$modules$misc$beanshell$BSHExpression : (class$org$jfree$report$modules$misc$beanshell$BSHExpression = BSHExpression.class$("org.jfree.report.modules.misc.beanshell.BSHExpression"))));
            InputStreamReader r = new InputStreamReader(new BufferedInputStream(in));
            interpreter.eval((Reader)r);
            ((Reader)r).close();
            if (this.getExpression() != null) {
                interpreter.eval(this.expression);
            }
            return interpreter;
        }
        catch (Exception e) {
            Log.error("Unable to initialize the expression", e);
            return null;
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public Expression getInstance() {
        BSHExpression expression = (BSHExpression)super.getInstance();
        return expression;
    }

    public Object getValue() {
        if (this.invalid) {
            return null;
        }
        if (this.interpreter == null) {
            this.interpreter = this.createInterpreter();
            if (this.interpreter == null) {
                this.invalid = true;
                return null;
            }
        }
        try {
            this.interpreter.set("dataRow", (Object)this.getDataRow());
            return this.interpreter.eval("getValue ();");
        }
        catch (Exception e) {
            Log.warn(new Log.SimpleMessage("Evaluation error: ", e.getClass(), (Object)" - ", (Object)e.getMessage()), e);
            return null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.invalid = false;
    }
}

