/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.referencedoc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.ClassFactoryCollector;
import org.jfree.xml.factory.objects.ObjectDescription;

public class ObjectReferenceTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"object-factory", "object-class", "parameter-name", "parameter-class"};
    private final ArrayList rows = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;

    public ObjectReferenceTableModel(ClassFactoryCollector cf) {
        this.addClassFactoryCollector(cf);
    }

    private void addClassFactory(ClassFactory cf) {
        Class c;
        Iterator it = cf.getRegisteredClasses();
        ArrayList<Class> factories = new ArrayList<Class>();
        while (it.hasNext()) {
            c = (Class)it.next();
            factories.add(c);
        }
        Collections.sort(factories, new ClassNameComparator());
        it = ((AbstractList)factories).iterator();
        while (it.hasNext()) {
            c = (Class)it.next();
            ObjectDescription od = cf.getDescriptionForClass(c);
            Iterator itNames = od.getParameterNames();
            ArrayList nameList = new ArrayList();
            while (itNames.hasNext()) {
                nameList.add(itNames.next());
            }
            Collections.sort(nameList);
            itNames = ((AbstractList)nameList).iterator();
            while (itNames.hasNext()) {
                String name = (String)itNames.next();
                this.rows.add(new ObjectDescriptionRow(cf, c, name, od.getParameterDefinition(name)));
            }
        }
    }

    private void addClassFactoryCollector(ClassFactoryCollector cf) {
        Iterator it = cf.getFactories();
        while (it.hasNext()) {
            ClassFactory cfact = (ClassFactory)it.next();
            if (cfact instanceof ClassFactoryCollector) {
                this.addClassFactoryCollector((ClassFactoryCollector)cfact);
                continue;
            }
            this.addClassFactory(cfact);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ObjectReferenceTableModel.class$("java.lang.String"));
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ObjectDescriptionRow or = (ObjectDescriptionRow)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(or.getClassFactory().getClass().getName());
            }
            case 1: {
                return String.valueOf(or.getObject().getName());
            }
            case 2: {
                return String.valueOf(or.getParamName());
            }
            case 3: {
                return String.valueOf(or.getParamType().getName());
            }
        }
        return null;
    }

    private static class ObjectDescriptionRow {
        private final ClassFactory classFactory;
        private final Class object;
        private final String paramName;
        private final Class paramType;

        public ObjectDescriptionRow(ClassFactory classFactory, Class object, String paramName, Class paramType) {
            this.classFactory = classFactory;
            this.object = object;
            this.paramName = paramName;
            this.paramType = paramType;
        }

        public ClassFactory getClassFactory() {
            return this.classFactory;
        }

        public Class getObject() {
            return this.object;
        }

        public String getParamName() {
            return this.paramName;
        }

        public Class getParamType() {
            return this.paramType;
        }
    }

    private class ClassNameComparator
    implements Comparator {
        ClassNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }
}

