/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.survey;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Drawable;
import org.jfree.ui.TextAnchor;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ShapeList;
import org.jfree.util.ShapeUtilities;

public class SurveyScale
implements Drawable {
    private int lowest;
    private int highest;
    private double lowerMargin = 0.1;
    private double upperMargin = 0.1;
    private ShapeList shapes;
    private Paint fillPaint;
    private Stroke outlineStroke;
    private BooleanList fillShapes;
    private Number[] values;
    private Number rangeLowerBound;
    private Number rangeUpperBound;
    private boolean drawBorder = false;
    private boolean drawTickMarks;
    private Paint tickMarkPaint;
    private boolean drawScaleValues = false;
    private Font scaleValueFont;
    private Paint scaleValuePaint;
    private Paint rangePaint;
    private Shape defaultShape;

    public SurveyScale() {
        this(1, 5, null);
    }

    public SurveyScale(int lowest, int highest, Number[] values) {
        this.lowest = lowest;
        this.highest = highest;
        this.values = values;
        this.drawTickMarks = true;
        this.tickMarkPaint = Color.gray;
        this.scaleValueFont = new Font("Serif", 2, 10);
        this.scaleValuePaint = Color.black;
        this.defaultShape = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
        this.rangeLowerBound = null;
        this.rangeUpperBound = null;
        this.rangePaint = Color.lightGray;
        this.shapes = this.createShapeList();
        this.fillShapes = new BooleanList();
        this.fillShapes.setBoolean(0, Boolean.TRUE);
        this.fillPaint = Color.black;
        this.outlineStroke = new BasicStroke(0.5f);
    }

    protected ShapeList createShapeList() {
        ShapeList shapes = new ShapeList();
        shapes.setShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        shapes.setShape(1, ShapeUtilities.createDownTriangle((float)4.0f));
        shapes.setShape(2, ShapeUtilities.createUpTriangle((float)4.0f));
        shapes.setShape(3, ShapeUtilities.createDiamond((float)4.0f));
        shapes.setShape(4, (Shape)new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
        shapes.setShape(5, (Shape)new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        return shapes;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        double range = this.highest - this.lowest;
        double lowerBound = (double)this.lowest - range * this.lowerMargin;
        double upperBound = (double)this.highest + range * this.upperMargin;
        if (this.drawBorder) {
            g2.setStroke(new BasicStroke(0.5f));
            g2.setPaint(Color.black);
            g2.draw(area);
        }
        if (this.rangeLowerBound != null && this.rangeUpperBound != null) {
            double x0 = this.valueToJava2D(this.rangeLowerBound.doubleValue(), area, lowerBound, upperBound);
            double x1 = this.valueToJava2D(this.rangeUpperBound.doubleValue(), area, lowerBound, upperBound);
            Rectangle2D.Double rangeArea = new Rectangle2D.Double(x0, area.getY(), x1 - x0, area.getHeight());
            g2.setPaint(this.rangePaint);
            g2.fill(rangeArea);
        }
        if (this.drawTickMarks) {
            g2.setPaint(this.tickMarkPaint);
            g2.setStroke(new BasicStroke(0.1f));
            int i = this.lowest;
            while (i < this.highest) {
                int j = 0;
                while (j < 10) {
                    double xx = this.valueToJava2D((double)i + (double)j / 10.0, area, lowerBound, upperBound);
                    Line2D.Double mark = new Line2D.Double(xx, area.getCenterY() - 2.0, xx, area.getCenterY() + 2.0);
                    g2.draw(mark);
                    ++j;
                }
                ++i;
            }
            double xx = this.valueToJava2D(this.highest, area, lowerBound, upperBound);
            Line2D.Double mark = new Line2D.Double(xx, area.getCenterY() - 2.0, xx, area.getCenterY() + 2.0);
            g2.draw(mark);
        }
        if (this.drawScaleValues) {
            g2.setPaint(this.scaleValuePaint);
            g2.setFont(this.scaleValueFont);
            int i = this.lowest;
            while (i <= this.highest) {
                double x = this.valueToJava2D(i, area, lowerBound, upperBound);
                double y = area.getCenterY();
                TextUtilities.drawAlignedString((String)String.valueOf(i), (Graphics2D)g2, (float)((float)x), (float)((float)y), (TextAnchor)TextAnchor.CENTER);
                ++i;
            }
        }
        if (this.values != null) {
            g2.setPaint(this.fillPaint);
            int i = 0;
            while (i < this.values.length) {
                Number n = this.values[i];
                if (n != null) {
                    double v = n.doubleValue();
                    double x = this.valueToJava2D(v, area, lowerBound, upperBound);
                    double y = area.getCenterY();
                    Shape valueShape = this.shapes.getShape(i);
                    if (valueShape == null) {
                        valueShape = this.defaultShape;
                    }
                    Shape s = SurveyScale.translateShape(valueShape, x, y);
                    Boolean b = this.fillShapes.getBoolean(i);
                    if (Boolean.TRUE.equals(b)) {
                        g2.fill(s);
                    } else {
                        g2.setStroke(this.outlineStroke);
                        g2.draw(s);
                    }
                }
                ++i;
            }
        }
    }

    public Shape getDefaultShape() {
        return this.defaultShape;
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public boolean getDrawScaleValues() {
        return this.drawScaleValues;
    }

    public boolean getDrawTickMarks() {
        return this.drawTickMarks;
    }

    public Number getRangeLowerBound() {
        return this.rangeLowerBound;
    }

    public Paint getRangePaint() {
        return this.rangePaint;
    }

    public Number getRangeUpperBound() {
        return this.rangeUpperBound;
    }

    public Font getScaleValueFont() {
        return this.scaleValueFont;
    }

    public Paint getScaleValuePaint() {
        return this.scaleValuePaint;
    }

    public Shape getShape(int index) {
        return this.shapes.getShape(index);
    }

    public boolean isShapeFilled(int index) {
        boolean result = false;
        Boolean b = this.fillShapes.getBoolean(index);
        if (b != null) {
            result = b;
        }
        return result;
    }

    public void setDefaultShape(Shape defaultShape) {
        if (defaultShape == null) {
            throw new NullPointerException("The default shape must not be null.");
        }
        this.defaultShape = defaultShape;
    }

    public void setDrawBorder(boolean flag) {
        this.drawBorder = flag;
    }

    public void setDrawScaleValues(boolean flag) {
        this.drawScaleValues = flag;
    }

    public void setDrawTickMarks(boolean flag) {
        this.drawTickMarks = flag;
    }

    public void setRangeLowerBound(Number bound) {
        this.rangeLowerBound = bound;
    }

    public void setRangePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangePaint = paint;
    }

    public void setRangeUpperBound(Number bound) {
        this.rangeUpperBound = bound;
    }

    public void setScaleValueFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.scaleValueFont = font;
    }

    public void setScaleValuePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
    }

    public void setShape(int index, Shape shape) {
        this.shapes.setShape(index, shape);
    }

    public void setShapeFilled(int index, boolean fill) {
        this.fillShapes.setBoolean(index, BooleanUtilities.valueOf((boolean)fill));
    }

    public static Shape translateShape(Shape shape, double transX, double transY) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(transX, transY);
        return transform.createTransformedShape(shape);
    }

    private double valueToJava2D(double value, Rectangle2D area, double lowerBound, double upperBound) {
        return area.getMinX() + (value - lowerBound) / (upperBound - lowerBound) * area.getWidth();
    }
}

