/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.meta;

import java.util.ArrayList;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.ShapeElement;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.modules.output.meta.MetaBand;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.StyleSheetCarrier;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.geom.StrictBounds;

public class MetaBandProducer {
    private LayoutSupport support;

    public MetaBandProducer(LayoutSupport support) {
        if (support == null) {
            throw new NullPointerException("LayoutSupport is null.");
        }
        this.support = support;
    }

    public MetaBand createBand(Band band, boolean spool) throws ContentCreationException {
        return this.createBand(band, spool, 0L, 0L);
    }

    public MetaBand createBand(Band band, boolean spool, long parentX, long parentY) throws ContentCreationException {
        if (!band.isVisible()) {
            return null;
        }
        if (band.getElementCount() == 0) {
            return null;
        }
        ArrayList<MetaElement> metaElements = new ArrayList<MetaElement>();
        Element[] elements = band.getElementArray();
        StrictBounds bounds = (StrictBounds)band.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        long x = bounds.getX() + parentX;
        long y = bounds.getY() + parentY;
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            if (element.isVisible()) {
                if (element instanceof Band) {
                    MetaBand metaBand = this.createBand((Band)element, spool, x, y);
                    if (metaBand != null) {
                        metaElements.add(metaBand);
                    }
                } else {
                    MetaElement metaElement = this.createElement(element, x, y);
                    if (metaElement != null) {
                        metaElements.add(metaElement);
                    }
                }
            }
            ++i;
        }
        MetaElement[] metaElementArray = metaElements.toArray(new MetaElement[metaElements.size()]);
        ElementStyleSheet styleForBand = this.createStyleForBand(band, parentX, parentY);
        MetaBand mband = this.createMetaBandInstace(band, styleForBand, metaElementArray, spool);
        mband.setName(band.getName());
        return mband;
    }

    private ElementStyleSheet createCommonStyleForElement(Element e, long x, long y) {
        ElementStyleSheet elementStyle = e.getStyle();
        MetaElementStyleSheet style = new MetaElementStyleSheet("meta-" + e.getName());
        style.setStyleProperty(ElementStyleSheet.BOUNDS, this.createElementBounds(elementStyle, x, y));
        style.setStyleProperty(ElementStyleSheet.VALIGNMENT, elementStyle.getStyleProperty(ElementStyleSheet.VALIGNMENT));
        style.setStyleProperty(ElementStyleSheet.ALIGNMENT, elementStyle.getStyleProperty(ElementStyleSheet.ALIGNMENT));
        style.setStyleProperty(ElementStyleSheet.HREF_TARGET, elementStyle.getStyleProperty(ElementStyleSheet.HREF_TARGET));
        style.setBooleanStyleProperty(ElementStyleSheet.HREF_INHERITED, elementStyle.isLocalKey(ElementStyleSheet.HREF_TARGET));
        return style;
    }

    protected MetaElement createElement(Element e, long parentx, long parenty) throws ContentCreationException {
        if (!this.support.getContentFactory().canHandleContent(e.getContentType())) {
            return null;
        }
        if (!e.isVisible()) {
            return null;
        }
        ElementStyleSheet styleSheet = this.createStyleForElement(e, parentx, parenty);
        StrictBounds bounds = (StrictBounds)styleSheet.getStyleProperty(ElementStyleSheet.BOUNDS);
        ElementLayoutInformation eli = new ElementLayoutInformation(bounds);
        Content content = this.support.getContentFactory().createContentForElement(e, eli, this.support);
        MetaElement element = new MetaElement(content, styleSheet);
        element.setName(e.getName());
        return element;
    }

    protected StrictBounds createElementBounds(ElementStyleSheet style, long x, long y) {
        StrictBounds bounds = (StrictBounds)style.getStyleProperty(ElementStyleSheet.BOUNDS);
        return new StrictBounds(x + bounds.getX(), y + bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    protected MetaBand createMetaBandInstace(Band band, ElementStyleSheet style, MetaElement[] elements, boolean spool) {
        MetaBand mband = new MetaBand(EmptyContent.getDefaultEmptyContent(), style, elements, spool);
        return mband;
    }

    protected ElementStyleSheet createStyleForBand(Band band, long x, long y) {
        ElementStyleSheet bandStyle = band.getStyle();
        MetaElementStyleSheet style = new MetaElementStyleSheet("meta-band");
        style.setStyleProperty(ElementStyleSheet.BOUNDS, this.createElementBounds(bandStyle, x, y));
        return style;
    }

    protected ElementStyleSheet createStyleForDrawableElement(Element e, long x, long y) {
        ElementStyleSheet style = this.createCommonStyleForElement(e, x, y);
        return style;
    }

    protected ElementStyleSheet createStyleForElement(Element e, long x, long y) {
        if (e.getContentType().equals("text/plain")) {
            return this.createStyleForTextElement(e, x, y);
        }
        if (e.getContentType().equals("shape/generic")) {
            return this.createStyleForShapeElement(e, x, y);
        }
        if (e.getContentType().equals("drawable/generic")) {
            return this.createStyleForDrawableElement(e, x, y);
        }
        if (e.getContentType().equals("image/generic")) {
            return this.createStyleForImageElement(e, x, y);
        }
        return this.createCommonStyleForElement(e, x, y);
    }

    protected ElementStyleSheet createStyleForImageElement(Element e, long x, long y) {
        ElementStyleSheet elementStyle = e.getStyle();
        ElementStyleSheet style = this.createCommonStyleForElement(e, x, y);
        style.setStyleProperty(ElementStyleSheet.PAINT, elementStyle.getStyleProperty(ElementStyleSheet.PAINT));
        return style;
    }

    protected ElementStyleSheet createStyleForShapeElement(Element e, long x, long y) {
        ElementStyleSheet elementStyle = e.getStyle();
        ElementStyleSheet style = this.createCommonStyleForElement(e, x, y);
        style.setStyleProperty(ElementStyleSheet.PAINT, elementStyle.getStyleProperty(ElementStyleSheet.PAINT));
        style.setStyleProperty(ElementStyleSheet.STROKE, elementStyle.getStyleProperty(ElementStyleSheet.STROKE));
        style.setStyleProperty(ShapeElement.FILL_SHAPE, elementStyle.getStyleProperty(ShapeElement.FILL_SHAPE));
        style.setStyleProperty(ShapeElement.DRAW_SHAPE, elementStyle.getStyleProperty(ShapeElement.DRAW_SHAPE));
        return style;
    }

    protected ElementStyleSheet createStyleForTextElement(Element e, long x, long y) {
        ElementStyleSheet elementStyle = e.getStyle();
        ElementStyleSheet style = this.createCommonStyleForElement(e, x, y);
        style.setFontDefinitionProperty(elementStyle.getFontDefinitionProperty());
        style.setStyleProperty(ElementStyleSheet.PAINT, elementStyle.getStyleProperty(ElementStyleSheet.PAINT));
        style.setStyleProperty(ElementStyleSheet.STROKE, elementStyle.getStyleProperty(ElementStyleSheet.STROKE));
        return style;
    }

    public LayoutSupport getLayoutSupport() {
        return this.support;
    }

    protected static class MetaElementStyleSheet
    extends ElementStyleSheet {
        public MetaElementStyleSheet(String name) {
            super(name);
        }

        protected StyleSheetCarrier createCarrier(ElementStyleSheet styleSheet) {
            throw new UnsupportedOperationException("At this point, we do not support inheritance anymore.");
        }
    }
}

