/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.base;

import java.lang.ref.WeakReference;
import org.jfree.report.PageDefinition;
import org.jfree.report.ReportEventException;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.meta.MetaPage;
import org.jfree.report.modules.output.pageable.base.AlignedLogicalPage;
import org.jfree.report.modules.output.pageable.base.OutputTarget;
import org.jfree.report.modules.output.pageable.base.pagelayout.PageLayouter;
import org.jfree.report.states.ReportState;
import org.jfree.report.util.Log;

public class PageProcess {
    private boolean handleInterruptedState;
    private OutputTarget outputTarget;
    private PageDefinition pageDefinition;
    private MetaPage metaPage;
    private WeakReference lastRecentlyUsedState;

    public PageProcess(OutputTarget target, PageDefinition page, boolean handleInterrupt) {
        this.handleInterruptedState = handleInterrupt;
        this.outputTarget = target;
        this.pageDefinition = page;
    }

    private void checkInterrupted() throws ReportInterruptedException {
        if (this.isHandleInterruptedState() && Thread.interrupted()) {
            throw new ReportInterruptedException("Current thread is interrupted. Returning.");
        }
    }

    public synchronized void clear() {
        this.metaPage = null;
        this.lastRecentlyUsedState = null;
    }

    public MetaPage getMetaPage() {
        return this.metaPage;
    }

    public OutputTarget getOutputTarget() {
        return this.outputTarget;
    }

    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public boolean isHandleInterruptedState() {
        return this.handleInterruptedState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized ReportState processPage(ReportState currPage, boolean failOnError) throws ReportProcessingException {
        CacheInformation ci;
        if (currPage == null) {
            throw new NullPointerException("State != null");
        }
        if (currPage.isFinish()) {
            throw new IllegalArgumentException("No finish state for processpage allowed: ");
        }
        if (this.lastRecentlyUsedState != null && (ci = (CacheInformation)this.lastRecentlyUsedState.get()) != null && ci.getInitialState() == currPage) {
            return ci.getFinalState();
        }
        ReportState state = null;
        PageLayouter lm = null;
        this.metaPage = null;
        try {
            try {
                this.checkInterrupted();
                try {
                    state = (ReportState)currPage.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new ReportProcessingException("Clone not supported by ReportState?!");
                }
                lm = (PageLayouter)state.getDataRow().get("pageable.layoutManager");
                lm.setLogicalPage(new AlignedLogicalPage(this.outputTarget, this.pageDefinition));
                lm.restoreSaveState(state);
                if (lm.isPageEnded()) {
                    if (!(state = state.advance()).isFinish()) {
                        throw new ReportProcessingException("State finished page during restore");
                    }
                } else {
                    while (!lm.isPageEnded() && !state.isFinish()) {
                        PageLayouter org = (PageLayouter)state.getDataRow().get("pageable.layoutManager");
                        ReportState.PageBreakSaveState oldState = state.createPageProgressCopy();
                        lm = (PageLayouter)state.getDataRow().get("pageable.layoutManager");
                        state = state.advance();
                        if (failOnError) {
                            if (state.isErrorOccured()) {
                                throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
                            }
                        } else if (state.isErrorOccured()) {
                            Log.error("Failed to dispatch an event.", (Exception)((Object)new ReportEventException("Failed to dispatch an event.", state.getErrors())));
                        }
                        if (org != (lm = (PageLayouter)state.getDataRow().get("pageable.layoutManager"))) {
                            throw new IllegalStateException("Lost the layout manager");
                        }
                        if (lm.isAutomaticPagebreak()) {
                            state = oldState.restorePageProgressCopy();
                            lm = (PageLayouter)state.getDataRow().get("pageable.layoutManager");
                            lm.finishPageAfterRestore(state);
                            break;
                        }
                        this.checkInterrupted();
                    }
                }
                this.metaPage = lm.getMetaPage();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new ReportProcessingException("Unable to create temporary state object.");
            }
            Object var6_7 = null;
            if (lm != null) {
                lm.clearLogicalPage();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (lm != null) {
                lm.clearLogicalPage();
            }
            throw throwable;
        }
        this.lastRecentlyUsedState = new WeakReference<CacheInformation>(new CacheInformation(currPage, state));
        return state;
    }

    private static class CacheInformation {
        private ReportState initialState;
        private ReportState finalState;

        public CacheInformation(ReportState initialState, ReportState finalState) {
            this.initialState = initialState;
            this.finalState = finalState;
        }

        public ReportState getFinalState() {
            return this.finalState;
        }

        public ReportState getInitialState() {
            return this.initialState;
        }
    }
}

