/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.jfree.report.modules.output.pageable.plaintext.AbstractPrinterSpecificationLoader;
import org.jfree.report.modules.output.pageable.plaintext.PrinterEncoding;
import org.jfree.report.modules.output.pageable.plaintext.PrinterSpecification;
import org.jfree.util.DefaultConfiguration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class PrinterSpecificationManager
extends AbstractPrinterSpecificationLoader {
    private HashMap printerModels;
    private static PrinterSpecification generic;
    static /* synthetic */ Class class$org$jfree$report$modules$output$pageable$plaintext$PrinterSpecificationManager;

    protected PrinterSpecificationManager() {
        PrinterSpecification generic = PrinterSpecificationManager.getGenericPrinter();
        this.printerModels = new HashMap();
        this.printerModels.put(generic.getName(), generic);
    }

    private void addPrinter(PrinterSpecification printer) {
        this.printerModels.put(printer.getName(), printer);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static synchronized PrinterSpecification getGenericPrinter() {
        if (generic == null) {
            generic = new GenericPrinterSpecification();
        }
        return generic;
    }

    public PrinterSpecification getPrinter(String name) {
        return (PrinterSpecification)this.printerModels.get(name);
    }

    public String[] getPrinterNames() {
        return this.printerModels.keySet().toArray(new String[this.printerModels.size()]);
    }

    public synchronized void load(InputStream in) throws IOException {
        DefaultConfiguration encodingConfig = new DefaultConfiguration();
        encodingConfig.load(in);
        PrinterEncoding[] encodings = this.loadEncodings(encodingConfig);
        PrinterSpecification[] printers = this.loadPrinters(encodingConfig, encodings);
        if (printers.length > 0) {
            this.printerModels.remove(generic.getName());
        }
        int i = 0;
        while (i < printers.length) {
            this.addPrinter(printers[i]);
            ++i;
        }
    }

    public void load(String resourceName) {
        InputStream in = ObjectUtilities.getResourceRelativeAsStream((String)resourceName, (Class)(class$org$jfree$report$modules$output$pageable$plaintext$PrinterSpecificationManager != null ? class$org$jfree$report$modules$output$pageable$plaintext$PrinterSpecificationManager : (class$org$jfree$report$modules$output$pageable$plaintext$PrinterSpecificationManager = PrinterSpecificationManager.class$("org.jfree.report.modules.output.pageable.plaintext.PrinterSpecificationManager"))));
        if (in == null) {
            Log.error((Object)("Printer definition is missing: " + resourceName));
            return;
        }
        try {
            this.load(in);
        }
        catch (IOException e) {
            Log.error((Object)("Unable to load printer definition file " + resourceName), (Exception)e);
        }
    }

    private static class GenericPrinterSpecification
    implements PrinterSpecification {
        private PrinterEncoding genericEncoding = new PrinterEncoding("ASCII", "ASCII", "ASCII", new byte[2]);

        public String getDisplayName() {
            return "Generic";
        }

        public PrinterEncoding getEncoding(String encoding) {
            return this.genericEncoding;
        }

        public String getName() {
            return "Generic";
        }

        public boolean isEncodingSupported(String encoding) {
            return true;
        }

        public boolean isFeatureAvailable(String operationName) {
            return true;
        }
    }
}

