/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.meta.MetaBand;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.TableCreator;
import org.jfree.report.util.geom.StrictBounds;

public abstract class AbstractTableCreator
implements TableCreator {
    private boolean empty = true;

    public abstract void beginTable(ReportDefinition var1) throws ReportProcessingException;

    public abstract void close() throws ReportProcessingException;

    public abstract void endTable() throws ReportProcessingException;

    public abstract boolean flush() throws ReportProcessingException;

    public boolean isEmpty() {
        return this.empty;
    }

    public abstract boolean isOpen();

    public abstract void open(ReportDefinition var1) throws ReportProcessingException;

    public void processBand(MetaBand band) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Producer already closed");
        }
        StrictBounds bounds = band.getBounds();
        if (bounds.getHeight() == 0L) {
            return;
        }
        if (this.processBandDefinition(band)) {
            return;
        }
        MetaElement[] l = band.toArray();
        int i = 0;
        while (i < l.length) {
            MetaElement e = l[i];
            if (e instanceof MetaBand) {
                this.processBand((MetaBand)e);
            } else {
                this.processElement(e);
            }
            ++i;
        }
    }

    protected abstract boolean processBandDefinition(MetaBand var1);

    protected abstract void processElement(MetaElement var1);

    protected void setEmpty(boolean b) {
        this.empty = b;
    }
}

