/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.jfree.report.Anchor;
import org.jfree.report.content.Content;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.geom.StrictBounds;

public strictfp class TableCellBackground
extends MetaElement
implements Cloneable {
    private ArrayList anchors;
    private float borderSizeTop;
    private float borderSizeBottom;
    private float borderSizeLeft;
    private float borderSizeRight;
    private Color colorTop;
    private Color colorLeft;
    private Color colorBottom;
    private Color colorRight;
    private StrictBounds cellBounds;
    private Color color;
    private static final Anchor[] EMPTY_ANCHOR_ARRAY = new Anchor[0];

    public TableCellBackground(Content elementContent, ElementStyleSheet style, Color color) {
        super(elementContent, style);
        this.color = color;
        this.cellBounds = new StrictBounds();
        StrictBounds bounds = this.getBounds();
        this.updateBorderPositions(bounds);
    }

    public void addAnchor(Anchor anchor) {
        if (anchor == null) {
            throw new NullPointerException();
        }
        if (this.anchors == null) {
            this.anchors = new ArrayList();
        }
        this.anchors.add(anchor);
    }

    private static Color addColor(Color base, Color paint) {
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        g.drawRect(0, 0, 1, 1);
        g.setColor(base);
        g.drawRect(0, 0, 1, 1);
        g.setColor(paint);
        g.drawRect(0, 0, 1, 1);
        return new Color(img.getRGB(0, 0), true);
    }

    public Object clone() throws CloneNotSupportedException {
        TableCellBackground tb = (TableCellBackground)super.clone();
        tb.cellBounds = (StrictBounds)this.cellBounds.clone();
        if (this.anchors != null) {
            tb.anchors = (ArrayList)this.anchors.clone();
        }
        return tb;
    }

    protected TableCellBackground createMergedInstance(StrictBounds bounds) {
        try {
            TableCellBackground bg = (TableCellBackground)this.clone();
            bg.updateBorderPositions(bounds);
            if (bg.getTopBorderPos() != this.getTopBorderPos()) {
                bg.setBorderTop(null, 0.0f);
            }
            if (bg.getLeftBorderPos() != this.getLeftBorderPos()) {
                bg.setBorderLeft(null, 0.0f);
            }
            if (bg.getRightBorderPos() != this.getRightBorderPos()) {
                bg.setBorderRight(null, 0.0f);
            }
            if (bg.getBottomBorderPos() != this.getBottomBorderPos()) {
                bg.setBorderBottom(null, 0.0f);
            }
            return bg;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone caused an unexpected error.");
        }
    }

    public boolean equals(Object o) {
        block40: {
            block39: {
                boolean bl;
                block38: {
                    TableCellBackground tableCellBackground;
                    block37: {
                        block36: {
                            block35: {
                                boolean bl2;
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                boolean bl3;
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block27: {
                                                                boolean bl4;
                                                                block26: {
                                                                    block25: {
                                                                        block24: {
                                                                            block23: {
                                                                                boolean bl5;
                                                                                block22: {
                                                                                    block21: {
                                                                                        if (this == o) {
                                                                                            return true;
                                                                                        }
                                                                                        if (!(o instanceof TableCellBackground)) {
                                                                                            return false;
                                                                                        }
                                                                                        tableCellBackground = (TableCellBackground)o;
                                                                                        if (this.borderSizeBottom != tableCellBackground.borderSizeBottom) {
                                                                                            return false;
                                                                                        }
                                                                                        if (this.borderSizeLeft != tableCellBackground.borderSizeLeft) {
                                                                                            return false;
                                                                                        }
                                                                                        if (this.borderSizeRight != tableCellBackground.borderSizeRight) {
                                                                                            return false;
                                                                                        }
                                                                                        if (this.borderSizeTop != tableCellBackground.borderSizeTop) {
                                                                                            return false;
                                                                                        }
                                                                                        if (this.color == null) break block21;
                                                                                        bl5 = this.color.equals(tableCellBackground.color) ^ true;
                                                                                        break block22;
                                                                                    }
                                                                                    if (tableCellBackground.color != null) break block23;
                                                                                    bl5 = false;
                                                                                }
                                                                                if (!bl5) break block24;
                                                                            }
                                                                            return false;
                                                                        }
                                                                        if (this.colorBottom == null) break block25;
                                                                        bl4 = this.colorBottom.equals(tableCellBackground.colorBottom) ^ true;
                                                                        break block26;
                                                                    }
                                                                    if (tableCellBackground.colorBottom != null) break block27;
                                                                    bl4 = false;
                                                                }
                                                                if (!bl4) break block28;
                                                            }
                                                            return false;
                                                        }
                                                        if (this.colorLeft == null) break block29;
                                                        bl3 = this.colorLeft.equals(tableCellBackground.colorLeft) ^ true;
                                                        break block30;
                                                    }
                                                    if (tableCellBackground.colorLeft != null) break block31;
                                                    bl3 = false;
                                                }
                                                if (!bl3) break block32;
                                            }
                                            return false;
                                        }
                                        if (this.colorRight == null) break block33;
                                        bl2 = this.colorRight.equals(tableCellBackground.colorRight) ^ true;
                                        break block34;
                                    }
                                    if (tableCellBackground.colorRight != null) break block35;
                                    bl2 = false;
                                }
                                if (!bl2) break block36;
                            }
                            return false;
                        }
                        if (this.colorTop == null) break block37;
                        bl = this.colorTop.equals(tableCellBackground.colorTop) ^ true;
                        break block38;
                    }
                    if (tableCellBackground.colorTop != null) break block39;
                    bl = false;
                }
                if (!bl) break block40;
            }
            return false;
        }
        return true;
    }

    public Anchor[] getAnchors() {
        if (this.anchors == null) {
            return EMPTY_ANCHOR_ARRAY;
        }
        return this.anchors.toArray(new Anchor[this.anchors.size()]);
    }

    public float getBorderSizeBottom() {
        return this.borderSizeBottom;
    }

    public float getBorderSizeLeft() {
        return this.borderSizeLeft;
    }

    public float getBorderSizeRight() {
        return this.borderSizeRight;
    }

    public float getBorderSizeTop() {
        return this.borderSizeTop;
    }

    public long getBottomBorderPos() {
        return this.cellBounds.getY() + this.cellBounds.getHeight();
    }

    public StrictBounds getCellBounds() {
        return this.cellBounds;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColorBottom() {
        return this.colorBottom;
    }

    public Color getColorLeft() {
        return this.colorLeft;
    }

    public Color getColorRight() {
        return this.colorRight;
    }

    public Color getColorTop() {
        return this.colorTop;
    }

    public long getLeftBorderPos() {
        return this.cellBounds.getX();
    }

    public long getRightBorderPos() {
        return this.cellBounds.getX() + this.cellBounds.getWidth();
    }

    public long getTopBorderPos() {
        return this.cellBounds.getY();
    }

    public int hashCode() {
        int result = Float.floatToIntBits(this.borderSizeTop);
        result = 29 * result + Float.floatToIntBits(this.borderSizeBottom);
        result = 29 * result + Float.floatToIntBits(this.borderSizeLeft);
        result = 29 * result + Float.floatToIntBits(this.borderSizeRight);
        result = 29 * result + (this.colorTop != null ? this.colorTop.hashCode() : 0);
        result = 29 * result + (this.colorLeft != null ? this.colorLeft.hashCode() : 0);
        result = 29 * result + (this.colorBottom != null ? this.colorBottom.hashCode() : 0);
        result = 29 * result + (this.colorRight != null ? this.colorRight.hashCode() : 0);
        result = 29 * result + (this.color != null ? this.color.hashCode() : 0);
        return result;
    }

    public TableCellBackground merge(TableCellBackground background, StrictBounds cellBounds) {
        boolean otherIsALine;
        StrictBounds bounds = this.getCellBounds();
        StrictBounds backgroundBounds = background.getCellBounds();
        boolean thisIsALine = bounds.getHeight() == 0L || bounds.getWidth() == 0L;
        boolean bl = otherIsALine = backgroundBounds.getHeight() == 0L || backgroundBounds.getWidth() == 0L;
        Color color = !otherIsALine && !thisIsALine ? (this.getColor() == null ? background.getColor() : (background.getColor() != null ? TableCellBackground.addColor(this.getColor(), background.getColor()) : this.getColor())) : (!thisIsALine ? this.getColor() : background.getColor());
        TableCellBackground merged = this.createMergedInstance(cellBounds);
        merged.color = color;
        if (cellBounds.contains(backgroundBounds.getX(), backgroundBounds.getY()) && background.anchors != null) {
            if (merged.anchors == null) {
                merged.anchors = new ArrayList(background.anchors);
            } else {
                merged.anchors.addAll(background.anchors);
            }
        }
        if (background.getColorTop() != null && background.getTopBorderPos() == merged.getTopBorderPos()) {
            merged.setBorderTop(background.getColorTop(), background.getBorderSizeTop());
        }
        if (background.getColorBottom() != null && background.getBottomBorderPos() == merged.getBottomBorderPos()) {
            merged.setBorderBottom(background.getColorBottom(), background.getBorderSizeBottom());
        }
        if (background.getColorLeft() != null && background.getLeftBorderPos() == merged.getLeftBorderPos()) {
            merged.setBorderLeft(background.getColorLeft(), background.getBorderSizeLeft());
        }
        if (background.getColorRight() != null && background.getRightBorderPos() == merged.getRightBorderPos()) {
            merged.setBorderRight(background.getColorRight(), background.getBorderSizeRight());
        }
        return merged;
    }

    public void setBorderBottom(Color color, float size) {
        if (size == 0.0f) {
            this.colorBottom = null;
            this.borderSizeBottom = 0.0f;
        } else {
            this.colorBottom = color;
            this.borderSizeBottom = size;
        }
    }

    public void setBorderLeft(Color color, float size) {
        if (size == 0.0f) {
            this.colorLeft = null;
            this.borderSizeLeft = 0.0f;
        } else {
            this.colorLeft = color;
            this.borderSizeLeft = size;
        }
    }

    public void setBorderRight(Color color, float size) {
        if (size == 0.0f) {
            this.colorRight = null;
            this.borderSizeRight = 0.0f;
        } else {
            this.colorRight = color;
            this.borderSizeRight = size;
        }
    }

    public void setBorderTop(Color color, float size) {
        if (size == 0.0f) {
            this.colorTop = null;
            this.borderSizeTop = 0.0f;
        } else {
            this.colorTop = color;
            this.borderSizeTop = size;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("TableCellBackground={bounds=");
        b.append(this.getBounds());
        b.append(", color=");
        b.append(this.color);
        b.append(", colorTop=");
        b.append(this.colorTop);
        b.append(", widthTop=");
        b.append(this.borderSizeTop);
        b.append(", colorLeft=");
        b.append(this.colorLeft);
        b.append(", widthLeft=");
        b.append(this.borderSizeLeft);
        b.append(", colorBottom=");
        b.append(this.colorBottom);
        b.append(", widthBottom=");
        b.append(this.borderSizeBottom);
        b.append(", colorRight=");
        b.append(this.colorRight);
        b.append(", widthRight=");
        b.append(this.borderSizeRight);
        b.append("}");
        return b.toString();
    }

    public void updateBorderPositions(StrictBounds bounds) {
        this.cellBounds.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }
}

