/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ShapeElement;
import org.jfree.report.content.AnchorContent;
import org.jfree.report.content.AnchorContentFactoryModule;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.content.ContentType;
import org.jfree.report.content.ShapeContent;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.modules.output.meta.MetaBandProducer;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.Log;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictPoint;

public abstract class TableMetaBandProducer
extends MetaBandProducer {
    public TableMetaBandProducer(LayoutSupport support) {
        super(support);
    }

    protected MetaElement createAnchorCell(Element element, long x, long y) {
        ElementStyleSheet backgroundStyle = this.createStyleForElement(element, x, y);
        StrictBounds bounds = (StrictBounds)backgroundStyle.getStyleProperty(ElementStyleSheet.BOUNDS);
        Content ac = AnchorContentFactoryModule.createAnchor(element.getValue(), new StrictPoint(x + bounds.getX(), y + bounds.getY()));
        if (!(ac instanceof AnchorContent)) {
            return null;
        }
        AnchorContent anchorContent = (AnchorContent)ac;
        TableCellBackground tcb = new TableCellBackground(ac, backgroundStyle, null);
        tcb.addAnchor(anchorContent.getAnchor());
        return tcb;
    }

    public TableCellBackground createBackground(Element e, long x, long y) {
        Content content;
        if (!e.getContentType().equals("shape/generic")) {
            return null;
        }
        ContentFactory cf = this.getLayoutSupport().getContentFactory();
        if (!cf.canHandleContent(e.getContentType())) {
            return null;
        }
        try {
            StrictBounds bounds = this.createElementBounds(e.getStyle(), x, y);
            content = cf.createContentForElement(e, new ElementLayoutInformation(bounds), this.getLayoutSupport());
        }
        catch (ContentCreationException ex) {
            Log.warn("Failed to create content for background.", (Exception)((Object)ex));
            return null;
        }
        if (content.getContentType().equals(ContentType.SHAPE)) {
            return this.createBackgroundFromShape((ShapeContent)content, e, x, y);
        }
        return null;
    }

    protected TableCellBackground createBackgroundFromShape(ShapeContent shapeContent, Element element, long x, long y) {
        ElementStyleSheet backgroundStyle = this.createStyleForElement(element, x, y);
        Color color = (Color)backgroundStyle.getStyleProperty(ElementStyleSheet.PAINT);
        StrictBounds shapeBounds = shapeContent.getBounds();
        Shape shape = shapeContent.getShape();
        MetaElement bg = null;
        if (backgroundStyle.getBooleanStyleProperty(ShapeElement.DRAW_SHAPE)) {
            float strokeWidth;
            Object maybeStroke = backgroundStyle.getStyleProperty(ElementStyleSheet.STROKE);
            if (maybeStroke instanceof BasicStroke) {
                BasicStroke stroke = (BasicStroke)maybeStroke;
                strokeWidth = stroke.getLineWidth();
            } else {
                strokeWidth = 1.0f;
            }
            if (shape instanceof Line2D) {
                if (strokeWidth == 0.0f) {
                    return null;
                }
                if (shapeBounds.getWidth() == 0L && shapeBounds.getHeight() == 0L) {
                    return null;
                }
                if (shapeBounds.getHeight() == 0L) {
                    bg = new TableCellBackground(shapeContent, backgroundStyle, null);
                    ((TableCellBackground)bg).setBorderTop(color, strokeWidth);
                } else if (shapeBounds.getWidth() == 0L) {
                    bg = new TableCellBackground(shapeContent, backgroundStyle, null);
                    ((TableCellBackground)bg).setBorderLeft(color, strokeWidth);
                }
            } else if (shape instanceof Rectangle2D) {
                bg = backgroundStyle.getBooleanStyleProperty(ShapeElement.FILL_SHAPE) ? new TableCellBackground(shapeContent, backgroundStyle, color) : new TableCellBackground(shapeContent, backgroundStyle, null);
                if (strokeWidth > 0.0f) {
                    ((TableCellBackground)bg).setBorderLeft(color, strokeWidth);
                    ((TableCellBackground)bg).setBorderTop(color, strokeWidth);
                    ((TableCellBackground)bg).setBorderBottom(color, strokeWidth);
                    ((TableCellBackground)bg).setBorderRight(color, strokeWidth);
                }
            } else {
                Log.debug("Will not handle shape of type: " + shape);
            }
        } else if (backgroundStyle.getBooleanStyleProperty(ShapeElement.FILL_SHAPE) && shape instanceof Rectangle2D) {
            bg = new TableCellBackground(shapeContent, backgroundStyle, color);
        }
        if (bg != null) {
            bg.setName(element.getName());
        }
        return bg;
    }

    protected abstract MetaElement createDrawableCell(Element var1, long var2, long var4) throws ContentCreationException;

    protected MetaElement createElement(Element e, long x, long y) throws ContentCreationException {
        if (!e.isVisible()) {
            return null;
        }
        if (e.getContentType().equals("shape/generic")) {
            return this.createBackground(e, x, y);
        }
        if (e.getContentType().equals("drawable/generic")) {
            return this.createDrawableCell(e, x, y);
        }
        if (e.getContentType().equals("image/generic")) {
            return this.createImageCell(e, x, y);
        }
        if (e.getContentType().equals("text/plain")) {
            return this.createTextCell(e, x, y);
        }
        if (e.getContentType().equals("X-Anchor")) {
            return this.createAnchorCell(e, x, y);
        }
        return null;
    }

    protected abstract MetaElement createImageCell(Element var1, long var2, long var4) throws ContentCreationException;

    protected abstract MetaElement createTextCell(Element var1, long var2, long var4) throws ContentCreationException;
}

