/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import com.keypoint.PngEncoder;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import org.jfree.io.IOUtils;
import org.jfree.report.ImageContainer;
import org.jfree.report.LocalImageContainer;
import org.jfree.report.URLImageContainer;
import org.jfree.report.modules.output.table.html.HtmlFilesystem;
import org.jfree.report.modules.output.table.html.ref.EmptyContentReference;
import org.jfree.report.modules.output.table.html.ref.ExternalStyleSheetReference;
import org.jfree.report.modules.output.table.html.ref.HtmlImageReference;
import org.jfree.report.modules.output.table.html.ref.HtmlReference;
import org.jfree.report.modules.output.table.html.util.CounterReference;
import org.jfree.report.resourceloader.ImageFactory;
import org.jfree.report.util.ImageComparator;
import org.jfree.report.util.StringUtil;
import org.jfree.util.WaitingImageObserver;

public class DirectoryHtmlFilesystem
implements HtmlFilesystem {
    private File rootFile;
    private File dataDirectory;
    private FileOutputStream rootStream;
    private final HashMap usedNames = new HashMap();
    private final HashMap usedImages = new HashMap();
    private final HashMap encodedImages = new HashMap();
    private final ImageComparator comparator = new ImageComparator();
    private boolean copyExternalImages;
    private boolean digestImageCompare;

    public DirectoryHtmlFilesystem(File file) throws IOException {
        this(file, file.getAbsoluteFile().getParentFile());
    }

    public DirectoryHtmlFilesystem(File file, File dataDirectory) throws IOException {
        if (file.exists() && !file.isFile()) {
            throw new IOException("The given file-parameter does not point to a data file: " + file);
        }
        this.rootFile = file;
        if (dataDirectory == null) {
            this.dataDirectory = file.getCanonicalFile().getParentFile();
            if (this.dataDirectory == null) {
                throw new IOException("Unable to resolve the data directory. Cannot proceed.");
            }
        } else {
            this.dataDirectory = dataDirectory;
        }
    }

    public void close() throws IOException {
        this.rootStream.close();
    }

    public HtmlReference createCSSReference(String styleSheet) throws IOException {
        File refFile = new File(this.dataDirectory, String.valueOf(this.createName("style")) + ".css");
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(refFile));
        ((OutputStream)fout).write(styleSheet.getBytes());
        ((OutputStream)fout).close();
        String baseName = IOUtils.getInstance().createRelativeURL(refFile.toURL(), this.rootFile.toURL());
        return new ExternalStyleSheetReference(baseName);
    }

    public HtmlReference createImageReference(ImageContainer reference) throws IOException {
        if (reference instanceof URLImageContainer) {
            URLImageContainer urlImage = (URLImageContainer)reference;
            URL url = urlImage.getSourceURL();
            if (url != null) {
                String name = (String)this.usedImages.get(url);
                if (name != null) {
                    return new HtmlImageReference(name);
                }
                if (this.isSupportedImageFormat(urlImage.getSourceURL())) {
                    if (this.isCopyExternalImages() && urlImage.isLoadable()) {
                        File dataFile = new File(this.dataDirectory, this.createName(IOUtils.getInstance().getFileName(url)));
                        BufferedInputStream urlIn = new BufferedInputStream(urlImage.getSourceURL().openStream());
                        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(dataFile));
                        IOUtils.getInstance().copyStreams((InputStream)urlIn, (OutputStream)fout);
                        ((InputStream)urlIn).close();
                        ((OutputStream)fout).close();
                        String filename = IOUtils.getInstance().createRelativeURL(dataFile.toURL(), this.rootFile.toURL());
                        this.usedImages.put(url, filename);
                        return new HtmlImageReference(filename);
                    }
                    String baseName = IOUtils.getInstance().createRelativeURL(url, this.rootFile.toURL());
                    this.usedImages.put(url, baseName);
                    return new HtmlImageReference(baseName);
                }
                if (!urlImage.isLoadable()) {
                    return new EmptyContentReference();
                }
                Image image = null;
                if (reference instanceof LocalImageContainer) {
                    LocalImageContainer li = (LocalImageContainer)reference;
                    image = li.getImage();
                }
                if (image == null) {
                    image = ImageFactory.getInstance().createImage(url);
                }
                if (image != null) {
                    String entryName = this.encodeImage(image, false);
                    this.usedImages.put(url, entryName);
                    return new HtmlImageReference(entryName);
                }
            } else if (urlImage.getSourceURLString() != null) {
                return new HtmlImageReference(urlImage.getSourceURLString());
            }
        }
        if (reference instanceof LocalImageContainer) {
            LocalImageContainer li = (LocalImageContainer)reference;
            Image image = li.getImage();
            if (image == null) {
                return new EmptyContentReference();
            }
            if (li.isIdentifiable()) {
                Object identity = li.getIdentity();
                String name = (String)this.usedImages.get(identity);
                if (name == null) {
                    name = this.encodeImage(image, false);
                    this.usedImages.put(identity, name);
                }
                return new HtmlImageReference(name);
            }
            return new HtmlImageReference(this.encodeImage(image, true));
        }
        return new EmptyContentReference();
    }

    private String createName(String base) {
        CounterReference ref = (CounterReference)this.usedNames.get(base);
        if (ref == null) {
            ref = new CounterReference();
            this.usedNames.put(base, ref);
            return base;
        }
        ref.increase();
        return String.valueOf(base) + ref.getCount();
    }

    private String encodeImage(Image image, boolean createComparator) throws IOException {
        Object object;
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        PngEncoder encoder = new PngEncoder(image, true, 0, 5);
        byte[] data = encoder.pngEncode();
        if (createComparator) {
            object = this.comparator.createCompareData(data, !this.isDigestImageCompare());
            String name = (String)this.encodedImages.get(object);
            if (name != null) {
                return name;
            }
        } else {
            object = null;
        }
        File dataFile = new File(this.dataDirectory, String.valueOf(this.createName("picture")) + ".png");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dataFile));
        ((OutputStream)out).write(data);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        String name = IOUtils.getInstance().createRelativeURL(dataFile.toURL(), this.rootFile.toURL());
        if (createComparator) {
            this.encodedImages.put(object, name);
        }
        return name;
    }

    public OutputStream getRootStream() throws IOException {
        if (this.rootStream == null) {
            this.rootStream = new FileOutputStream(this.rootFile);
        }
        return this.rootStream;
    }

    public boolean isCopyExternalImages() {
        return this.copyExternalImages;
    }

    public boolean isDigestImageCompare() {
        return this.digestImageCompare;
    }

    protected boolean isSupportedImageFormat(URL url) {
        String file = url.getFile();
        if (StringUtil.endsWithIgnoreCase(file, ".jpg")) {
            return true;
        }
        if (StringUtil.endsWithIgnoreCase(file, ".jpeg")) {
            return true;
        }
        if (StringUtil.endsWithIgnoreCase(file, ".png")) {
            return true;
        }
        return StringUtil.endsWithIgnoreCase(file, ".gif");
    }

    public void setCopyExternalImages(boolean copyExternalImages) {
        this.copyExternalImages = copyExternalImages;
    }

    public void setDigestImageCompare(boolean digestImageCompare) {
        this.digestImageCompare = digestImageCompare;
    }
}

