/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.report.Anchor;
import org.jfree.report.ReportDefinition;
import org.jfree.report.function.FunctionProcessingException;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.GenericObjectTable;
import org.jfree.report.modules.output.table.base.SheetLayoutCollection;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.base.TableContentCreator;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.report.modules.output.table.html.HtmlFilesystem;
import org.jfree.report.modules.output.table.html.HtmlSheetLayout;
import org.jfree.report.modules.output.table.html.HtmlStyle;
import org.jfree.report.modules.output.table.html.HtmlStyleCollection;
import org.jfree.report.modules.output.table.html.HtmlTableCellStyle;
import org.jfree.report.modules.output.table.html.HtmlTableRowStyle;
import org.jfree.report.modules.output.table.html.metaelements.HtmlMetaElement;
import org.jfree.report.modules.output.table.html.ref.HtmlReference;
import org.jfree.report.modules.output.table.html.util.HtmlCharacterEntities;
import org.jfree.report.modules.output.table.html.util.HtmlEncoderUtil;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.geom.StrictGeomUtility;

public class HtmlContentCreator
extends TableContentCreator {
    private static final String[] XHTML_HEADER = new String[]{"<!DOCTYPE html", "     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"", "     \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">", "<html xmlns=\"http://www.w3.org/1999/xhtml\">", "<head>"};
    private static final String[] HTML4_HEADER = new String[]{"<!DOCTYPE HTML ", "     PUBLIC \"-//W3C//DTD HTML 4.01//EN\"", "     \"http://www.w3.org/TR/html4/strict.dtd\">", "<html>", "<head>"};
    private HtmlFilesystem filesystem;
    private boolean useXHTML;
    private boolean isOpen;
    private boolean createBodyFragment;
    private boolean emptyCellsUseCSS;
    private PrintWriter pout;
    private HtmlStyleCollection styleCollection;
    private boolean tableRowBorderDefinition;

    public HtmlContentCreator(HtmlFilesystem filesystem, boolean useXHTML, HtmlStyleCollection styles, SheetLayoutCollection sheetLayoutCollection) {
        super(sheetLayoutCollection);
        if (filesystem == null) {
            throw new NullPointerException();
        }
        if (sheetLayoutCollection == null) {
            throw new NullPointerException();
        }
        if (styles == null) {
            throw new NullPointerException();
        }
        this.filesystem = filesystem;
        this.useXHTML = useXHTML;
        this.styleCollection = styles;
    }

    private HtmlReference buildGlobalStyleSheet() throws IOException {
        StringWriter cssbuffer = new StringWriter();
        PrintWriter csswriter = new PrintWriter(cssbuffer);
        TreeMap stylesSorted = this.styleCollection.getSortedStyleMap();
        Iterator styles = stylesSorted.entrySet().iterator();
        while (styles.hasNext()) {
            Map.Entry entry = styles.next();
            HtmlStyle style = (HtmlStyle)entry.getValue();
            String name = (String)entry.getKey();
            csswriter.print(name);
            csswriter.println(" {");
            csswriter.println(style.getCSSString(false));
            csswriter.println("}");
            csswriter.println();
        }
        return this.filesystem.createCSSReference(cssbuffer.toString());
    }

    protected PrintWriter getPrintWriter() {
        return this.pout;
    }

    protected void handleBeginTable(ReportDefinition reportDefinition) {
        String style;
        HtmlSheetLayout layout;
        int noc;
        String sheetName = null;
        if (this.getSheetNameFunction() != null) {
            sheetName = String.valueOf(reportDefinition.getDataRow().get(this.getSheetNameFunction()));
        }
        if (sheetName != null) {
            this.pout.println(this.isUseXHTML() ? "<hr />" : "<hr>");
            this.pout.println("<h3>");
            this.pout.println(sheetName);
            this.pout.println("</h3>");
            this.pout.println(this.isUseXHTML() ? "<hr />" : "<hr>");
        }
        if ((noc = (layout = (HtmlSheetLayout)this.getCurrentLayout()).getColumnCount()) > 0) {
            int width = (int)StrictGeomUtility.toExternalValue(layout.getCellWidth(0, noc));
            style = "width: " + width + "pt;";
        } else {
            style = "";
        }
        style = String.valueOf(style) + "table-layout: fixed;";
        if (this.emptyCellsUseCSS) {
            style = String.valueOf(style) + "empty-cells: show";
        }
        this.pout.print("<table cellspacing=\"0\" cellpadding=\"0\" style=\"");
        this.pout.print(style);
        this.pout.println("\">");
        this.pout.print("<colgroup span=\"");
        this.pout.print(noc);
        this.pout.println("\">");
        int i = 0;
        while (i < noc) {
            int width = (int)StrictGeomUtility.toExternalValue(layout.getCellWidth(i, i + 1));
            this.pout.print("<col style=\"");
            this.pout.print("width:");
            this.pout.print(width);
            if (this.isUseXHTML()) {
                this.pout.println("pt\" />");
            } else {
                this.pout.println("pt\">");
            }
            ++i;
        }
        this.pout.println("</colgroup>");
    }

    public void handleClose() {
        try {
            if (!this.createBodyFragment) {
                this.pout.println("</body>");
                this.pout.println("</html>");
            }
            this.pout.flush();
            this.filesystem.close();
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Failed to write on close.", ioe);
        }
        this.isOpen = false;
    }

    protected void handleEndTable() {
        this.pout.println("</table>");
    }

    public boolean handleFlush() {
        int layoutOffset;
        HtmlSheetLayout layout = (HtmlSheetLayout)this.getCurrentLayout();
        GenericObjectTable go = this.getBackend();
        int height = go.getRowCount();
        int width = Math.max(go.getColumnCount(), layout.getColumnCount());
        int y = layoutOffset = this.getLayoutOffset();
        while (y < layoutOffset + height) {
            this.printRowStart(y, width);
            int x = 0;
            while (x < width) {
                MetaElement element = (MetaElement)go.getObject(y - layoutOffset, x);
                if (element == null) {
                    this.printEmptyCell(x, y);
                } else {
                    TableRectangle rectangle = layout.getTableBounds(element, this.getLookupRectangle());
                    if (!rectangle.isOrigin(x, y)) {
                        if (this.isDebugReportLayout()) {
                            this.pout.println("<!-- Spanned cell @(" + x + ", " + y + ") ignored. -->");
                        }
                    } else {
                        if (this.isDebugReportLayout()) {
                            this.pout.println("<!-- cell @(" + x + ", " + y + ") [" + rectangle + "] -->");
                        }
                        this.printContentCellStart(rectangle, x, y);
                        String internalStyleName = layout.getContentStyleAt(y, x);
                        HtmlStyle style = layout.getStyleCollection().lookupStyle(internalStyleName);
                        String cellStyleName = layout.getStyleCollection().getPublicName(style);
                        String hrefTarget = (String)element.getProperty(ElementStyleSheet.HREF_TARGET);
                        if (hrefTarget != null) {
                            this.pout.print("<a href=\"");
                            this.pout.print(hrefTarget);
                            this.pout.print("\">");
                        }
                        if (cellStyleName != null && !this.isCreateBodyFragment()) {
                            this.pout.print("<div class=\"");
                            this.pout.print(cellStyleName);
                            this.pout.print("\">");
                        } else if (style != null) {
                            this.pout.print("<div style=\"");
                            this.pout.print(style.getCSSString(true));
                            this.pout.print("\">");
                        } else {
                            this.pout.print("<div>");
                        }
                        if (element instanceof HtmlMetaElement) {
                            HtmlMetaElement htmlElement = (HtmlMetaElement)element;
                            htmlElement.write(this.pout, this.filesystem, this.emptyCellsUseCSS);
                        } else if (this.isDebugReportLayout()) {
                            this.pout.println("<!-- Invalid element @(" + x + ", " + y + ") -->&nbsp;");
                        }
                        this.pout.println("</div>");
                        if (hrefTarget != null) {
                            this.pout.println("</a>");
                        }
                        this.pout.println("</td>");
                    }
                }
                ++x;
            }
            this.pout.println("</tr>");
            ++y;
        }
        return true;
    }

    public void handleOpen(ReportDefinition report) {
        block14: {
            this.isOpen = true;
            ReportConfiguration config = report.getReportConfiguration();
            this.createBodyFragment = config.getConfigProperty("org.jfree.report.modules.output.table.html.BodyFragment", "false").equals("true");
            this.emptyCellsUseCSS = config.getConfigProperty("org.jfree.report.modules.output.table.html.EmptyCellsUseCSS", "false").equals("true");
            this.tableRowBorderDefinition = config.getConfigProperty("org.jfree.report.modules.output.table.html.TableRowBorderDefinition", "false").equals("true");
            String encoding = config.getConfigProperty("org.jfree.report.modules.output.table.html.Encoding", "UTF-8");
            String title = config.getConfigProperty("org.jfree.report.modules.output.table.html.Title");
            try {
                int i;
                this.pout = new PrintWriter((Writer)new OutputStreamWriter(this.filesystem.getRootStream(), encoding), false);
                if (this.createBodyFragment) break block14;
                if (this.isUseXHTML()) {
                    this.pout.print("<?xml version=\"1.0\" encoding=\"");
                    this.pout.print(encoding);
                    this.pout.println("\"?>");
                    i = 0;
                    while (i < XHTML_HEADER.length) {
                        this.pout.println(XHTML_HEADER[i]);
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < HTML4_HEADER.length) {
                        this.pout.println(HTML4_HEADER[i]);
                        ++i;
                    }
                }
                this.pout.print("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
                this.pout.print(encoding);
                if (this.isUseXHTML()) {
                    this.pout.println("\" />");
                } else {
                    this.pout.println("\">");
                }
                this.pout.print("<title>");
                if (title != null) {
                    this.pout.print(HtmlCharacterEntities.getEntityParser().encodeEntities(title));
                } else {
                    this.pout.print(report.getProperties().get("report.name", "<unnamed>"));
                }
                this.pout.println("</title>");
                HtmlReference cssRef = this.buildGlobalStyleSheet();
                if (cssRef.isExternal()) {
                    this.pout.print("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                    this.pout.print(cssRef.getReferenceData());
                    if (this.isUseXHTML()) {
                        this.pout.println("\" />");
                    } else {
                        this.pout.println("\">");
                    }
                } else {
                    this.pout.println("<style type=\"text/css\">");
                    this.pout.print(cssRef.getReferenceData());
                    this.pout.println("</style>");
                }
                this.pout.println("</head>");
                this.pout.println("<body>");
            }
            catch (IOException ioe) {
                throw new FunctionProcessingException("Failed to create the writer or write the header.", ioe);
            }
        }
    }

    public boolean isCreateBodyFragment() {
        return this.createBodyFragment;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isUseXHTML() {
        return this.useXHTML;
    }

    private boolean printAnchors(TableCellBackground bg) {
        if (bg == null) {
            return false;
        }
        Anchor[] anchors = bg.getAnchors();
        int i = 0;
        while (i < anchors.length) {
            this.pout.print("<a name=\"");
            HtmlEncoderUtil.printText(this.pout, anchors[i].getName(), this.isUseXHTML());
            if (this.isUseXHTML()) {
                this.pout.println("\" />");
            } else {
                this.pout.println("\" >");
            }
            ++i;
        }
        return anchors.length != 0;
    }

    private void printContentCellStart(TableRectangle rectangle, int x, int y) {
        String cellStyleName;
        HtmlSheetLayout layout = (HtmlSheetLayout)this.getCurrentLayout();
        if (this.isDebugReportLayout()) {
            this.pout.println("<!-- content cell @(" + x + "," + y + ") -->");
        }
        this.pout.print("<td ");
        if (rectangle.getRowSpan() > 1) {
            this.pout.print("rowspan=\"");
            this.pout.print(rectangle.getRowSpan());
            this.pout.print("\" ");
        }
        if (rectangle.getColumnSpan() > 1) {
            this.pout.print("colspan=\"");
            this.pout.print(rectangle.getColumnSpan());
            this.pout.print("\" ");
        }
        String internalStyleName = layout.getBackgroundStyleAt(y, x);
        HtmlStyle style = layout.getStyleCollection().lookupStyle(internalStyleName);
        TableCellBackground background = layout.getRegionBackground(rectangle);
        if (style == null) {
            style = new HtmlTableCellStyle(background);
        }
        if ((cellStyleName = layout.getStyleCollection().getPublicName(style)) != null && !this.isCreateBodyFragment()) {
            this.pout.print("class=\"");
            this.pout.print(cellStyleName);
            this.pout.println("\">");
        } else {
            this.pout.print("style=\"");
            this.pout.print(style.getCSSString(true));
            this.pout.println("\">");
        }
        this.printAnchors(background);
    }

    private void printEmptyCell(int x, int y) {
        HtmlSheetLayout layout = (HtmlSheetLayout)this.getCurrentLayout();
        TableCellBackground background = layout.getElementAt(y, x);
        String internalStyleName = layout.getBackgroundStyleAt(y, x);
        HtmlStyle style = layout.getStyleCollection().lookupStyle(internalStyleName);
        if (style == null) {
            style = new HtmlTableCellStyle(background);
        }
        String cellStyleName = layout.getStyleCollection().getPublicName(style);
        if (this.isDebugReportLayout()) {
            this.pout.println("<!-- empty cell @(" + x + "," + y + ")-->");
        }
        if (cellStyleName != null && !this.isCreateBodyFragment()) {
            this.pout.print("<td class=\"");
            this.pout.print(cellStyleName);
        } else {
            this.pout.print("<td style=\"");
            this.pout.print(style.getCSSString(true));
        }
        this.pout.println("\">");
        this.printAnchors(background);
        if (!this.emptyCellsUseCSS) {
            this.pout.println("&nbsp;</td>");
        } else {
            this.pout.println("</td>");
        }
    }

    private void printRowStart(int y, int tableWidth) {
        HtmlTableRowStyle rowStyle;
        HtmlSheetLayout layout = (HtmlSheetLayout)this.getCurrentLayout();
        int lastRowHeight = (int)StrictGeomUtility.toExternalValue(layout.getRowHeight(y));
        TableRectangle rect = new TableRectangle(0, tableWidth, y, y + 1);
        TableCellBackground regionStyle = layout.getRegionBackground(rect);
        if (regionStyle == null) {
            rowStyle = new HtmlTableRowStyle(lastRowHeight, null, this.tableRowBorderDefinition);
        } else {
            rowStyle = new HtmlTableRowStyle(lastRowHeight, regionStyle.getColor(), this.tableRowBorderDefinition);
            rowStyle.setBorderTop(regionStyle.getColorTop(), regionStyle.getBorderSizeTop());
            rowStyle.setBorderBottom(regionStyle.getColorBottom(), regionStyle.getBorderSizeBottom());
        }
        String trStyleClass = this.styleCollection.getPublicName(rowStyle);
        if (trStyleClass != null && !this.isCreateBodyFragment()) {
            this.pout.print("<tr class=\"");
            this.pout.print(trStyleClass);
            this.pout.println("\">");
        } else {
            this.pout.print("<tr style=\"");
            this.pout.print(rowStyle.getCSSString(true));
            this.pout.println("\">");
        }
    }
}

