/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.awt.Color;
import java.util.HashSet;
import org.jfree.report.ElementAlignment;
import org.jfree.report.content.Content;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.GenericObjectTable;
import org.jfree.report.modules.output.table.base.RawContent;
import org.jfree.report.modules.output.table.base.SheetLayout;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.report.modules.output.table.html.HtmlContentStyle;
import org.jfree.report.modules.output.table.html.HtmlStyleCollection;
import org.jfree.report.modules.output.table.html.HtmlTableCellStyle;
import org.jfree.report.modules.output.table.html.HtmlTableRowStyle;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.util.ObjectUtilities;

public strictfp class HtmlSheetLayout
extends SheetLayout {
    private HtmlStyleCollection styleCollection;
    private TableRectangle rectangle;
    private GenericObjectTable backgroundStyleTable;
    private GenericObjectTable contentStyleTable;
    private boolean tableRowBorderDefinition;

    public HtmlSheetLayout(boolean strict, HtmlStyleCollection collection, boolean tableRowBorderDefinition) {
        super(strict);
        if (collection == null) {
            throw new NullPointerException();
        }
        this.styleCollection = collection;
        this.rectangle = new TableRectangle();
        this.contentStyleTable = new GenericObjectTable();
        this.backgroundStyleTable = new GenericObjectTable();
        this.tableRowBorderDefinition = tableRowBorderDefinition;
    }

    public void add(MetaElement element) {
        RawContent rawContent;
        super.add(element);
        if (element instanceof TableCellBackground) {
            return;
        }
        Content co = element.getContent();
        if (co instanceof RawContent && (rawContent = (RawContent)co).getContent() instanceof String) {
            this.addStringContentStyle(element);
        }
    }

    private void addStringContentStyle(MetaElement element) {
        FontDefinition font = element.getFontDefinitionProperty();
        Color color = (Color)element.getProperty(ElementStyleSheet.PAINT);
        ElementAlignment valign = (ElementAlignment)element.getProperty(ElementStyleSheet.VALIGNMENT);
        ElementAlignment halign = (ElementAlignment)element.getProperty(ElementStyleSheet.ALIGNMENT);
        HtmlContentStyle style = new HtmlContentStyle(font, color, valign, halign);
        String styleName = this.styleCollection.addContentStyle(style);
        TableRectangle rect = this.getTableBounds(element, this.rectangle);
        int y = rect.getY1();
        while (y < rect.getY2()) {
            int row = this.mapRow(y);
            int x = rect.getX1();
            while (x < rect.getX2()) {
                int column = this.mapColumn(x);
                if (this.contentStyleTable.getObject(row, column) == null) {
                    this.contentStyleTable.setObject(row, column, styleName);
                }
                ++x;
            }
            ++y;
        }
    }

    protected void columnInserted(long coordinate, int oldColumn, int newColumn) {
        super.columnInserted(coordinate, oldColumn, newColumn);
        this.contentStyleTable.copyColumn(oldColumn, newColumn);
        this.backgroundStyleTable.copyColumn(oldColumn, newColumn);
    }

    public String getBackgroundStyleAt(int row, int column) {
        return (String)this.backgroundStyleTable.getObject(row, column);
    }

    public String getContentStyleAt(int row, int column) {
        return (String)this.contentStyleTable.getObject(this.mapRow(row), this.mapColumn(column));
    }

    public HtmlStyleCollection getStyleCollection() {
        return this.styleCollection;
    }

    public boolean isTableRowBorderDefinition() {
        return this.tableRowBorderDefinition;
    }

    public void pageCompleted() {
        this.removeAuxilaryBounds();
        Long[] yCuts = this.getYCuts();
        if (yCuts.length == 0) {
            this.clearObjectIdTable();
            return;
        }
        HashSet<TableCellBackground> completedElements = new HashSet<TableCellBackground>();
        TableRectangle rect = null;
        int layoutRow = 0;
        while (layoutRow < this.getRowCount()) {
            Color rowColor = null;
            Color borderTop = null;
            Color borderBottom = null;
            float borderTopSize = 0.0f;
            float borderBottomSize = 0.0f;
            int layoutCol = 0;
            while (layoutCol < this.getColumnCount()) {
                SheetLayout.CellReference reference = this.getContentAt(layoutRow, layoutCol);
                TableCellBackground bg = reference != null ? ((rect = this.getTableBounds(reference.getBounds(), rect)).getColumnSpan() == 1 && rect.getRowSpan() == 1 ? this.getElementAt(layoutRow, layoutCol) : this.getRegionBackground(rect)) : this.getElementAt(layoutRow, layoutCol);
                if (bg != null) {
                    Color bgColor = bg.getColor();
                    if (layoutCol == 0) {
                        rowColor = bgColor;
                        borderTopSize = bg.getBorderSizeTop();
                        borderTop = bg.getColorTop();
                        borderBottom = bg.getColorBottom();
                        borderBottomSize = bg.getBorderSizeBottom();
                    } else {
                        if (!ObjectUtilities.equal((Object)bgColor, (Object)rowColor)) {
                            rowColor = null;
                        }
                        if (!ObjectUtilities.equal((Object)borderTop, (Object)bg.getColorTop())) {
                            borderTop = null;
                            borderTopSize = 0.0f;
                        }
                        if (!ObjectUtilities.equal((Object)borderBottom, (Object)bg.getColorBottom())) {
                            borderBottom = null;
                            borderBottomSize = 0.0f;
                        }
                    }
                    if (!completedElements.contains(bg)) {
                        HtmlTableCellStyle style = new HtmlTableCellStyle(bg);
                        String styleName = this.styleCollection.addCellStyle(style);
                        this.backgroundStyleTable.setObject(layoutRow, layoutCol, styleName);
                        completedElements.add(bg);
                    }
                }
                ++layoutCol;
            }
            int height = (int)Math.ceil(StrictGeomUtility.toExternalValue(this.getRowHeight(layoutRow)));
            HtmlTableRowStyle style = new HtmlTableRowStyle(height, rowColor, this.tableRowBorderDefinition);
            style.setBorderTop(borderTop, borderTopSize);
            style.setBorderBottom(borderBottom, borderBottomSize);
            this.styleCollection.addRowStyle(style);
            ++layoutRow;
        }
        this.clearObjectIdTable();
    }

    protected void rowInserted(long coordinate, int oldRow, int newRow) {
        super.rowInserted(coordinate, oldRow, newRow);
        this.contentStyleTable.copyRow(oldRow, newRow);
        this.backgroundStyleTable.copyRow(oldRow, newRow);
    }
}

