/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.xml;

import java.io.IOException;
import java.io.Writer;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.Group;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.util.CharacterEntityParser;
import org.jfree.report.util.Log;

public class XMLWriter
extends AbstractFunction {
    private Writer w;
    private int depLevel;
    private final CharacterEntityParser entityParser;

    public XMLWriter() {
        this.setDependencyLevel(-1);
        this.entityParser = CharacterEntityParser.createXMLEntityParser();
    }

    public int getDependencyLevel() {
        return this.depLevel;
    }

    public Object getValue() {
        return this;
    }

    public Writer getWriter() {
        return this.w;
    }

    public void groupFinished(ReportEvent event) {
        try {
            this.w.write("<groupfooter name=\"");
            Group g = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
            this.w.write(this.entityParser.encodeEntities(g.getName()));
            this.w.write("\">");
            this.writeBand(g.getFooter());
            this.w.write("</groupfooter>");
        }
        catch (IOException ioe) {
            Log.error("Error writing the band", ioe);
        }
    }

    public void groupStarted(ReportEvent event) {
        try {
            this.w.write("<groupheader name=\"");
            Group g = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
            this.w.write(this.entityParser.encodeEntities(g.getName()));
            this.w.write("\">");
            this.writeBand(g.getHeader());
            this.w.write("</groupheader>");
        }
        catch (IOException ioe) {
            Log.error("Error writing the band", ioe);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        try {
            this.w.write("<itemband>");
            this.writeBand(event.getReport().getItemBand());
            this.w.write("</itemband>");
        }
        catch (IOException ioe) {
            Log.error("Error writing the band", ioe);
        }
    }

    public void itemsFinished(ReportEvent event) {
        try {
            this.w.write("</items>");
        }
        catch (IOException ioe) {
            Log.error("Error writing the items tag", ioe);
        }
    }

    public void itemsStarted(ReportEvent event) {
        try {
            this.w.write("<items>");
        }
        catch (IOException ioe) {
            Log.error("Error writing the items tag", ioe);
        }
    }

    public void reportFinished(ReportEvent event) {
        try {
            this.w.write("<reportfooter>");
            this.writeBand(event.getReport().getReportFooter());
            this.w.write("</reportfooter>");
            this.w.write("</report>");
        }
        catch (IOException ioe) {
            Log.error("Error writing the band", ioe);
        }
    }

    public void reportStarted(ReportEvent event) {
        try {
            this.w.write("<report>");
            this.w.write("<reportheader>");
            this.writeBand(event.getReport().getReportHeader());
            this.w.write("</reportheader>");
        }
        catch (IOException ioe) {
            Log.error("Error writing the band", ioe);
        }
    }

    public void setDependencyLevel(int deplevel) {
        this.depLevel = deplevel;
    }

    public void setWriter(Writer w) {
        this.w = w;
    }

    private void writeBand(Band b) throws IOException {
        Element[] elements = b.getElementArray();
        int i = 0;
        while (i < elements.length) {
            Element e = elements[i];
            if (e.getContentType().startsWith("text")) {
                this.w.write("<element name=\"");
                this.w.write(this.entityParser.encodeEntities(e.getName()));
                this.w.write("\">");
                this.w.write(this.entityParser.encodeEntities(String.valueOf(e.getValue())));
                this.w.write("</element>");
            } else if (e instanceof Band) {
                this.w.write("<band>");
                this.writeBand((Band)e);
                this.w.write("</band>");
            }
            ++i;
        }
    }
}

