/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.base.common;

import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.base.PropertyStringReadHandler;
import org.jfree.report.util.CharacterEntityParser;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.BeanUtility;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.ParseException;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class ExpressionPropertyReadHandler
extends PropertyStringReadHandler {
    public static final String NAME_ATT = "name";
    public static final String CLASS_ATT = "class";
    private BeanUtility beanUtility;
    private CharacterEntityParser entityParser;
    private String propertyName;
    private String expressionName;

    public ExpressionPropertyReadHandler(BeanUtility expression, String expressionName, CharacterEntityParser entityParser, CommentHintPath expressionHintPath) {
        super(expressionHintPath);
        this.expressionName = expressionName;
        this.beanUtility = expression;
        this.entityParser = entityParser;
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        super.doneParsing();
        String result = this.getResult();
        if (this.beanUtility == null) {
            throw new ParseException("No current beanUtility");
        }
        try {
            this.beanUtility.setPropertyAsString(this.propertyName, this.entityParser.decodeEntities(result));
        }
        catch (BeanException e) {
            throw new ParseException("Unable to assign property '" + this.propertyName + "' to expression '" + this.expressionName + "'", (Exception)((Object)e));
        }
    }

    public Object getObject() {
        return null;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException, XmlReaderException {
        super.startParsing(attrs);
        this.propertyName = attrs.getValue(NAME_ATT);
        if (this.propertyName == null) {
            throw new ElementDefinitionException("Required attribute 'name' is null.");
        }
        this.getHintPath().addName(this.propertyName);
    }
}

