/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.jfree.report.function.Expression;
import org.jfree.report.function.ExpressionCollection;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.jfree.report.modules.parser.extwriter.ObjectWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.report.util.ReportProperties;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.BeanUtility;
import org.jfree.xml.factory.objects.ClassFactoryCollector;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.writer.AttributeList;

public class FunctionsWriter
extends AbstractXMLDefinitionWriter {
    private static final CommentHintPath FUNCTIONS_PATH = new CommentHintPath(new String[]{"report-definition", "functions"});
    private final ClassFactoryCollector cfc = this.getReportWriter().getClassFactoryCollector();
    static /* synthetic */ Class class$java$lang$String;

    public FunctionsWriter(ReportWriter reportWriter, int indentLevel) {
        super(reportWriter, indentLevel);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private boolean isBasicObject(ObjectDescription od) {
        Iterator odNames = od.getParameterNames();
        if (!odNames.hasNext()) {
            return false;
        }
        String param = (String)odNames.next();
        if (odNames.hasNext()) {
            return false;
        }
        return param.equals("value") && od.getParameterDefinition("value").equals(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = FunctionsWriter.class$("java.lang.String")));
    }

    private boolean shouldWriteFunctions() {
        if (this.getReport().getProperties().containsMarkedProperties()) {
            return true;
        }
        return this.getReport().getExpressions().size() != 0;
    }

    public void write(Writer writer) throws IOException, ReportWriterException {
        this.writeComment(writer, FUNCTIONS_PATH, "parser.comment.open");
        if (this.shouldWriteFunctions()) {
            this.writeTag(writer, "functions");
            this.writePropertyRefs(writer);
            this.writeExpressions(writer, this.getReport().getExpressions());
            this.writeComment(writer, FUNCTIONS_PATH, "parser.comment.close");
            this.writeCloseTag(writer, "functions");
        }
    }

    private void writeExpressionParameters(Writer writer, CommentHintPath path, String[] propertyNames, BeanUtility beanUtility) throws IOException, BeanException {
        CommentHintPath propertiesPath = path.getInstance();
        propertiesPath.addName("properties");
        this.writeComment(writer, propertiesPath, "parser.comment.open");
        this.writeTag(writer, "properties");
        int i = 0;
        while (i < propertyNames.length) {
            String key = propertyNames[i];
            String value = beanUtility.getPropertyAsString(key);
            if (value != null) {
                CommentHintPath propertyPath = propertiesPath.getInstance();
                propertyPath.addName(key);
                this.writeComment(writer, propertyPath, "parser.comment.open");
                this.writeTag(writer, "property", "name", key, false);
                writer.write(AbstractXMLDefinitionWriter.normalize(value));
                this.writeCloseTag(writer, "property");
            }
            ++i;
        }
        this.writeComment(writer, propertiesPath, "parser.comment.close");
        this.writeCloseTag(writer, "properties");
    }

    public void writeExpressions(Writer writer, ExpressionCollection exp) throws IOException {
        int i = 0;
        while (i < exp.size()) {
            Expression expression = exp.getExpression(i);
            CommentHintPath path = FUNCTIONS_PATH.getInstance();
            path.addName(expression);
            this.writeComment(writer, path, "parser.comment.open");
            try {
                AttributeList properties;
                BeanUtility bu = new BeanUtility(expression);
                String[] propertyNames = bu.getProperties();
                if (propertyNames.length == 0) {
                    properties = new AttributeList();
                    properties.setAttribute("name", expression.getName());
                    properties.setAttribute("class", expression.getClass().getName());
                    this.writeTag(writer, "expression", properties, true);
                } else {
                    properties = new AttributeList();
                    properties.setAttribute("name", expression.getName());
                    properties.setAttribute("class", expression.getClass().getName());
                    this.writeTag(writer, "expression", properties, false);
                    this.writeExpressionParameters(writer, path, propertyNames, bu);
                    this.writeComment(writer, path, "parser.comment.close");
                    this.writeCloseTag(writer, "expression");
                }
            }
            catch (Exception exception) {
                throw new IOException("Unable to extract or write properties.");
            }
            ++i;
        }
    }

    private void writeObjectDescription(Writer writer, ObjectDescription od, Object o, CommentHintPath path) throws IOException, ReportWriterException {
        try {
            od.setParameterFromObject(o);
        }
        catch (Exception e) {
            throw new ReportWriterException("Unable to write the report property reference", e);
        }
        if (this.isBasicObject(od)) {
            String value = (String)od.getParameter("value");
            if (value != null) {
                writer.write(AbstractXMLDefinitionWriter.normalize(value));
            }
        } else {
            ObjectWriter objectWriter = new ObjectWriter(this.getReportWriter(), o, od, this.getIndentLevel(), path);
            objectWriter.write(writer);
        }
    }

    private void writePropertyRefs(Writer writer) throws IOException, ReportWriterException {
        ReportProperties reportProperties = this.getReport().getProperties();
        Iterator keys = reportProperties.keys();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            if (!reportProperties.isMarked(name)) continue;
            Object value = reportProperties.get(name);
            CommentHintPath path = FUNCTIONS_PATH.getInstance();
            path.addName(name);
            if (value == null) {
                this.writeComment(writer, path, "parser.comment.open");
                this.writeTag(writer, "property-ref", "name", name, true);
                continue;
            }
            ObjectDescription od = this.cfc.getDescriptionForClass(value.getClass());
            if (od == null) {
                od = this.cfc.getSuperClassObjectDescription(value.getClass(), null);
            }
            if (od == null) {
                this.writeComment(writer, path, "parser.comment.open");
                this.writeTag(writer, "property-ref", "name", name, true);
                continue;
            }
            AttributeList properties = new AttributeList();
            properties.setAttribute("name", name);
            properties.setAttribute("class", od.getObjectClass().getName());
            this.writeComment(writer, path, "parser.comment.open");
            this.writeTag(writer, "property-ref", properties, false);
            this.writeObjectDescription(writer, od.getInstance(), value, path);
            this.writeComment(writer, path, "parser.comment.close");
            this.writeCloseTag(writer, "property-ref");
        }
    }
}

