/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.report.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.factory.objects.ClassFactoryCollector;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;
import org.jfree.xml.writer.AttributeList;

public class ObjectWriter
extends AbstractXMLDefinitionWriter {
    private ObjectDescription objectDescription;
    private ClassFactoryCollector cc;
    private CommentHintPath commentHintPath;
    static /* synthetic */ Class class$java$lang$String;

    public ObjectWriter(ReportWriter reportWriter, Object baseObject, ObjectDescription objectDescription, int indentLevel, CommentHintPath commentHintPath) throws ReportWriterException {
        this(reportWriter, objectDescription, indentLevel, commentHintPath);
        if (baseObject == null) {
            throw new NullPointerException("BaseObject is null");
        }
        try {
            objectDescription.setParameterFromObject(baseObject);
        }
        catch (ObjectFactoryException ofe) {
            throw new ReportWriterException("Failed to fill ObjectDescription", (Exception)((Object)ofe));
        }
    }

    public ObjectWriter(ReportWriter reportWriter, ObjectDescription objectDescription, int indentLevel, CommentHintPath commentHintPath) {
        super(reportWriter, indentLevel);
        if (objectDescription == null) {
            throw new NullPointerException("ObjectDescription is null");
        }
        this.objectDescription = objectDescription;
        this.cc = this.getReportWriter().getClassFactoryCollector();
        this.commentHintPath = commentHintPath;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ClassFactoryCollector getClassFactoryCollector() {
        return this.cc;
    }

    public CommentHintPath getCommentHintPath() {
        return this.commentHintPath;
    }

    public ObjectDescription getObjectDescription() {
        return this.objectDescription;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ObjectDescription getParameterDescription(String name) {
        ObjectDescription parameterDescription;
        Object o = this.objectDescription.getParameter(name);
        if (o != null) {
            parameterDescription = this.cc.getDescriptionForClass(o.getClass());
            if (parameterDescription != null) return parameterDescription;
            parameterDescription = this.cc.getSuperClassObjectDescription(o.getClass(), null);
        } else {
            Class parameterClass = this.objectDescription.getParameterDefinition(name);
            parameterDescription = this.cc.getDescriptionForClass(parameterClass);
            if (parameterDescription != null) {
                return parameterDescription;
            }
            parameterDescription = this.cc.getSuperClassObjectDescription(parameterClass, null);
        }
        if (parameterDescription != null) return parameterDescription;
        Log.info("Unable to get parameter description for parameter: " + name);
        return parameterDescription;
    }

    protected static ArrayList getParameterNames(ObjectDescription d) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = d.getParameterNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            list.add(name);
        }
        return list;
    }

    protected static boolean isBasicObject(List parameters, ObjectDescription od) {
        String param;
        if (od == null) {
            throw new NullPointerException();
        }
        return parameters.size() == 1 && (param = (String)parameters.get(0)).equals("value") && od.getParameterDefinition("value").equals(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ObjectWriter.class$("java.lang.String")));
    }

    private boolean isUseParameterObjectDescription(Class parameter, Object o) {
        ClassFactoryCollector cc = this.getReportWriter().getClassFactoryCollector();
        ObjectDescription odObject = cc.getDescriptionForClass(o.getClass());
        ObjectDescription odParameter = cc.getDescriptionForClass(parameter);
        if (odObject == null) {
            odObject = cc.getSuperClassObjectDescription(o.getClass(), odObject);
        }
        if (odParameter == null) {
            odParameter = cc.getSuperClassObjectDescription(parameter, odParameter);
        }
        return ObjectUtilities.equal((Object)odParameter, (Object)odObject);
    }

    public void write(Writer writer) throws IOException, ReportWriterException {
        writer.flush();
        Iterator names = this.objectDescription.getParameterNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.writeParameter(writer, name);
        }
    }

    protected void writeParameter(Writer writer, String parameterName) throws IOException, ReportWriterException {
        Object parameterValue = this.getObjectDescription().getParameter(parameterName);
        if (parameterValue == null) {
            return;
        }
        Class parameterDefinition = this.getObjectDescription().getParameterDefinition(parameterName);
        ObjectDescription parameterDescription = this.getParameterDescription(parameterName);
        if (parameterDescription == null) {
            throw new ReportWriterException("Unable to get Parameter description for " + this.getObjectDescription().getObjectClass() + " Parameter: " + parameterName);
        }
        try {
            parameterDescription.setParameterFromObject(parameterValue);
        }
        catch (ObjectFactoryException objectFactoryException) {
            throw new ReportWriterException("Unable to fill parameter object:" + parameterName);
        }
        AttributeList p = new AttributeList();
        p.setAttribute("name", parameterName);
        if (!this.isUseParameterObjectDescription(parameterDefinition, parameterValue)) {
            p.setAttribute("class", parameterValue.getClass().getName());
        }
        CommentHintPath path = this.commentHintPath.getInstance();
        path.addName(parameterName);
        ArrayList parameterNames = ObjectWriter.getParameterNames(parameterDescription);
        if (ObjectWriter.isBasicObject(parameterNames, parameterDescription)) {
            this.writeComment(writer, path, "parser.comment.open");
            this.writeTag(writer, "basic-object", p, false);
            writer.write(AbstractXMLDefinitionWriter.normalize((String)parameterDescription.getParameter("value")));
            this.writeComment(writer, path, "parser.comment.close");
            this.writeCloseTag(writer, "basic-object");
        } else {
            this.writeComment(writer, path, "parser.comment.open");
            this.writeTag(writer, "compound-object", p, false);
            ObjectWriter objWriter = new ObjectWriter(this.getReportWriter(), parameterValue, parameterDescription, this.getIndentLevel(), path);
            objWriter.write(writer);
            this.writeComment(writer, path, "parser.comment.close");
            this.writeCloseTag(writer, "compound-object");
        }
    }
}

