/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.parser.base.ReportGenerator;
import org.jfree.report.modules.parser.ext.factory.datasource.DefaultDataSourceFactory;
import org.jfree.report.modules.parser.ext.factory.elements.DefaultElementFactory;
import org.jfree.report.modules.parser.ext.factory.objects.BandLayoutClassFactory;
import org.jfree.report.modules.parser.ext.factory.objects.DefaultClassFactory;
import org.jfree.report.modules.parser.ext.factory.stylekey.DefaultStyleKeyFactory;
import org.jfree.report.modules.parser.ext.factory.stylekey.PageableLayoutStyleKeyFactory;
import org.jfree.report.modules.parser.ext.factory.templates.DefaultTemplateCollection;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.report.util.Log;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.util.Configuration;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.factory.objects.ArrayClassFactory;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.URLClassFactory;

public class ReportConverter {
    static /* synthetic */ Class class$org$jfree$report$modules$parser$extwriter$ReportConverter;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void convertReport(File in, File out, String encoding) throws IOException, ReportWriterException {
        FileOutputStream base = new FileOutputStream(out);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)base, encoding));
        try {
            this.convertReport(in.toURL(), out.toURL(), w, encoding);
        }
        finally {
            Object var7_6 = null;
            ((Writer)w).close();
        }
    }

    public void convertReport(String inName, String outFile, String encoding) throws IOException, ReportWriterException {
        URL reportURL = this.findReport(inName);
        if (reportURL == null) {
            throw new IOException("The specified report definition was not found");
        }
        File out = new File(outFile);
        FileOutputStream base = new FileOutputStream(out);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)base, encoding));
        try {
            this.convertReport(reportURL, out.toURL(), w, encoding);
        }
        finally {
            Object var9_8 = null;
            ((Writer)w).close();
        }
    }

    public void convertReport(URL in, URL contentBase, Writer w, String encoding) throws IOException, ReportWriterException {
        if (in == null) {
            throw new NullPointerException("Input URL is null");
        }
        if (contentBase == null) {
            throw new NullPointerException("ContentBase is null");
        }
        if (w == null) {
            throw new NullPointerException("Writer is null");
        }
        if (encoding == null) {
            throw new NullPointerException("Encoding is null.");
        }
        JFreeReport report = this.parseReport(in);
        this.write(report, w, contentBase, encoding);
        w.flush();
    }

    public URL findReport(String name) throws IOException {
        URL in = ObjectUtilities.getResource((String)name, (Class)(class$org$jfree$report$modules$parser$extwriter$ReportConverter != null ? class$org$jfree$report$modules$parser$extwriter$ReportConverter : (class$org$jfree$report$modules$parser$extwriter$ReportConverter = ReportConverter.class$("org.jfree.report.modules.parser.extwriter.ReportConverter"))));
        if (in != null) {
            return in;
        }
        File f = new File(name);
        if (f.canRead()) {
            return f.toURL();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: ReportConverter <InFile> <OutFile>");
            System.exit(1);
        }
        ReportConverter converter = new ReportConverter();
        converter.convertReport(args[0], args[1], "UTF-16");
    }

    private JFreeReport parseReport(URL templateURL) throws IOException {
        try {
            ReportGenerator generator = ReportGenerator.getInstance();
            return generator.parseReport(templateURL);
        }
        catch (Exception e) {
            Log.info("ParseReport failed; Cause: ", e);
            throw new IOException("Failed to parse the report");
        }
    }

    public void write(JFreeReport report, Writer w, URL contentBase, String encoding) throws IOException, ReportWriterException {
        if (contentBase == null) {
            throw new NullPointerException("ContentBase is null");
        }
        ReportConfiguration config = new ReportConfiguration(report.getReportConfiguration());
        config.setConfigProperty("content-base", contentBase.toExternalForm());
        ReportWriter writer = new ReportWriter(report, encoding, (Configuration)config);
        writer.addClassFactoryFactory((ClassFactory)new URLClassFactory());
        writer.addClassFactoryFactory((ClassFactory)new DefaultClassFactory());
        writer.addClassFactoryFactory((ClassFactory)new BandLayoutClassFactory());
        writer.addClassFactoryFactory((ClassFactory)new ArrayClassFactory());
        writer.addStyleKeyFactory(new DefaultStyleKeyFactory());
        writer.addStyleKeyFactory(new PageableLayoutStyleKeyFactory());
        writer.addTemplateCollection(new DefaultTemplateCollection());
        writer.addElementFactory(new DefaultElementFactory());
        writer.addDataSourceFactory(new DefaultDataSourceFactory());
        writer.write(w);
    }
}

