/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportBuilderHints;
import org.jfree.report.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.jfree.report.modules.parser.ext.factory.datasource.DataSourceFactory;
import org.jfree.report.modules.parser.ext.factory.elements.ElementFactory;
import org.jfree.report.modules.parser.ext.factory.elements.ElementFactoryCollector;
import org.jfree.report.modules.parser.ext.factory.stylekey.StyleKeyFactory;
import org.jfree.report.modules.parser.ext.factory.stylekey.StyleKeyFactoryCollector;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateCollection;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateCollector;
import org.jfree.report.modules.parser.extwriter.ReportDefinitionWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.report.util.Log;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.ClassFactoryCollector;

public class ReportWriter {
    private DataSourceCollector dataSourceCollector;
    private ElementFactoryCollector elementFactoryCollector;
    private ClassFactoryCollector classFactoryCollector;
    private StyleKeyFactoryCollector styleKeyFactoryCollector;
    private TemplateCollector templateCollector;
    private JFreeReport report;
    private String encoding;
    private Configuration configuration;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$jfree$xml$factory$objects$ClassFactory;
    static /* synthetic */ Class class$org$jfree$report$modules$parser$ext$factory$datasource$DataSourceFactory;
    static /* synthetic */ Class class$org$jfree$report$modules$parser$ext$factory$templates$TemplateCollection;
    static /* synthetic */ Class class$org$jfree$report$modules$parser$ext$factory$elements$ElementFactory;
    static /* synthetic */ Class class$org$jfree$report$modules$parser$ext$factory$stylekey$StyleKeyFactory;

    public ReportWriter(JFreeReport report, String encoding, Configuration config) {
        if (report == null) {
            throw new NullPointerException("Report is null");
        }
        if (encoding == null) {
            throw new NullPointerException("Encoding is null.");
        }
        if (config == null) {
            throw new NullPointerException("Configuration is null.");
        }
        if (config.getConfigProperty("content-base") == null) {
            throw new IllegalStateException("This report writer configuration does not define a content base.");
        }
        this.report = report;
        this.encoding = encoding;
        this.configuration = config;
        this.dataSourceCollector = new DataSourceCollector();
        this.elementFactoryCollector = new ElementFactoryCollector();
        this.classFactoryCollector = new ClassFactoryCollector();
        this.classFactoryCollector.addFactory((ClassFactory)this.dataSourceCollector);
        this.styleKeyFactoryCollector = new StyleKeyFactoryCollector();
        this.templateCollector = new TemplateCollector();
        this.loadObjectFactories();
        this.loadDataSourceFactories();
        this.loadElementFactories();
        this.loadStyleKeyFactories();
        this.loadTemplateFactories();
        this.dataSourceCollector.configure(this.configuration);
        this.classFactoryCollector.configure(this.configuration);
        this.templateCollector.configure(this.configuration);
    }

    public void addClassFactoryFactory(ClassFactory cf) {
        this.classFactoryCollector.addFactory(cf);
    }

    public void addDataSourceFactory(DataSourceFactory dsf) {
        this.dataSourceCollector.addFactory(dsf);
    }

    public void addElementFactory(ElementFactory ef) {
        this.elementFactoryCollector.addFactory(ef);
    }

    public void addStyleKeyFactory(StyleKeyFactory skf) {
        this.styleKeyFactoryCollector.addFactory(skf);
    }

    public void addTemplateCollection(TemplateCollection collection) {
        this.templateCollector.addTemplateCollection(collection);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Configuration createDefaultConfiguration(JFreeReport report) {
        ReportConfiguration repConf = new ReportConfiguration(report.getReportConfiguration());
        repConf.setConfigProperty("content-base", (String)report.getProperty("report.definition.contentbase"));
        repConf.setConfigProperty("report.definition.contentbase", (String)report.getProperty("report.definition.contentbase"));
        repConf.setConfigProperty("report.definition.source", (String)report.getProperty("report.definition.source"));
        return repConf;
    }

    public ClassFactoryCollector getClassFactoryCollector() {
        return this.classFactoryCollector;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public DataSourceCollector getDataSourceCollector() {
        return this.dataSourceCollector;
    }

    public ElementFactoryCollector getElementFactoryCollector() {
        return this.elementFactoryCollector;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public JFreeReport getReport() {
        return this.report;
    }

    public StyleKeyFactoryCollector getStyleKeyFactoryCollector() {
        return this.styleKeyFactoryCollector;
    }

    public TemplateCollector getTemplateCollector() {
        return this.templateCollector;
    }

    private void loadDataSourceFactories() {
        ReportBuilderHints hints = this.getReport().getReportBuilderHints();
        if (hints == null) {
            return;
        }
        List l = (List)hints.getHint(this.getReport(), "", class$java$util$List != null ? class$java$util$List : (class$java$util$List = ReportWriter.class$("java.util.List")));
        if (l == null) {
            return;
        }
        DataSourceFactory[] list = (DataSourceFactory[])this.loadParserHintFactories(l, class$org$jfree$report$modules$parser$ext$factory$datasource$DataSourceFactory != null ? class$org$jfree$report$modules$parser$ext$factory$datasource$DataSourceFactory : (class$org$jfree$report$modules$parser$ext$factory$datasource$DataSourceFactory = ReportWriter.class$("org.jfree.report.modules.parser.ext.factory.datasource.DataSourceFactory")));
        int i = 0;
        while (i < list.length) {
            this.addDataSourceFactory(list[i]);
            ++i;
        }
    }

    private void loadElementFactories() {
        ReportBuilderHints hints = this.getReport().getReportBuilderHints();
        if (hints == null) {
            return;
        }
        List l = (List)hints.getHint(this.getReport(), "", class$java$util$List != null ? class$java$util$List : (class$java$util$List = ReportWriter.class$("java.util.List")));
        if (l == null) {
            return;
        }
        ElementFactory[] list = (ElementFactory[])this.loadParserHintFactories(l, class$org$jfree$report$modules$parser$ext$factory$elements$ElementFactory != null ? class$org$jfree$report$modules$parser$ext$factory$elements$ElementFactory : (class$org$jfree$report$modules$parser$ext$factory$elements$ElementFactory = ReportWriter.class$("org.jfree.report.modules.parser.ext.factory.elements.ElementFactory")));
        int i = 0;
        while (i < list.length) {
            this.addElementFactory(list[i]);
            ++i;
        }
    }

    private void loadObjectFactories() {
        ReportBuilderHints hints = this.getReport().getReportBuilderHints();
        if (hints == null) {
            return;
        }
        List l = (List)hints.getHint(this.getReport(), "", class$java$util$List != null ? class$java$util$List : (class$java$util$List = ReportWriter.class$("java.util.List")));
        if (l == null) {
            return;
        }
        ClassFactory[] list = (ClassFactory[])this.loadParserHintFactories(l, class$org$jfree$xml$factory$objects$ClassFactory != null ? class$org$jfree$xml$factory$objects$ClassFactory : (class$org$jfree$xml$factory$objects$ClassFactory = ReportWriter.class$("org.jfree.xml.factory.objects.ClassFactory")));
        int i = 0;
        while (i < list.length) {
            this.addClassFactoryFactory(list[i]);
            ++i;
        }
    }

    private Object[] loadParserHintFactories(List hints, Class factoryType) {
        Object[] hintValues = hints.toArray();
        ArrayList factories = new ArrayList(hintValues.length);
        int i = 0;
        while (i < hintValues.length) {
            if (!(hintValues[i] instanceof String)) {
                Log.warn(new Log.SimpleMessage("Invalid parser hint type for factory: ", (Object)factoryType, (Object)": Type found: ", hintValues[i]));
            } else {
                try {
                    Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass((String)hintValues[i]);
                    if (!factoryType.isAssignableFrom(c)) {
                        Log.warn(new Log.SimpleMessage("Invalid factory type specified: Required ", (Object)factoryType, (Object)" but found ", c));
                    } else {
                        Object o = c.newInstance();
                        if (!factories.contains(o)) {
                            factories.add(o);
                        }
                    }
                }
                catch (Exception e) {
                    Log.warn("Error while applying parser hints: ", e);
                }
            }
            ++i;
        }
        return factories.toArray((Object[])Array.newInstance(factoryType, factories.size()));
    }

    private void loadStyleKeyFactories() {
        ReportBuilderHints hints = this.getReport().getReportBuilderHints();
        if (hints == null) {
            return;
        }
        List l = (List)hints.getHint(this.getReport(), "", class$java$util$List != null ? class$java$util$List : (class$java$util$List = ReportWriter.class$("java.util.List")));
        if (l == null) {
            return;
        }
        StyleKeyFactory[] list = (StyleKeyFactory[])this.loadParserHintFactories(l, class$org$jfree$report$modules$parser$ext$factory$stylekey$StyleKeyFactory != null ? class$org$jfree$report$modules$parser$ext$factory$stylekey$StyleKeyFactory : (class$org$jfree$report$modules$parser$ext$factory$stylekey$StyleKeyFactory = ReportWriter.class$("org.jfree.report.modules.parser.ext.factory.stylekey.StyleKeyFactory")));
        int i = 0;
        while (i < list.length) {
            this.addStyleKeyFactory(list[i]);
            ++i;
        }
    }

    private void loadTemplateFactories() {
        ReportBuilderHints hints = this.getReport().getReportBuilderHints();
        if (hints == null) {
            return;
        }
        List l = (List)hints.getHint(this.getReport(), "", class$java$util$List != null ? class$java$util$List : (class$java$util$List = ReportWriter.class$("java.util.List")));
        if (l == null) {
            return;
        }
        TemplateCollection[] list = (TemplateCollection[])this.loadParserHintFactories(l, class$org$jfree$report$modules$parser$ext$factory$templates$TemplateCollection != null ? class$org$jfree$report$modules$parser$ext$factory$templates$TemplateCollection : (class$org$jfree$report$modules$parser$ext$factory$templates$TemplateCollection = ReportWriter.class$("org.jfree.report.modules.parser.ext.factory.templates.TemplateCollection")));
        int i = 0;
        while (i < list.length) {
            this.addTemplateCollection(list[i]);
            ++i;
        }
    }

    public void write(Writer w) throws IOException, ReportWriterException {
        ReportDefinitionWriter writer = new ReportDefinitionWriter(this);
        writer.write(w);
    }
}

