/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jfree.report.ReportBuilderHints;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateDescription;
import org.jfree.report.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.report.modules.parser.extwriter.TemplateWriter;
import org.jfree.report.util.Log;
import org.jfree.xml.writer.XMLWriterSupport;

public class TemplatesWriter
extends AbstractXMLDefinitionWriter {
    private static final CommentHintPath TEMPLATES_PATH = new CommentHintPath(new String[]{"report-definition", "templates"});
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;

    public TemplatesWriter(ReportWriter reportWriter, int indentLevel) {
        super(reportWriter, indentLevel);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static TemplateDescription getTemplateDescription(ReportWriter writer, String name) {
        if (name == null) {
            throw new NullPointerException("Name must be specified.");
        }
        ReportBuilderHints hints = writer.getReport().getReportBuilderHints();
        if (hints == null) {
            return null;
        }
        List l = (List)hints.getHint(writer.getReport(), "ext.parser.template-definition", class$java$util$List != null ? class$java$util$List : (class$java$util$List = TemplatesWriter.class$("java.util.List")));
        if (l == null) {
            return null;
        }
        if (l.isEmpty()) {
            return null;
        }
        TemplateDescription[] td = l.toArray(new TemplateDescription[l.size()]);
        int i = 0;
        while (i < td.length) {
            if (td[i].getName().equals(name)) {
                td[i].configure(writer.getConfiguration());
                return td[i];
            }
            ++i;
        }
        return writer.getTemplateCollector().getTemplate(name);
    }

    public void write(Writer writer) throws IOException, ReportWriterException {
        this.writeComment(writer, TEMPLATES_PATH, "parser.comment.open");
        ReportBuilderHints hints = this.getReport().getReportBuilderHints();
        if (hints == null) {
            return;
        }
        List l = (List)hints.getHint(this.getReport(), "ext.parser.template-definition", class$java$util$List != null ? class$java$util$List : (class$java$util$List = TemplatesWriter.class$("java.util.List")));
        if (l == null) {
            return;
        }
        if (l.isEmpty()) {
            return;
        }
        this.writeTag(writer, "templates");
        ArrayList<String> invalidTemplates = new ArrayList<String>();
        TemplateDescription[] td = l.toArray(new TemplateDescription[l.size()]);
        int i = 0;
        while (i < td.length) {
            TemplateDescription template = td[i];
            template.configure(this.getReportWriter().getConfiguration());
            String templateExtends = (String)hints.getHint((Serializable)((Object)template), "ext.parser.template-reference", class$java$lang$String != null ? class$java$lang$String : TemplatesWriter.class$("java.lang.String"));
            if (templateExtends == null) {
                Log.warn("Invalid parser hint: Template reference missing for template " + template.getName());
                invalidTemplates.add(template.getName());
            } else if (invalidTemplates.contains(templateExtends)) {
                Log.warn("Invalid parser hint: Template reference points to invalid template " + template.getName());
                invalidTemplates.add(template.getName());
            } else {
                TemplateDescription parentTemplate = TemplatesWriter.getTemplateDescription(this.getReportWriter(), templateExtends);
                if (parentTemplate == null) {
                    Log.warn("Invalid parser hint: Template reference invalid for template " + template.getName());
                    invalidTemplates.add(template.getName());
                } else {
                    CommentHintPath templatePath = TEMPLATES_PATH.getInstance();
                    templatePath.addName(template);
                    TemplateWriter templateWriter = new TemplateWriter(this.getReportWriter(), this.getIndentLevel(), template, parentTemplate, templatePath);
                    templateWriter.write(writer);
                }
            }
            ++i;
        }
        this.writeComment(writer, TEMPLATES_PATH, "parser.comment.close");
        this.writeCloseTag(writer, "templates");
        writer.write(XMLWriterSupport.getLineSeparator());
    }
}

