/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import org.jfree.report.Element;
import org.jfree.report.elementfactory.ElementFactory;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.ui.FloatDimension;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public abstract class AbstractElementReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String FONT_NAME_ATT = "fontname";
    public static final String FONT_STYLE_ATT = "fontstyle";
    public static final String FONT_SIZE_ATT = "fontsize";
    public static final String FS_BOLD = "fsbold";
    public static final String FS_ITALIC = "fsitalic";
    public static final String FS_UNDERLINE = "fsunderline";
    public static final String FS_STRIKETHR = "fsstrikethr";
    public static final String FS_EMBEDDED = "font-embedded";
    public static final String FS_ENCODING = "font-encoding";
    public static final String LINEHEIGHT = "line-height";
    public static final String NAME_ATT = "name";
    public static final String ALIGNMENT_ATT = "alignment";
    public static final String VALIGNMENT_ATT = "vertical-alignment";
    public static final String COLOR_ATT = "color";
    public static final String FIELDNAME_ATT = "fieldname";
    public static final String FUNCTIONNAME_ATT = "function";
    public static final String NULLSTRING_ATT = "nullstring";
    private static final String DYNAMIC_ATT = "dynamic";
    private static final String LAYOUT_CACHABLE_ATT = "layout-cachable";
    private static final String VISIBLE_ATT = "visible";
    private static final String HREF_ATT = "href";
    private Element element;

    protected void doneParsing() throws SAXException, XmlReaderException {
        this.element = this.getElementFactory().createElement();
        super.doneParsing();
    }

    private Dimension2D getElementDimension(PropertyAttributes atts) throws SAXException {
        float w = ParserUtil.parseRelativeFloat((String)atts.getValue("width"), (String)"Element width not specified");
        float h = ParserUtil.parseRelativeFloat((String)atts.getValue("height"), (String)"Element height not specified");
        return new FloatDimension(w, h);
    }

    protected abstract ElementFactory getElementFactory();

    protected final Point2D getElementPosition(PropertyAttributes atts) throws SAXException {
        float x = ParserUtil.parseRelativeFloat((String)atts.getValue("x"), (String)"Element x not specified");
        float y = ParserUtil.parseRelativeFloat((String)atts.getValue("y"), (String)"Element y not specified");
        return new Point2D.Float(x, y);
    }

    public Object getObject() throws XmlReaderException {
        return this.element;
    }

    protected void startParsing(PropertyAttributes atts) throws SAXException, XmlReaderException {
        String href;
        String visibleValue;
        String layoutCachableValue;
        ElementFactory factory = this.getElementFactory();
        factory.setName(atts.getValue(NAME_ATT));
        factory.setAbsolutePosition(this.getElementPosition(atts));
        factory.setMinimumSize(this.getElementDimension(atts));
        String dynamicValue = atts.getValue(DYNAMIC_ATT);
        if (dynamicValue != null) {
            factory.setDynamicHeight(new Boolean(ParserUtil.parseBoolean((String)dynamicValue, (boolean)false)));
        }
        if ((layoutCachableValue = atts.getValue(LAYOUT_CACHABLE_ATT)) != null) {
            factory.setLayoutCachable(new Boolean(ParserUtil.parseBoolean((String)layoutCachableValue, (boolean)true)));
        }
        if ((visibleValue = atts.getValue(VISIBLE_ATT)) != null) {
            factory.setVisible(new Boolean(ParserUtil.parseBoolean((String)visibleValue, (boolean)true)));
        }
        if ((href = atts.getValue(HREF_ATT)) != null) {
            factory.setHRefTarget(href);
        }
    }

    protected void storeComments() throws SAXException {
        CommentHintPath commentHintPath = new CommentHintPath(this.element);
        this.defaultStoreComments(commentHintPath);
    }
}

