/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.resourceloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.jfree.io.IOUtils;
import org.jfree.report.resourceloader.DrawableFactoryModule;
import org.jfree.report.resourceloader.ImageFactoryModule;
import org.jfree.report.util.Log;
import org.jfree.ui.Drawable;
import org.jfree.util.ObjectUtilities;

public class DrawableFactory {
    private static DrawableFactory singleton;
    private ArrayList factoryModules = new ArrayList();

    private DrawableFactory() {
    }

    public Drawable createDrawable(InputStream in, String file, String contentType) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(32768);
        IOUtils.getInstance().copyStreams(in, (OutputStream)bout, 16384);
        return this.createDrawable(bout.toByteArray(), file, contentType);
    }

    public Drawable createDrawable(URL url) throws IOException {
        InputStream in = url.openStream();
        URLConnection uc = url.openConnection();
        Drawable image = this.createDrawable(uc.getInputStream(), url.getFile(), uc.getContentType());
        in.close();
        return image;
    }

    public synchronized Drawable createDrawable(byte[] data, String fileName, String mimeType) throws IOException {
        DrawableFactoryModule module;
        int i = 0;
        while (i < this.factoryModules.size()) {
            try {
                DrawableFactoryModule module2 = (DrawableFactoryModule)this.factoryModules.get(i);
                if (module2.getHeaderFingerprintSize() > 0 && data.length >= module2.getHeaderFingerprintSize() && module2.canHandleResourceByContent(data)) {
                    return module2.createDrawable(data, fileName, mimeType);
                }
            }
            catch (IOException ioe) {
                Log.info("Failed to load image: Trying harder ..", ioe);
            }
            ++i;
        }
        if (mimeType != null && !"".equals(mimeType)) {
            int i2 = 0;
            while (i2 < this.factoryModules.size()) {
                try {
                    module = (DrawableFactoryModule)this.factoryModules.get(i2);
                    if (module.canHandleResourceByMimeType(mimeType)) {
                        return module.createDrawable(data, fileName, mimeType);
                    }
                }
                catch (IOException ioe) {
                    Log.info("Failed to load image: Trying harder ..", ioe);
                }
                ++i2;
            }
        }
        if (mimeType != null && !"".equals(mimeType)) {
            int i3 = 0;
            while (i3 < this.factoryModules.size()) {
                try {
                    module = (DrawableFactoryModule)this.factoryModules.get(i3);
                    if (module.canHandleResourceByName(fileName)) {
                        return module.createDrawable(data, fileName, mimeType);
                    }
                }
                catch (IOException ioe) {
                    Log.info("Failed to load image: Trying harder ..", ioe);
                }
                ++i3;
            }
        }
        throw new IOException("Unable to load the drawable, no suitable loader found.");
    }

    public static synchronized DrawableFactory getInstance() {
        if (singleton == null) {
            singleton = new DrawableFactory();
        }
        return singleton;
    }

    public boolean registerModule(String className) {
        try {
            Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(className);
            this.registerModule((ImageFactoryModule)c.newInstance());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized void registerModule(ImageFactoryModule module) {
        if (!this.factoryModules.contains(module)) {
            this.factoryModules.add(module);
        }
    }
}

