/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashNMap
implements Serializable,
Cloneable {
    private static final Iterator EMPTY_ITERATOR;
    private HashMap table = new HashMap();

    static {
        class Org_jfree_report_util_HashNMap$1 {
            /* synthetic */ Org_jfree_report_util_HashNMap$1() {
            }
        }
        EMPTY_ITERATOR = new EmptyIterator();
    }

    public void add(Object key, Object val) {
        ArrayList v = (ArrayList)this.table.get(key);
        if (v == null) {
            this.put(key, val);
        } else {
            v.add(val);
        }
    }

    public void clear() {
        this.table.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        HashNMap map = (HashNMap)super.clone();
        map.table = new HashMap();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            Object key = keys.next();
            ArrayList list = (ArrayList)map.table.get(key);
            if (list == null) continue;
            map.table.put(key, list.clone());
        }
        return map;
    }

    public boolean contains(Object value) {
        if (this.containsKey(value)) {
            return true;
        }
        return this.containsValue(value);
    }

    public boolean containsKey(Object key) {
        return this.table.containsKey(key);
    }

    public boolean containsValue(Object value) {
        Iterator e = this.keys();
        boolean found = false;
        while (e.hasNext() && !found) {
            ArrayList v = (ArrayList)e.next();
            found = v.contains(value);
        }
        return found;
    }

    public Object get(Object key, int n) {
        ArrayList v = (ArrayList)this.table.get(key);
        if (v == null) {
            return null;
        }
        return v.get(n);
    }

    public Iterator getAll(Object key) {
        ArrayList v = (ArrayList)this.table.get(key);
        if (v == null) {
            return EMPTY_ITERATOR;
        }
        return ((AbstractList)v).iterator();
    }

    public Object getFirst(Object key) {
        return this.get(key, 0);
    }

    public int getValueCount(Object key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        ArrayList list = (ArrayList)this.table.get(key);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public Set keySet() {
        return this.table.keySet();
    }

    public Iterator keys() {
        return this.table.keySet().iterator();
    }

    public void put(Object key, Object val) {
        ArrayList<Object> v = new ArrayList<Object>();
        v.add(val);
        this.table.put(key, v);
    }

    public boolean remove(Object key, Object value) {
        ArrayList v = (ArrayList)this.table.get(key);
        if (v == null) {
            return false;
        }
        if (!((AbstractCollection)v).remove(value)) {
            return false;
        }
        if (v.size() == 0) {
            this.table.remove(key);
        }
        return true;
    }

    public void removeAll(Object key) {
        this.table.remove(key);
    }

    public Object[] toArray(Object key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        ArrayList list = (ArrayList)this.table.get(key);
        if (list != null) {
            return list.toArray();
        }
        return new Object[0];
    }

    public Object[] toArray(Object key, Object[] data) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        ArrayList list = (ArrayList)this.table.get(key);
        if (list != null) {
            return list.toArray(data);
        }
        return new Object[0];
    }

    private static final class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("This iterator is empty.");
        }

        public void remove() {
            throw new UnsupportedOperationException("This iterator is empty, no remove supported.");
        }
    }
}

