/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.util.Arrays;
import org.jfree.report.util.ReportConfiguration;
import org.jfree.report.util.SystemOutLogTarget;

public final class Log
extends org.jfree.util.Log {
    public static final int ERROR = 0;
    public static final int WARN = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    private static final SystemOutLogTarget DEFAULT_LOG_TARGET = new SystemOutLogTarget();
    private static final Log JFREEREPORTLOG = new Log();

    static {
        org.jfree.util.Log.defineLog((org.jfree.util.Log)JFREEREPORTLOG);
        JFREEREPORTLOG.addTarget(DEFAULT_LOG_TARGET);
        try {
            if (Boolean.getBoolean("org.jfree.report.DebugDefault")) {
                JFREEREPORTLOG.setDebuglevel(3);
            } else {
                JFREEREPORTLOG.setDebuglevel(1);
            }
        }
        catch (SecurityException securityException) {
            JFREEREPORTLOG.setDebuglevel(1);
        }
    }

    private Log() {
    }

    public static void debug(Object message) {
        Log.log(3, message);
    }

    public static void debug(Object message, Exception e) {
        Log.log(3, message, e);
    }

    public static void error(Object message) {
        Log.log(0, message);
    }

    public static void error(Object message, Exception e) {
        Log.log(0, message, e);
    }

    public static Log getJFreeReportLog() {
        return JFREEREPORTLOG;
    }

    public static void info(Object message) {
        Log.log(2, message);
    }

    public static void info(Object message, Exception e) {
        Log.log(2, message, e);
    }

    public void init() {
        this.removeTarget(DEFAULT_LOG_TARGET);
        String logLevel = ReportConfiguration.getGlobalConfig().getLogLevel();
        if (logLevel.equalsIgnoreCase("error")) {
            this.setDebuglevel(0);
        } else if (logLevel.equalsIgnoreCase("warn")) {
            this.setDebuglevel(1);
        } else if (logLevel.equalsIgnoreCase("info")) {
            this.setDebuglevel(2);
        } else if (logLevel.equalsIgnoreCase("debug")) {
            this.setDebuglevel(3);
        }
    }

    public static void log(int level, Object message) {
        org.jfree.util.Log.log((int)level, (Object)message);
    }

    public static void log(int level, Object message, Exception e) {
        org.jfree.util.Log.log((int)level, (Object)message, (Exception)e);
    }

    public static void warn(Object message) {
        Log.log(1, message);
    }

    public static void warn(Object message, Exception e) {
        Log.log(1, message, e);
    }

    public static class MemoryUsageMessage {
        private final String message;

        public MemoryUsageMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return String.valueOf(this.message) + "Free: " + Runtime.getRuntime().freeMemory() + "; " + "Total: " + Runtime.getRuntime().totalMemory();
        }
    }

    public static class PadMessage {
        private final Object text;
        private final int length;

        public PadMessage(Object message, int length) {
            this.text = message;
            this.length = length;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(this.text);
            if (b.length() < this.length) {
                char[] pad = new char[this.length - b.length()];
                Arrays.fill(pad, ' ');
                b.append(pad);
            }
            return b.toString();
        }
    }
}

