/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.util.Enumeration;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.util.PropertyFileReportConfiguration;
import org.jfree.report.util.SystemPropertyConfiguration;
import org.jfree.util.Configuration;

public class ReportConfiguration
extends HierarchicalConfiguration {
    public static final String FONTRENDERER_USEALIASING = "org.jfree.report.layout.fontrenderer.UseAliasing";
    public static final String FONTRENDERER_USEALIASING_DEFAULT = "false";
    public static final String FONTRENDERER_ISBUGGY_FRC = "org.jfree.report.layout.fontrenderer.IsBuggyFRC";
    public static final String FONTRENDERER_ISBUGGY_FRC_DEFAULT = "false";
    public static final String PRINT_OPERATION_COMMENT = "org.jfree.report.PrintOperationComment";
    public static final String PRINT_OPERATION_COMMENT_DEFAULT = "false";
    public static final String STRICT_ERRORHANDLING = "org.jfree.report.StrictErrorHandling";
    public static final String STRICT_ERRORHANDLING_DEFAULT = "true";
    public static final String WARN_INVALID_COLUMNS = "org.jfree.report.WarnInvalidColumns";
    public static final String WARN_INVALID_COLUMNS_DEFAULT = "false";
    public static final String DISABLE_LOGGING = "org.jfree.report.NoDefaultDebug";
    public static final String NO_PRINTER_AVAILABLE = "org.jfree.report.NoPrinterAvailable";
    public static final String DISABLE_LOGGING_DEFAULT = "false";
    public static final String LOGLEVEL = "org.jfree.report.LogLevel";
    public static final String LOGLEVEL_DEFAULT = "Info";
    public static final String LOGTARGET = "org.jfree.report.LogTarget";
    public static final String LOGTARGET_DEFAULT = (class$org$jfree$report$util$SystemOutLogTarget != null ? class$org$jfree$report$util$SystemOutLogTarget : (class$org$jfree$report$util$SystemOutLogTarget = ReportConfiguration.class$("org.jfree.report.util.SystemOutLogTarget"))).getName();
    public static final String REPORT_RESOURCE_BUNDLE_KEY = "org.jfree.report.ResourceBundle";
    private static transient ReportConfiguration globalConfig;
    private static transient UserConfigWrapper userConfig;
    static /* synthetic */ Class class$org$jfree$report$util$SystemOutLogTarget;

    static {
        userConfig = new UserConfigWrapper();
    }

    protected ReportConfiguration() {
        this(null);
    }

    public ReportConfiguration(ReportConfiguration globalConfig) {
        super((ModifiableConfiguration)globalConfig);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected void configurationLoaded() {
        if (!this.isParentSaved()) {
            this.setParentConfig((ModifiableConfiguration)globalConfig);
        }
    }

    public static synchronized ReportConfiguration getGlobalConfig() {
        if (globalConfig == null) {
            globalConfig = new ReportConfiguration();
            PropertyFileReportConfiguration rootProperty = new PropertyFileReportConfiguration();
            rootProperty.load("/org/jfree/report/jfreereport.properties");
            rootProperty.load("/org/jfree/report/ext/jfreereport-ext.properties");
            globalConfig.insertConfiguration(rootProperty);
            globalConfig.insertConfiguration((HierarchicalConfiguration)JFreeReportBoot.getInstance().getPackageManager().getPackageConfiguration());
            PropertyFileReportConfiguration baseProperty = new PropertyFileReportConfiguration();
            baseProperty.load("/jfreereport.properties");
            globalConfig.insertConfiguration(baseProperty);
            globalConfig.insertConfiguration(userConfig);
            SystemPropertyConfiguration systemConfig = new SystemPropertyConfiguration();
            globalConfig.insertConfiguration(systemConfig);
            JFreeReportBoot.getInstance().start();
        }
        return globalConfig;
    }

    public String getLogLevel() {
        return this.getConfigProperty(LOGLEVEL, LOGLEVEL_DEFAULT);
    }

    public String getLogTarget() {
        return this.getConfigProperty(LOGTARGET, LOGTARGET_DEFAULT);
    }

    public static String getPlatformDefaultEncoding() {
        try {
            return System.getProperty("file.encoding", "Cp1252");
        }
        catch (SecurityException securityException) {
            return "Cp1252";
        }
    }

    public static Configuration getUserConfig() {
        return userConfig.getWrappedConfiguration();
    }

    public boolean isDisableLogging() {
        return this.getConfigProperty(DISABLE_LOGGING, "false").equalsIgnoreCase(STRICT_ERRORHANDLING_DEFAULT);
    }

    public boolean isFontRendererBuggy() {
        return this.getConfigProperty(FONTRENDERER_ISBUGGY_FRC, "false").equalsIgnoreCase(STRICT_ERRORHANDLING_DEFAULT);
    }

    public boolean isFontRendererUseAliasing() {
        return this.getConfigProperty(FONTRENDERER_USEALIASING, "false").equalsIgnoreCase(STRICT_ERRORHANDLING_DEFAULT);
    }

    protected boolean isParentSaved() {
        return this != globalConfig;
    }

    public boolean isPrintOperationComment() {
        return this.getConfigProperty(PRINT_OPERATION_COMMENT, "false").equalsIgnoreCase(STRICT_ERRORHANDLING_DEFAULT);
    }

    public boolean isStrictErrorHandling() {
        return this.getConfigProperty(STRICT_ERRORHANDLING, STRICT_ERRORHANDLING_DEFAULT).equalsIgnoreCase(STRICT_ERRORHANDLING_DEFAULT);
    }

    public boolean isWarnInvalidColumns() {
        return this.getConfigProperty(WARN_INVALID_COLUMNS, "false").equalsIgnoreCase(STRICT_ERRORHANDLING_DEFAULT);
    }

    public void setDisableLogging(boolean disableLogging) {
        this.setConfigProperty(DISABLE_LOGGING, String.valueOf(disableLogging));
    }

    public void setFontRendererBuggy(boolean buggy) {
        this.setConfigProperty(FONTRENDERER_ISBUGGY_FRC, String.valueOf(buggy));
    }

    public void setFontRendererUseAliasing(boolean alias) {
        this.setConfigProperty(FONTRENDERER_USEALIASING, String.valueOf(alias));
    }

    public void setLogLevel(String level) {
        this.setConfigProperty(LOGLEVEL, level);
    }

    public void setLogTarget(String logTarget) {
        this.setConfigProperty(LOGTARGET, logTarget);
    }

    public void setPrintOperationComment(boolean print) {
        this.setConfigProperty(PRINT_OPERATION_COMMENT, String.valueOf(print));
    }

    public void setStrictErrorHandling(boolean strictErrorHandling) {
        this.setConfigProperty(STRICT_ERRORHANDLING, String.valueOf(strictErrorHandling));
    }

    public static void setUserConfig(Configuration config) {
        userConfig.setWrappedConfiguration(config);
    }

    public void setWarnInvalidColumns(boolean warnInvalidColumns) {
        this.setConfigProperty(WARN_INVALID_COLUMNS, String.valueOf(warnInvalidColumns));
    }

    private static class UserConfigWrapper
    extends HierarchicalConfiguration
    implements Configuration {
        private Configuration wrappedConfiguration;

        public Enumeration getConfigProperties() {
            if (this.wrappedConfiguration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modConfiguration = (ModifiableConfiguration)this.wrappedConfiguration;
                return modConfiguration.getConfigProperties();
            }
            return super.getConfigProperties();
        }

        public String getConfigProperty(String key) {
            if (this.wrappedConfiguration == null) {
                return this.getParentConfig().getConfigProperty(key);
            }
            String retval = this.wrappedConfiguration.getConfigProperty(key);
            if (retval != null) {
                return retval;
            }
            return this.getParentConfig().getConfigProperty(key);
        }

        public String getConfigProperty(String key, String defaultValue) {
            if (this.wrappedConfiguration == null) {
                return this.getParentConfig().getConfigProperty(key, defaultValue);
            }
            String retval = this.wrappedConfiguration.getConfigProperty(key, null);
            if (retval != null) {
                return retval;
            }
            return this.getParentConfig().getConfigProperty(key, defaultValue);
        }

        public Configuration getWrappedConfiguration() {
            return this.wrappedConfiguration;
        }

        public void setConfigProperty(String key, String value) {
            if (this.wrappedConfiguration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modConfiguration = (ModifiableConfiguration)this.wrappedConfiguration;
                modConfiguration.setConfigProperty(key, value);
            }
        }

        public void setWrappedConfiguration(Configuration wrappedConfiguration) {
            this.wrappedConfiguration = wrappedConfiguration;
        }
    }
}

