/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import org.jfree.report.util.Log;
import org.jfree.report.util.WorkerPool;

public final class Worker
extends Thread {
    private Runnable workload = null;
    private volatile boolean finish;
    private final int sleeptime;
    private WorkerPool workerPool;

    public Worker() {
        this(120000);
    }

    public Worker(int sleeptime) {
        this.sleeptime = sleeptime;
        this.setDaemon(true);
        this.start();
    }

    public void finish() {
        this.finish = true;
        try {
            this.interrupt();
        }
        catch (SecurityException securityException) {}
        if (this.workerPool != null) {
            this.workerPool.workerFinished(this);
        }
    }

    public WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    public boolean isAvailable() {
        return this.workload == null;
    }

    public boolean isFinish() {
        return this.finish;
    }

    public synchronized void run() {
        while (!this.finish) {
            if (this.workload != null) {
                try {
                    this.workload.run();
                }
                catch (Exception e) {
                    Log.error("Worker caught exception on run: ", e);
                }
                this.workload = null;
                if (this.workerPool != null) {
                    this.workerPool.workerAvailable(this);
                }
            }
            Worker worker = this;
            synchronized (worker) {
                try {
                    this.wait(this.sleeptime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    public void setWorkload(Runnable r) {
        if (this.workload != null) {
            throw new IllegalStateException("This worker is not idle.");
        }
        Worker worker = this;
        synchronized (worker) {
            this.workload = r;
            this.notifyAll();
        }
    }
}

