/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.jfree.report.GroupFooter;
import org.jfree.report.GroupHeader;
import org.jfree.report.ReportDefinition;

public class Group
implements Serializable,
Cloneable,
Comparable {
    private String name = "anonymousGroup@" + System.identityHashCode(this);
    private TreeSet fields = new TreeSet();
    private transient String[] fieldsCached;
    private GroupHeader header;
    private GroupFooter footer = new GroupFooter();
    public static final String ANONYMOUS_GROUP_PREFIX = "anonymousGroup@";
    private ReportDefinition reportDefinition;

    public Group() {
        this.header = new GroupHeader();
    }

    public void addField(String name) {
        if (name == null) {
            throw new NullPointerException("Group.addField(...): name is null.");
        }
        this.fields.add(name);
        this.fieldsCached = null;
    }

    public Object clone() throws CloneNotSupportedException {
        Group g = (Group)super.clone();
        g.fields = new TreeSet(this.fields);
        g.fieldsCached = this.fieldsCached;
        g.footer = (GroupFooter)this.footer.clone();
        g.header = (GroupHeader)this.header.clone();
        return g;
    }

    public int compareTo(Object o) {
        Group g = (Group)o;
        if (this.fields.size() == g.fields.size()) {
            if (this.fields.containsAll(g.fields)) {
                return 0;
            }
            throw new IllegalArgumentException("These groups are not comparable, as they don't have any subgroup relation.  Groups of the same GroupList must have a subgroup relation. The designated  child group must contain all fields of the direct parent plus at least one  new field.");
        }
        if (this.fields.containsAll(g.fields)) {
            return 1;
        }
        if (g.fields.containsAll(this.fields)) {
            return -1;
        }
        throw new IllegalArgumentException("These groups are not comparable, as they don't have any subgroup relation.  Groups of the same GroupList must have a subgroup relation. The designated  child group must contain all fields of the direct parent plus at least one  new field.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group group = (Group)o;
        return this.fields.equals(group.fields);
    }

    public List getFields() {
        if (this.fieldsCached == null) {
            this.fieldsCached = this.fields.toArray(new String[this.fields.size()]);
        }
        return Collections.unmodifiableList(Arrays.asList(this.fieldsCached));
    }

    public String[] getFieldsArray() {
        if (this.fieldsCached == null) {
            this.fieldsCached = this.fields.toArray(new String[this.fields.size()]);
        }
        return this.fieldsCached;
    }

    public GroupFooter getFooter() {
        return this.footer;
    }

    public GroupHeader getHeader() {
        return this.header;
    }

    public String getName() {
        return this.name;
    }

    public ReportDefinition getReportDefinition() {
        return this.reportDefinition;
    }

    public int hashCode() {
        String[] fields = this.getFieldsArray();
        int hashCode = 0;
        int i = 0;
        while (i < fields.length) {
            hashCode = 29 * hashCode + fields[i].hashCode();
            ++i;
        }
        return hashCode;
    }

    public void setFields(List c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.fields.clear();
        this.fieldsCached = null;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            String field = (String)it.next();
            this.addField(field);
        }
    }

    public void setFooter(GroupFooter footer) {
        if (footer == null) {
            throw new NullPointerException("The footer must not be null");
        }
        this.footer.setReportDefinition(null);
        this.footer = footer;
        this.footer.setReportDefinition(this.reportDefinition);
    }

    public void setHeader(GroupHeader header) {
        if (header == null) {
            throw new NullPointerException("Header must not be null");
        }
        this.header.setReportDefinition(null);
        this.header = header;
        this.header.setReportDefinition(this.reportDefinition);
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null");
        }
        this.name = name;
    }

    public void setReportDefinition(ReportDefinition reportDefinition) {
        this.reportDefinition = reportDefinition;
        this.header.setReportDefinition(reportDefinition);
        this.footer.setReportDefinition(reportDefinition);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Group={Name='");
        b.append(this.getName());
        b.append("', fields=");
        b.append(this.fields);
        b.append("} ");
        return b.toString();
    }
}

