/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import org.jfree.report.Element;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.ContentFactoryModule;
import org.jfree.report.content.DrawableContent;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictPoint;
import org.jfree.ui.Drawable;

public class DrawableContentFactoryModule
implements ContentFactoryModule {
    public boolean canHandleContent(String contentType) {
        return contentType.startsWith("drawable/");
    }

    public Content createContentForElement(Element e, ElementLayoutInformation bounds, LayoutSupport ot) throws ContentCreationException {
        Drawable drawable = (Drawable)e.getValue();
        if (drawable == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictPoint point = bounds.getAbsolutePosition();
        StrictDimension iBounds = ElementLayoutInformation.unionMin(bounds.getMaximumSize(), bounds.getPreferredSize());
        if (iBounds.getWidth() == 0L && iBounds.getHeight() == 0L) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictBounds drawableBounds = new StrictBounds(point.getX(), point.getY(), iBounds.getWidth(), iBounds.getHeight());
        return new DrawableContent(drawable, drawableBounds);
    }
}

