/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import java.awt.Shape;
import org.jfree.report.Element;
import org.jfree.report.ShapeElement;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.ContentFactoryModule;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.content.ShapeContent;
import org.jfree.report.content.ShapeTransform;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.StringUtil;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.report.util.geom.StrictPoint;

public class ShapeContentFactoryModule
implements ContentFactoryModule {
    public boolean canHandleContent(String contentType) {
        return StringUtil.startsWithIgnoreCase(contentType, "shape/");
    }

    public Content createContentForElement(Element e, ElementLayoutInformation bounds, LayoutSupport ot) throws ContentCreationException {
        if (!e.getStyle().getBooleanStyleProperty(ShapeElement.DRAW_SHAPE) && !e.getStyle().getBooleanStyleProperty(ShapeElement.FILL_SHAPE)) {
            return EmptyContent.getDefaultEmptyContent();
        }
        Object o = e.getValue();
        if (!(o instanceof Shape)) {
            return EmptyContent.getDefaultEmptyContent();
        }
        Shape value = (Shape)e.getValue();
        if (value == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictDimension iBounds = ElementLayoutInformation.unionMin(bounds.getMaximumSize(), bounds.getPreferredSize());
        if (iBounds.getWidth() == 0L && iBounds.getHeight() == 0L) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictPoint point = bounds.getAbsolutePosition();
        Shape s = ShapeTransform.transformShape(value, e.getStyle().getBooleanStyleProperty(ElementStyleSheet.SCALE), e.getStyle().getBooleanStyleProperty(ElementStyleSheet.KEEP_ASPECT_RATIO), StrictGeomUtility.createAWTDimension(iBounds.getWidth(), iBounds.getHeight()));
        return new ShapeContent(s, new StrictBounds(point.getX(), point.getY(), iBounds.getWidth(), iBounds.getHeight()));
    }
}

