/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import org.jfree.report.content.Content;
import org.jfree.report.content.ContentType;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.layout.SizeCalculator;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;

public class TextLine
implements Content {
    private final SizeCalculator sizeCalc;
    private String content;
    private final StrictBounds bounds = new StrictBounds();
    private final long lineHeight;

    public TextLine(SizeCalculator sizeCalc, long lineheight) {
        this.lineHeight = lineheight;
        this.sizeCalc = sizeCalc;
        if (sizeCalc.getLineHeight() <= 0.0f) {
            throw new IllegalStateException("This size calculator is not valid, LineHeight is <= 0");
        }
    }

    private int calcStringLength(int startPos, long maxWidth) {
        if ((double)maxWidth == 0.0) {
            return 0;
        }
        if (this.content.length() == 0) {
            return 0;
        }
        long lineWidth = StrictGeomUtility.toInternalValue(this.getSizeCalculator().getStringWidth(this.content, startPos, this.content.length()));
        if (lineWidth <= maxWidth) {
            return this.content.length();
        }
        return this.calculateWidthPos(startPos, startPos, this.content.length(), maxWidth);
    }

    private int calculateWidthPos(int lineStart, int startPos, int endPos, long maxWidth) {
        if (startPos == endPos) {
            return startPos;
        }
        int delta = (endPos - startPos) / 2 + startPos;
        if (delta == startPos) {
            return startPos;
        }
        if (delta == endPos) {
            return endPos;
        }
        long wDelta = StrictGeomUtility.toInternalValue(this.getSizeCalculator().getStringWidth(this.content, lineStart, delta));
        if (wDelta == maxWidth) {
            return delta;
        }
        if (wDelta > maxWidth) {
            return this.calculateWidthPos(lineStart, startPos, delta, maxWidth);
        }
        return this.calculateWidthPos(lineStart, delta, endPos, maxWidth);
    }

    public StrictBounds getBounds() {
        return (StrictBounds)this.bounds.clone();
    }

    public String getContent() {
        return this.content;
    }

    public Content getContentForBounds(StrictBounds bounds) {
        int endPos;
        StrictBounds actBounds = this.bounds.createIntersection(bounds);
        if (actBounds.getHeight() < this.bounds.getHeight()) {
            return EmptyContent.getDefaultEmptyContent();
        }
        long frontW = actBounds.getX() - this.bounds.getX();
        int frontPos = this.calcStringLength(0, frontW);
        if (frontPos == (endPos = this.calcStringLength(frontPos, actBounds.getWidth()))) {
            return EmptyContent.getDefaultEmptyContent();
        }
        TextLine line = new TextLine(this.getSizeCalculator(), this.lineHeight);
        line.setContent(this.content.substring(frontPos, endPos), actBounds.getX(), actBounds.getY(), actBounds.getWidth(), actBounds.getHeight());
        return line;
    }

    public ContentType getContentType() {
        return ContentType.TEXT;
    }

    public long getHeight() {
        return this.bounds.getHeight();
    }

    public StrictBounds getMinimumContentSize() {
        return this.getBounds();
    }

    private SizeCalculator getSizeCalculator() {
        return this.sizeCalc;
    }

    public void setContent(String content, long x, long y, long width, long height) {
        if (x < 0L) {
            throw new IllegalArgumentException();
        }
        if (y < 0L) {
            throw new IllegalArgumentException();
        }
        if (width < 0L) {
            throw new IllegalArgumentException();
        }
        if (height < 0L) {
            throw new IllegalArgumentException();
        }
        this.content = content;
        width = Math.min(width, StrictGeomUtility.toInternalValue(this.getSizeCalculator().getStringWidth(content, 0, content.length())));
        height = Math.min(height, StrictGeomUtility.toInternalValue(this.getSizeCalculator().getLineHeight()));
        height = Math.max(height, this.lineHeight);
        this.bounds.setRect(x, y, width, height);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getName());
        b.append("={ content=\"");
        b.append(this.getContent());
        b.append("\", bounds=");
        b.append(this.getBounds());
        return b.toString();
    }

    public void translate(long x, long y) {
        this.bounds.setRect(this.bounds.getX() + x, this.bounds.getY() + y, this.bounds.getWidth(), this.bounds.getHeight());
    }
}

