/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.content.ContentContainer;
import org.jfree.report.content.TextLine;
import org.jfree.report.layout.SizeCalculator;
import org.jfree.report.util.WordBreakIterator;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;

public class TextParagraph
extends ContentContainer {
    private final long reservedSize;
    private final long lineHeight;
    private final boolean trimTextContent;
    private final SizeCalculator sizeCalculator;
    private final String reservedLiteral;

    public TextParagraph(SizeCalculator calc, long lineHeight, String reservedLiteral, boolean trimTextContent) {
        super(new StrictBounds());
        this.sizeCalculator = calc;
        this.reservedLiteral = reservedLiteral;
        this.reservedSize = StrictGeomUtility.toInternalValue(this.getSizeCalculator().getStringWidth(reservedLiteral, 0, reservedLiteral.length()));
        this.lineHeight = lineHeight;
        this.trimTextContent = trimTextContent;
    }

    private String appendReserveLit(String base, int lineStart, int lastCheckedChar, long width) {
        if (lastCheckedChar < 0) {
            throw new IllegalArgumentException("Start must not be negative");
        }
        if (width < 0L) {
            throw new IllegalArgumentException("Width must not be negative");
        }
        if (lineStart < 0) {
            throw new IllegalArgumentException("LineStart must not be negative");
        }
        long toTheEnd = StrictGeomUtility.toInternalValue(this.getSizeCalculator().getStringWidth(base, lineStart, base.length()));
        if (toTheEnd <= width) {
            return base.substring(lineStart);
        }
        String baseLine = base.substring(lineStart, lastCheckedChar);
        long filler = width - StrictGeomUtility.toInternalValue(this.getSizeCalculator().getStringWidth(baseLine, 0, baseLine.length())) - this.reservedSize;
        int maxFillerLength = base.length() - lastCheckedChar;
        int i = 1;
        while (i < maxFillerLength) {
            long fillerWidth = StrictGeomUtility.toInternalValue(this.getSizeCalculator().getStringWidth(base, lastCheckedChar, lastCheckedChar + i));
            if (filler < fillerWidth) {
                return String.valueOf(base.substring(lineStart, lastCheckedChar + i - 1)) + this.reservedLiteral;
            }
            ++i;
        }
        return String.valueOf(baseLine) + this.reservedLiteral;
    }

    /*
     * Unable to fully structure code
     */
    private List breakLines(String mytext, long width, long maxLines) {
        if (width <= 0L) {
            throw new IllegalArgumentException("Width must greater than 0, was " + width);
        }
        if (maxLines < 1L) {
            throw new IllegalArgumentException("MaxLines of <1 is not allowed");
        }
        breakit = new WordBreakIterator(mytext);
        returnLines = new ArrayList<String>(5);
        lineStartPos = 0;
        lineLength = mytext.length();
        if (lineLength != 0) ** GOTO lbl43
        returnLines.add("");
        return returnLines;
lbl-1000:
        // 1 sources

        {
            if (this.isTrimTextContent()) {
                while (lineStartPos < lineLength && this.isWhitespace(mytext.charAt(lineStartPos))) {
                    ++lineStartPos;
                }
            }
            if ((nextPos = this.findNextBreak(mytext, lineStartPos, width, forceEnd = (long)(returnLines.size() + 1) == maxLines, breakit)) == -1) {
                addString = mytext.substring(lineStartPos);
                if (this.isTrimTextContent()) {
                    returnLines.add(addString.trim());
                } else {
                    returnLines.add(addString);
                }
                return returnLines;
            }
            if (forceEnd) {
                addString = this.appendReserveLit(mytext, lineStartPos, nextPos, width);
                if (this.isTrimTextContent()) {
                    returnLines.add(addString.trim());
                } else {
                    returnLines.add(addString);
                }
                return returnLines;
            }
            addString = mytext.substring(lineStartPos, nextPos);
            if (this.isTrimTextContent()) {
                returnLines.add(addString.trim());
            } else {
                returnLines.add(addString);
            }
            lineStartPos = nextPos;
lbl43:
            // 2 sources

            ** while (lineStartPos < lineLength)
        }
lbl44:
        // 1 sources

        return returnLines;
    }

    protected static String clearWhitespaces(String text) {
        char[] textdata = text.toCharArray();
        int i = 0;
        while (i < textdata.length) {
            if (Character.isWhitespace(textdata[i])) {
                textdata[i] = 32;
            }
            ++i;
        }
        return new String(textdata);
    }

    private int findNextBreak(String text, int lineStart, long width, boolean forceEnd, WordBreakIterator breakit) {
        int endPos;
        int startPos = lineStart;
        long x = 0L;
        boolean enableCharBreak = true;
        while ((endPos = breakit.next()) != -1) {
            x += StrictGeomUtility.toInternalValue(this.getSizeCalculator().getStringWidth(text, startPos, endPos));
            if (forceEnd) {
                if (x >= width - this.reservedSize) {
                    return startPos;
                }
            } else if (x > width) {
                if (enableCharBreak) {
                    while (StrictGeomUtility.toInternalValue(this.getSizeCalculator().getStringWidth(text, startPos, endPos)) > width) {
                        --endPos;
                    }
                    breakit.setPosition(endPos);
                    return endPos;
                }
                endPos = breakit.previous();
                return endPos;
            }
            enableCharBreak = false;
            startPos = endPos;
        }
        return -1;
    }

    private SizeCalculator getSizeCalculator() {
        return this.sizeCalculator;
    }

    public boolean isTrimTextContent() {
        return this.trimTextContent;
    }

    private boolean isWhitespace(char c) {
        if (c == '\n' || c == '\r') {
            return false;
        }
        return Character.isWhitespace(c);
    }

    public void setContent(String content, long x, long y, long width, long height) {
        if (content == null) {
            throw new NullPointerException("MaxBounds must not be null");
        }
        if (x < 0L) {
            throw new IllegalArgumentException();
        }
        if (y < 0L) {
            throw new IllegalArgumentException();
        }
        if (width < 0L) {
            throw new IllegalArgumentException();
        }
        if (height < 0L) {
            throw new IllegalArgumentException();
        }
        long usedHeight = 0L;
        long maxLines = height / StrictGeomUtility.toInternalValue(this.getSizeCalculator().getLineHeight());
        if (maxLines > 0L) {
            List l = this.breakLines(content, width, maxLines);
            int i = 0;
            while (i < l.size()) {
                String lineText = (String)l.get(i);
                TextLine line = new TextLine(this.getSizeCalculator(), this.lineHeight);
                line.setContent(lineText, x, y + usedHeight, width, height - usedHeight);
                usedHeight += line.getHeight();
                if (line.getBounds().getHeight() > 0L) {
                    this.addContentPart(line);
                }
                ++i;
            }
        }
        this.setBounds(x, y, width, usedHeight);
    }
}

