/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.TextFieldElementFactory;
import org.jfree.report.filter.DataRowDataSource;
import org.jfree.report.filter.NumberFormatFilter;
import org.jfree.report.filter.RawDataSource;
import org.jfree.report.filter.templates.NumberFieldTemplate;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.ui.FloatDimension;

public class NumberFieldElementFactory
extends TextFieldElementFactory {
    private NumberFormat format;
    private String excelCellFormat;

    public Element createElement() {
        RawDataSource ds;
        if (this.getFieldname() == null) {
            throw new IllegalStateException("Fieldname is not set.");
        }
        if (this.format instanceof DecimalFormat) {
            NumberFieldTemplate template = new NumberFieldTemplate();
            template.setDecimalFormat((DecimalFormat)this.format);
            template.setField(this.getFieldname());
            if (this.getNullString() != null) {
                template.setNullValue(this.getNullString());
            }
            ds = template;
        } else {
            NumberFormatFilter dataSource = new NumberFormatFilter();
            if (this.format != null) {
                dataSource.setFormatter(this.format);
            }
            dataSource.setDataSource(new DataRowDataSource(this.getFieldname()));
            if (this.getNullString() != null) {
                dataSource.setNullValue(this.getNullString());
            }
            ds = dataSource;
        }
        TextElement element = new TextElement();
        this.applyElementName(element);
        element.setDataSource(ds);
        this.applyStyle(element.getStyle());
        element.getStyle().setStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, this.getExcelCellFormat());
        return element;
    }

    public static TextElement createNumberElement(String name, Rectangle2D bounds, Color color, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, String format, String field) {
        NumberFieldElementFactory factory = new NumberFieldElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(color);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setNullString(nullString);
        factory.setFormatString(format);
        factory.setFieldname(field);
        return (TextElement)factory.createElement();
    }

    public static TextElement createNumberElement(String name, Rectangle2D bounds, Color color, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, NumberFormat format, String field) {
        NumberFieldElementFactory factory = new NumberFieldElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(color);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setNullString(nullString);
        factory.setFormat(format);
        factory.setFieldname(field);
        return (TextElement)factory.createElement();
    }

    public static TextElement createNumberElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, String format, String field) {
        return NumberFieldElementFactory.createNumberElement(name, bounds, paint, alignment, null, font, nullString, format, field);
    }

    public static TextElement createNumberElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, NumberFormat format, String field) {
        return NumberFieldElementFactory.createNumberElement(name, bounds, paint, alignment, ElementAlignment.TOP, font, nullString, format, field);
    }

    public String getExcelCellFormat() {
        return this.excelCellFormat;
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public String getFormatString() {
        if (this.getFormat() instanceof DecimalFormat) {
            DecimalFormat decFormat = (DecimalFormat)this.getFormat();
            return decFormat.toPattern();
        }
        return null;
    }

    public void setExcelCellFormat(String excelCellFormat) {
        this.excelCellFormat = excelCellFormat;
    }

    public void setFormat(NumberFormat format) {
        this.format = format;
    }

    public void setFormatString(String formatString) {
        if (formatString == null) {
            this.format = null;
        } else {
            this.setFormat(new DecimalFormat(formatString));
        }
    }
}

