/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Image;
import java.io.IOException;
import org.jfree.report.DefaultImageReference;
import org.jfree.report.Element;
import org.jfree.report.ImageContainer;
import org.jfree.report.ImageElement;
import org.jfree.report.LocalImageContainer;
import org.jfree.report.elementfactory.ImageElementFactory;
import org.jfree.report.filter.StaticDataSource;

public class StaticImageElementFactory
extends ImageElementFactory {
    private ImageContainer imageContainer;

    public Element createElement() {
        if (this.getImage() == null) {
            throw new IllegalStateException("Content is not set.");
        }
        StaticDataSource datasource = new StaticDataSource(this.getImageContainer());
        ImageElement element = new ImageElement();
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.setDataSource(datasource);
        return element;
    }

    public Image getImage() {
        if (this.imageContainer == null) {
            return null;
        }
        if (this.imageContainer instanceof LocalImageContainer) {
            LocalImageContainer lc = (LocalImageContainer)this.imageContainer;
            return lc.getImage();
        }
        return null;
    }

    public ImageContainer getImageContainer() {
        return this.imageContainer;
    }

    public void setImage(Image image) throws IOException {
        this.imageContainer = new DefaultImageReference(image);
    }

    public void setImageContainer(ImageContainer imageReference) {
        this.imageContainer = imageReference;
    }

    public void setImageReference(ImageContainer imageReference) {
        this.imageContainer = imageReference;
    }
}

