/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import org.jfree.report.Element;
import org.jfree.report.ImageElement;
import org.jfree.report.elementfactory.ImageElementFactory;
import org.jfree.report.filter.templates.ImageURLElementTemplate;
import org.jfree.ui.FloatDimension;

public class StaticImageURLElementFactory
extends ImageElementFactory {
    private String content;
    private URL baseURL;

    public Element createElement() {
        if (this.getContent() == null) {
            throw new IllegalStateException("Content is not set.");
        }
        ImageURLElementTemplate template = new ImageURLElementTemplate();
        template.setBaseURL(this.getBaseURL());
        template.setContent(this.getContent());
        ImageElement element = new ImageElement();
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.setDataSource(template);
        return element;
    }

    public static ImageElement createImageElement(String name, Rectangle2D bounds, URL source) {
        return StaticImageURLElementFactory.createImageElement(name, bounds, source, true);
    }

    public static ImageElement createImageElement(String name, Rectangle2D bounds, URL source, boolean scale) {
        return StaticImageURLElementFactory.createImageElement(name, bounds, source, scale, false);
    }

    public static ImageElement createImageElement(String name, Rectangle2D bounds, URL source, boolean scale, boolean keepAspectRatio) {
        StaticImageURLElementFactory factory = new StaticImageURLElementFactory();
        factory.setName(name);
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setScale(new Boolean(scale));
        factory.setKeepAspectRatio(new Boolean(keepAspectRatio));
        factory.setContent(source.toExternalForm());
        return (ImageElement)factory.createElement();
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getContent() {
        return this.content;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

