/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jfree.report.DefaultImageReference;
import org.jfree.report.event.PageEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.util.ImageUtils;
import org.jfree.util.Log;

public class PaintDynamicComponentFunction
extends AbstractFunction
implements Serializable,
PageEventListener {
    private transient Image image;
    private transient Frame peerSupply = new Frame();
    private String field;
    private float scale;

    public PaintDynamicComponentFunction() {
        this.peerSupply.setLayout(new BorderLayout());
        this.scale = 1.0f;
    }

    private Image createComponentImage() {
        Object o = this.getDataRow().get(this.getField());
        if (!(o instanceof Component)) {
            return null;
        }
        float scale = this.getScale();
        Component comp = (Component)o;
        if (comp instanceof Window) {
            Window w = (Window)comp;
            w.pack();
        } else {
            this.peerSupply.add(comp);
            this.peerSupply.pack();
        }
        Dimension dim = comp.getSize();
        int width = Math.max(1, (int)scale * dim.width);
        int height = Math.max(1, (int)scale * dim.height);
        Log.warn((Object)("Creating image with: " + width + ", " + height));
        BufferedImage bi = ImageUtils.createTransparentImage(width, height);
        Graphics2D graph = bi.createGraphics();
        graph.setBackground(new Color(0, 0, 0, 0));
        graph.setTransform(AffineTransform.getScaleInstance(scale, scale));
        comp.paint(graph);
        graph.dispose();
        this.peerSupply.removeAll();
        return bi;
    }

    public String getField() {
        return this.field;
    }

    public Expression getInstance() {
        PaintDynamicComponentFunction pc = (PaintDynamicComponentFunction)super.getInstance();
        pc.peerSupply = new Frame();
        pc.peerSupply.setLayout(new BorderLayout());
        return pc;
    }

    public float getScale() {
        return this.scale;
    }

    public Object getValue() {
        if (this.image == null) {
            this.image = this.createComponentImage();
        }
        try {
            DefaultImageReference ref = new DefaultImageReference(this.image);
            ref.setScale(1.0f / this.getScale(), 1.0f / this.getScale());
            return ref;
        }
        catch (IOException iOException) {
            Log.warn((Object)"Unable to fully load a given image. (It should not happen here.)");
            return null;
        }
    }

    public void groupFinished(ReportEvent event) {
        this.image = null;
    }

    public void groupStarted(ReportEvent event) {
        this.image = null;
    }

    public void itemsAdvanced(ReportEvent event) {
        this.image = null;
    }

    public void pageCanceled(ReportEvent event) {
        this.image = null;
    }

    public void pageFinished(ReportEvent event) {
        this.image = null;
    }

    public void pageRolledBack(ReportEvent event) {
        this.image = null;
    }

    public void pageStarted(ReportEvent event) {
        this.image = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.peerSupply = new Frame();
        this.peerSupply.setLayout(new BorderLayout());
    }

    public void reportFinished(ReportEvent event) {
        this.image = null;
    }

    public void reportInitialized(ReportEvent event) {
        this.image = null;
    }

    public void reportStarted(ReportEvent event) {
        this.image = null;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }
}

