/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.function.FunctionUtilities;

public class TotalItemCountFunction
extends AbstractFunction
implements Serializable {
    private transient ItemCountStorage groupResult;
    private transient ArrayList results = new ArrayList();
    private transient int currentIndex;
    private String group;

    protected int getCount() {
        if (this.groupResult == null) {
            return 0;
        }
        return this.groupResult.getGroupCount();
    }

    public String getGroup() {
        return this.group;
    }

    public Expression getInstance() {
        TotalItemCountFunction function = (TotalItemCountFunction)super.getInstance();
        function.groupResult = new ItemCountStorage();
        function.results = new ArrayList();
        return function;
    }

    public Object getValue() {
        return new Integer(this.getCount());
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            return;
        }
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.groupResult = new ItemCountStorage();
            this.results.add(this.groupResult);
        } else {
            ++this.currentIndex;
            this.groupResult = (ItemCountStorage)this.results.get(this.currentIndex);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.setCount(this.getCount() + 1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new ArrayList();
        this.groupResult = new ItemCountStorage();
    }

    public void reportInitialized(ReportEvent event) {
        this.currentIndex = -1;
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.results.clear();
            this.groupResult = new ItemCountStorage();
            if (this.getGroup() == null) {
                this.results.add(this.groupResult);
            }
        } else if (this.getGroup() == null) {
            this.groupResult = (ItemCountStorage)this.results.get(0);
        }
    }

    protected void setCount(int count) {
        if (this.groupResult == null) {
            this.groupResult = new ItemCountStorage();
        }
        this.groupResult.setGroupCount(count);
    }

    public void setGroup(String group) {
        this.group = group;
    }

    private static class ItemCountStorage
    implements Serializable {
        private int groupCount;

        public int getGroupCount() {
            return this.groupCount;
        }

        public void setGroupCount(int groupCount) {
            this.groupCount = groupCount;
        }
    }
}

