/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.layout;

import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.layout.AbstractBandLayoutManager;
import org.jfree.report.layout.BandLayoutManager;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;

public strictfp final class BandLayoutManagerUtil {
    private BandLayoutManagerUtil() {
    }

    public static StrictBounds doFixedLayout(Band band, LayoutSupport support, long width, long height) {
        if (band == null) {
            throw new NullPointerException("Band is null");
        }
        if (support == null) {
            throw new NullPointerException("LayoutSupport is null");
        }
        if (width < 0L || height < 0L) {
            throw new IllegalArgumentException("Width or height is negative. [Width=" + width + ",Height=" + height + "]");
        }
        long alignedWidth = AbstractBandLayoutManager.alignDown(width, support.getInternalHorizontalAlignmentBorder());
        if (!band.isVisible()) {
            StrictBounds bounds = new StrictBounds(0L, 0L, alignedWidth, 0L);
            band.getStyle().setStyleProperty(ElementStyleSheet.BOUNDS, bounds);
            return bounds;
        }
        BandLayoutManager lm = BandLayoutManagerUtil.getLayoutManager(band);
        StrictBounds bounds = new StrictBounds(0L, 0L, alignedWidth, height);
        band.getStyle().setStyleProperty(ElementStyleSheet.BOUNDS, bounds);
        lm.doLayout(band, support);
        return bounds;
    }

    public static StrictBounds doLayout(Band band, LayoutSupport support, long width, long height) {
        if (band == null) {
            throw new NullPointerException("Band is null");
        }
        if (support == null) {
            throw new NullPointerException("LayoutSupport is null");
        }
        if (width < 0L || height < 0L) {
            throw new IllegalArgumentException("Width or height is negative.");
        }
        long alignedWidth = AbstractBandLayoutManager.alignDown(width, support.getInternalHorizontalAlignmentBorder());
        if (!band.isVisible()) {
            StrictBounds bounds = new StrictBounds(0L, 0L, alignedWidth, 0L);
            band.getStyle().setStyleProperty(ElementStyleSheet.BOUNDS, bounds);
            return bounds;
        }
        BandLayoutManager lm = BandLayoutManagerUtil.getLayoutManager(band);
        StrictDimension fdim = lm.preferredLayoutSize(band, new StrictDimension(alignedWidth, height), support);
        StrictBounds bounds = new StrictBounds(0L, 0L, alignedWidth, fdim.getHeight());
        band.getStyle().setStyleProperty(ElementStyleSheet.BOUNDS, bounds);
        lm.doLayout(band, support);
        return bounds;
    }

    public static StrictBounds getBounds(Element e, StrictBounds bounds) {
        if (e == null) {
            throw new NullPointerException("Element is null.");
        }
        if (bounds == null) {
            bounds = new StrictBounds();
        }
        StrictBounds eBounds = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        bounds.setRect(eBounds.getX(), eBounds.getY(), eBounds.getWidth(), eBounds.getHeight());
        return bounds;
    }

    public static BandLayoutManager getLayoutManager(Element e) {
        BandLayoutManager lm = (BandLayoutManager)e.getStyle().getStyleProperty(BandLayoutManager.LAYOUTMANAGER);
        if (lm == null) {
            throw new IllegalStateException("There is no layout manager defined for that band.");
        }
        return lm;
    }

    public static void setBounds(Element e, StrictBounds bounds) {
        e.getStyle().setStyleProperty(ElementStyleSheet.BOUNDS, bounds.clone());
    }
}

