/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.ExportPlugin;
import org.jfree.ui.action.ActionDowngrade;
import org.jfree.util.Log;

public class ExportAction
extends AbstractAction
implements ActionDowngrade,
Runnable {
    private ExportPlugin plugin;
    private JFreeReport report;

    public ExportAction(ExportPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException();
        }
        this.plugin = plugin;
        plugin.addPropertyChangeListener(new ExportPluginListener(this, plugin));
        if (plugin.getAcceleratorKey() != null) {
            this.putValue("AcceleratorKey", plugin.getAcceleratorKey());
        }
        if (plugin.getDisplayName() != null) {
            this.putValue("Name", plugin.getDisplayName());
        }
        if (plugin.getSmallIcon() != null) {
            this.putValue("SmallIcon", plugin.getSmallIcon());
        }
        if (plugin.getLargeIcon() != null) {
            this.putValue("ICON24", plugin.getLargeIcon());
        }
        if (plugin.getMnemonicKey() != null) {
            this.putValue("MnemonicKey", plugin.getMnemonicKey());
        }
        if (plugin.getShortDescription() != null) {
            this.putValue("ShortDescription", plugin.getShortDescription());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.plugin.isControlPlugin()) {
            SwingUtilities.invokeLater(this);
        } else {
            this.run();
        }
    }

    public JFreeReport getReport() {
        return this.report;
    }

    public void run() {
        boolean retval = this.plugin.performExport(this.report);
        if (!this.plugin.isControlPlugin() && !retval) {
            Log.info((Object)("Export failed: " + this.plugin.getFailureDescription()));
        }
    }

    public void setReport(JFreeReport report) {
        this.report = report;
    }

    private static class ExportPluginListener
    implements PropertyChangeListener {
        private ExportPlugin plugin;
        private Action action;

        public ExportPluginListener(Action action, ExportPlugin plugin) {
            this.plugin = plugin;
            this.action = action;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                this.action.setEnabled(this.plugin.isEnabled());
            }
        }
    }
}

