/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.jfree.report.modules.gui.base.ExportPlugin;
import org.jfree.report.modules.gui.base.ExportPluginSelector;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.util.WorkerPool;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public final class ExportPluginFactory {
    private static ExportPluginFactory factory;
    private final ArrayList exportPlugins = new ArrayList();
    static /* synthetic */ Class class$org$jfree$report$modules$gui$base$ExportPlugin;

    private ExportPluginFactory() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ArrayList createExportPlugIns(PreviewProxy proxy, Configuration config, WorkerPool worker) {
        ExportPluginSelector[] def = this.exportPlugins.toArray(new ExportPluginSelector[this.exportPlugins.size()]);
        Arrays.sort(def, new ExportPluginSelectorComparator());
        ArrayList<ExportPlugin> retval = new ArrayList<ExportPlugin>();
        int i = 0;
        while (i < def.length) {
            ExportPluginSelector definition = def[i];
            if (definition.isPluginValid(proxy, config)) {
                ExportPlugin ep = this.createPlugIn(proxy, definition.getPluginClass());
                if (ep != null) {
                    ep.defineWorkerPool(worker);
                    retval.add(ep);
                } else {
                    Log.warn((Object)("Cannot create plugin: " + definition.getPluginClass()));
                }
            } else {
                Log.info((Object)new Log.SimpleMessage("Plugin ", (Object)definition.getPluginClass(), (Object)" is not enabled."));
            }
            ++i;
        }
        return retval;
    }

    protected ExportPlugin createPlugIn(PreviewProxy proxy, Class plugin) {
        if (proxy == null) {
            throw new NullPointerException("PreviewProxy must not be null.");
        }
        try {
            ExportPlugin ep = (ExportPlugin)plugin.newInstance();
            ep.init(proxy);
            return ep;
        }
        catch (Exception e) {
            Log.warn((Object)("Unable to create the export plugin: " + plugin.getName()), (Exception)e);
            return null;
        }
    }

    public static ExportPluginFactory getInstance() {
        if (factory == null) {
            factory = new ExportPluginFactory();
        }
        return factory;
    }

    public void registerPlugin(ExportPluginSelector pluginSelector) {
        if (!(class$org$jfree$report$modules$gui$base$ExportPlugin != null ? class$org$jfree$report$modules$gui$base$ExportPlugin : (class$org$jfree$report$modules$gui$base$ExportPlugin = ExportPluginFactory.class$("org.jfree.report.modules.gui.base.ExportPlugin"))).isAssignableFrom(pluginSelector.getPluginClass())) {
            throw new IllegalArgumentException("Only ExportPlugin implementations are allowed");
        }
        if (!this.exportPlugins.contains(pluginSelector)) {
            this.exportPlugins.add(pluginSelector);
        }
    }

    private static class ExportPluginSelectorComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            ExportPluginSelector s1 = (ExportPluginSelector)o1;
            ExportPluginSelector s2 = (ExportPluginSelector)o2;
            return s1.getPreference().compareTo(s2.getPreference());
        }
    }
}

