/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jfree.layout.CenterLayout;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.PageDefinition;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.SimplePageDefinition;
import org.jfree.report.event.RepaginationListener;
import org.jfree.report.modules.gui.base.AboutAction;
import org.jfree.report.modules.gui.base.ExportAction;
import org.jfree.report.modules.gui.base.ExportPlugin;
import org.jfree.report.modules.gui.base.ExportPluginFactory;
import org.jfree.report.modules.gui.base.FirstPageAction;
import org.jfree.report.modules.gui.base.GotoPageAction;
import org.jfree.report.modules.gui.base.LastPageAction;
import org.jfree.report.modules.gui.base.NextPageAction;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.modules.gui.base.PreviousPageAction;
import org.jfree.report.modules.gui.base.ReportControler;
import org.jfree.report.modules.gui.base.ReportPane;
import org.jfree.report.modules.gui.base.ReportProgressBar;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.gui.base.ZoomInAction;
import org.jfree.report.modules.gui.base.ZoomOutAction;
import org.jfree.report.modules.gui.base.components.ExceptionDialog;
import org.jfree.report.modules.gui.base.components.WindowSizeLimiter;
import org.jfree.report.util.ImageUtils;
import org.jfree.report.util.Worker;
import org.jfree.report.util.WorkerPool;
import org.jfree.ui.FloatingButtonEnabler;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.about.AboutFrame;
import org.jfree.ui.about.ProjectInfo;
import org.jfree.ui.action.AbstractActionDowngrade;
import org.jfree.ui.action.ActionButton;
import org.jfree.ui.action.ActionMenuItem;
import org.jfree.ui.action.DowngradeActionMap;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.ResourceBundleSupport;

public class PreviewProxyBase
extends JComponent {
    public static final String LARGE_ICONS_PROPERTY = "largeIconsEnabled";
    public static final String GOTO_ACTION_KEY = "GotoAction";
    public static final String ABOUT_ACTION_KEY = "AboutAction";
    public static final String CLOSE_ACTION_KEY = "CloseAction";
    public static final String FIRSTPAGE_ACTION_KEY = "FirstPageAction";
    public static final String LASTPAGE_ACTION_KEY = "LastPageAction";
    public static final String NEXT_PAGE_ACTION_KEY = "NextPageAction";
    public static final String PREV_PAGE_ACTION_KEY = "PreviousPageAction";
    public static final String ZOOM_IN_ACTION_KEY = "ZoomInAction";
    public static final String ZOOM_OUT_ACTION_KEY = "ZoomOutAction";
    public static final int DEFAULT_REPORT_PANE_WIDTH = 640;
    public static final int DEFAULT_REPORT_PANE_HEIGHT = 480;
    public static final String PREVIEW_PREFERRED_WIDTH = "org.jfree.report.modules.gui.base.PreferredWidth";
    public static final String PREVIEW_PREFERRED_HEIGHT = "org.jfree.report.modules.gui.base.PreferredHeight";
    public static final String PREVIEW_MAXIMUM_WIDTH = "org.jfree.report.modules.gui.base.MaximumWidth";
    public static final String PREVIEW_MAXIMUM_HEIGHT = "org.jfree.report.modules.gui.base.MaximumHeight";
    public static final String PROGRESS_BAR_ENABLE_PROPERTY = "org.jfree.report.modules.gui.base.ProgressBarEnabled";
    public static final String PROGRESS_DIALOG_ENABLE_PROPERTY = "org.jfree.report.modules.gui.base.ProgressDialogEnabled";
    public static final String LARGE_ICONS_ENABLED_PROPERTY = "org.jfree.report.modules.gui.base.LargeIcons";
    public static final String TOOLBAR_FLOATABLE_PROPERTY = "org.jfree.report.modules.gui.base.ToolbarFloatable";
    public static final String CREATE_TOOLBAR_PROPERTY = "org.jfree.report.modules.gui.base.ToolbarAvailable";
    public static final String CREATE_MENUBAR_PROPERTY = "org.jfree.report.modules.gui.base.MenuBarAvailable";
    public static final String TOOLBAR_FLOATABLE_PROPERTYNAME = "toolbarFloatable";
    public static final String ACTION_ABOUT_PROPERTY = "org.jfree.report.modules.gui.base.About";
    public static final String ACTION_ZOOM_PROPERTY = "org.jfree.report.modules.gui.base.Zoom";
    public static final String ACTION_NAVIGATION_PROPERTY = "org.jfree.report.modules.gui.base.Navigate";
    private static final String ACTION_CLOSE_PROPERTY = "org.jfree.report.modules.gui.base.Close";
    private static final boolean PREPARE_REPAGINATION = false;
    private static final boolean POST_REPAGINATION = true;
    public static final String CONF_TOOLBAR_ENABLED = "toolbar";
    public static final String CONF_ALL_ENABLED = "enable";
    public static final String CONF_ALL_DISABLED = "disable";
    public static final String CONF_MENUBAR_ENABLED = "menubar";
    public static final String REPORT_PANE_PROPERTY = "reportPane";
    private Worker repaginationWorker;
    private WorkerPool exportWorkerPool;
    private DowngradeActionMap baseActionMap;
    private DowngradeActionMap navigationActionMap;
    private DowngradeActionMap zoomActionMap;
    private DowngradeActionMap exportActionMap;
    private final DowngradeActionMap customActionMap;
    protected static final float[] ZOOM_FACTORS = new float[]{0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 3.0f, 4.0f};
    private static final int DEFAULT_ZOOM_INDEX = 3;
    private JComboBox zoomSelect;
    private int zoomIndex;
    private ReportPane reportPane;
    private ResourceBundleSupport resources;
    private boolean largeIconsEnabled;
    private JLabel statusHolder;
    private JToolBar toolbar;
    private boolean toolbarFloatable;
    private PreviewProxy proxy;
    private ArrayList exportPlugIns;
    private HashMap pluginActions;
    private ReportProgressDialog progressDialog;
    private ReportProgressBar progressBar;
    private boolean lockInterface;
    private boolean closed;
    private JPanel innerReportControlerHolder;
    private JPanel toolbarHolder;
    private JPanel reportPaneHolder;
    private ReportPanePropertyChangeListener reportPanePropertyChangeListener;
    private boolean progressDialogEnabled;
    private boolean progressBarEnabled;
    private ReportControler reportControler;
    private boolean reportControlerInner;
    private String reportControlerLocation;
    private JComponent reportControlerComponent;
    private JPanel outerReportControlerHolder;

    public PreviewProxyBase(PreviewProxy proxy) {
        if (proxy == null) {
            throw new NullPointerException("Proxy must not be null.");
        }
        this.baseActionMap = new DowngradeActionMap();
        this.customActionMap = new DowngradeActionMap();
        this.exportActionMap = new DowngradeActionMap();
        this.exportActionMap.setParent(this.baseActionMap);
        this.navigationActionMap = new DowngradeActionMap();
        this.navigationActionMap.setParent(this.baseActionMap);
        this.zoomActionMap = new DowngradeActionMap();
        this.zoomActionMap.setParent(this.baseActionMap);
        this.proxy = proxy;
        this.progressDialog = new ReportProgressDialog();
        this.progressDialog.setDefaultCloseOperation(0);
        this.progressBar = new ReportProgressBar();
        this.reportPanePropertyChangeListener = new ReportPanePropertyChangeListener();
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(false);
        proxy.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Component c = e.getComponent();
                if (c instanceof Window) {
                    Window w = (Window)c;
                    w.dispose();
                    PreviewProxyBase.this.dispose();
                }
            }
        });
        this.createDefaultActions();
        this.reportPaneHolder = new JPanel((LayoutManager)new CenterLayout());
        this.reportPaneHolder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane s1 = new JScrollPane(this.reportPaneHolder);
        s1.getVerticalScrollBar().setUnitIncrement(20);
        this.innerReportControlerHolder = new JPanel();
        this.innerReportControlerHolder.setLayout(new BorderLayout());
        this.innerReportControlerHolder.add((Component)s1, "Center");
        this.toolbarHolder = new JPanel();
        this.toolbarHolder.setLayout(new BorderLayout());
        this.toolbarHolder.add((Component)this.innerReportControlerHolder, "Center");
        this.outerReportControlerHolder = new JPanel();
        this.outerReportControlerHolder.setLayout(new BorderLayout());
        this.outerReportControlerHolder.add((Component)this.toolbarHolder, "Center");
        this.add((Component)this.outerReportControlerHolder, "Center");
        this.add((Component)this.createStatusBar(), "South");
        this.zoomSelect = this.createZoomSelector();
    }

    public void addRepaginationListener(RepaginationListener listener) {
        this.reportPane.addRepaginationListener(listener);
    }

    private void applyDefinedDimension(JFreeReport report) {
        block5: {
            String width = report.getReportConfiguration().getConfigProperty(PREVIEW_PREFERRED_WIDTH);
            String height = report.getReportConfiguration().getConfigProperty(PREVIEW_PREFERRED_HEIGHT);
            if (width != null && height != null) {
                try {
                    Dimension pref = this.createCorrectedDimensions(Integer.parseInt(width), Integer.parseInt(height));
                    this.setPreferredSize(pref);
                }
                catch (Exception exception) {
                    Log.warn((Object)"Preferred viewport size is defined, but the specified values are invalid.");
                }
            }
            width = report.getReportConfiguration().getConfigProperty(PREVIEW_MAXIMUM_WIDTH);
            height = report.getReportConfiguration().getConfigProperty(PREVIEW_MAXIMUM_HEIGHT);
            if (width == null && height == null) break block5;
            try {
                int iWidth = width == null ? Short.MAX_VALUE : (int)this.parseRelativeFloat(width);
                int iHeight = height == null ? Short.MAX_VALUE : (int)this.parseRelativeFloat(height);
                Dimension pref = this.createCorrectedDimensions(iWidth, iHeight);
                this.setMaximumSize(pref);
                this.addComponentListener(new WindowSizeLimiter());
            }
            catch (Exception exception) {
                Log.warn((Object)"Maximum viewport size is defined, but the specified values are invalid.");
            }
        }
    }

    private void buildExportPlugins(JFreeReport report) {
        ExportPluginFactory factory = ExportPluginFactory.getInstance();
        this.exportPlugIns = factory.createExportPlugIns(this.proxy, (Configuration)report.getReportConfiguration(), this.getExportWorkerPool());
        this.pluginActions = new HashMap(this.exportPlugIns.size());
        Iterator it = ((AbstractList)this.exportPlugIns).iterator();
        while (it.hasNext()) {
            ExportPlugin ep = (ExportPlugin)it.next();
            ExportAction ea = new ExportAction(ep);
            ea.setReport(report);
            this.pluginActions.put(ep, ea);
        }
    }

    public synchronized void close() {
        this.closed = true;
        if (this.exportWorkerPool != null) {
            this.exportWorkerPool.finishAll();
            this.exportWorkerPool = null;
        }
        if (this.repaginationWorker != null) {
            this.repaginationWorker.finish();
            this.repaginationWorker = null;
        }
        if (this.progressDialog.isVisible()) {
            ((Component)this.progressDialog).setVisible(false);
            this.progressDialog.dispose();
        }
        this.closeToolbar();
        this.dispose();
    }

    private void closeToolbar() {
        Window w;
        if (this.toolbar.getParent() != this.toolbarHolder && (w = SwingUtilities.windowForComponent(this.toolbar)) != null) {
            ((Component)w).setVisible(false);
            w.dispose();
        }
        this.toolbar.setVisible(false);
    }

    protected JButton createButton(Action action) {
        Icon icon;
        ActionButton button = new ActionButton(action);
        if (this.isLargeIconsEnabled() && (icon = (Icon)action.getValue("ICON24")) != null) {
            button.setIcon(icon);
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setText(null);
        FloatingButtonEnabler.getInstance().addButton((AbstractButton)button);
        return button;
    }

    private Dimension createCorrectedDimensions(int w, int h) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (w < 0) {
            w = w * screenSize.width / -100;
        }
        if (h < 0) {
            h = h * screenSize.height / -100;
        }
        return new Dimension(w, h);
    }

    protected Action createDefaultAboutAction() {
        return new DefaultAboutAction();
    }

    private void createDefaultActions() {
        this.navigationActionMap.put((Object)GOTO_ACTION_KEY, this.createDefaultGotoAction());
        this.baseActionMap.put((Object)ABOUT_ACTION_KEY, this.createDefaultAboutAction());
        this.navigationActionMap.put((Object)FIRSTPAGE_ACTION_KEY, this.createDefaultFirstPageAction());
        this.navigationActionMap.put((Object)LASTPAGE_ACTION_KEY, this.createDefaultLastPageAction());
        this.navigationActionMap.put((Object)NEXT_PAGE_ACTION_KEY, this.createDefaultNextPageAction());
        this.navigationActionMap.put((Object)PREV_PAGE_ACTION_KEY, this.createDefaultPreviousPageAction());
        Action zoomInAction = this.createDefaultZoomInAction();
        Action zoomOutAction = this.createDefaultZoomOutAction();
        this.zoomActionMap.put((Object)ZOOM_IN_ACTION_KEY, zoomInAction);
        this.zoomActionMap.put((Object)ZOOM_OUT_ACTION_KEY, zoomOutAction);
    }

    protected Action createDefaultFirstPageAction() {
        return new DefaultFirstPageAction();
    }

    protected Action createDefaultGotoAction() {
        return new DefaultGotoAction();
    }

    protected Action createDefaultLastPageAction() {
        return new DefaultLastPageAction();
    }

    protected Action createDefaultNextPageAction() {
        return new DefaultNextPageAction();
    }

    protected Action createDefaultPreviousPageAction() {
        return new DefaultPreviousPageAction();
    }

    protected Action createDefaultZoomInAction() {
        return new DefaultZoomInAction();
    }

    protected Action createDefaultZoomOutAction() {
        return new DefaultZoomOutAction();
    }

    protected JMenu createFileMenu() {
        ResourceBundleSupport resources = this.getResources();
        JMenu fileMenu = new JMenu(resources.getString("menu.file.name"));
        Integer mnemonic = resources.getMnemonic("menu.file.mnemonic");
        fileMenu.setMnemonic(mnemonic);
        Iterator it = ((AbstractList)this.exportPlugIns).iterator();
        boolean addedItem = it.hasNext();
        while (it.hasNext()) {
            ExportPlugin plugIn = (ExportPlugin)it.next();
            ExportAction action = (ExportAction)this.pluginActions.get(plugIn);
            if (plugIn.isSeparated()) {
                fileMenu.addSeparator();
            }
            fileMenu.add(this.createMenuItem(action));
        }
        if (addedItem) {
            fileMenu.addSeparator();
        }
        fileMenu.add(this.createMenuItem(this.getCloseAction()));
        return fileMenu;
    }

    protected JMenu createHelpMenu() {
        ResourceBundleSupport resources = this.getResources();
        JMenu helpMenu = new JMenu(resources.getString("menu.help.name"));
        Integer mnemonic = resources.getMnemonic("menu.help.mnemonic");
        helpMenu.setMnemonic(mnemonic);
        helpMenu.add(this.createMenuItem(this.getAboutAction()));
        return helpMenu;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        if (this.isMenuActionEnabled(ACTION_NAVIGATION_PROPERTY)) {
            menuBar.add(this.createNavigationMenu());
        }
        if (this.isMenuActionEnabled(ACTION_ZOOM_PROPERTY)) {
            menuBar.add(this.createZoomMenu());
        }
        if (this.reportControler != null) {
            JMenu[] menus = this.reportControler.getMenus();
            int i = 0;
            while (i < menus.length) {
                menuBar.add(menus[i]);
                ++i;
            }
        }
        if (this.isMenuActionEnabled(ACTION_ABOUT_PROPERTY)) {
            menuBar.add(this.createHelpMenu());
        }
        return menuBar;
    }

    protected JMenuItem createMenuItem(Action action) {
        ActionMenuItem menuItem = new ActionMenuItem(action);
        KeyStroke accelerator = (KeyStroke)action.getValue("AcceleratorKey");
        if (accelerator != null) {
            menuItem.setAccelerator(accelerator);
        }
        return menuItem;
    }

    protected JMenu createNavigationMenu() {
        ResourceBundleSupport resources = this.getResources();
        JMenu navMenu = new JMenu(resources.getString("menu.navigation.name"));
        Integer mnemonic = resources.getMnemonic("menu.navigation.mnemonic");
        navMenu.setMnemonic(mnemonic);
        navMenu.add(this.createMenuItem(this.getGotoAction()));
        navMenu.addSeparator();
        navMenu.add(this.createMenuItem(this.getFirstPageAction()));
        navMenu.add(this.createMenuItem(this.getPreviousPageAction()));
        navMenu.add(this.createMenuItem(this.getNextPageAction()));
        navMenu.add(this.createMenuItem(this.getLastPageAction()));
        return navMenu;
    }

    protected ReportPane createReportPane(JFreeReport report) throws ReportProcessingException {
        return new ReportPane(report);
    }

    protected JPanel createStatusBar() {
        JPanel statusPane = new JPanel();
        statusPane.setLayout(new BorderLayout());
        statusPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        statusPane.setMinimumSize(this.statusHolder.getPreferredSize());
        statusPane.add((Component)this.statusHolder, "Center");
        statusPane.add((Component)this.progressBar, "East");
        return statusPane;
    }

    protected JToolBar createToolBar() {
        return new JToolBar();
    }

    protected JMenu createZoomMenu() {
        ResourceBundleSupport resources = this.getResources();
        JMenu zoomMenu = new JMenu(resources.getString("menu.zoom.name"));
        Integer mnemonic = resources.getMnemonic("menu.zoom.mnemonic");
        zoomMenu.setMnemonic(mnemonic);
        zoomMenu.add(this.createMenuItem(this.getZoomInAction()));
        zoomMenu.add(this.createMenuItem(this.getZoomOutAction()));
        zoomMenu.add(new JSeparator());
        DowngradeActionMap zoomActionMap = this.getZoomActionMap();
        int i = 0;
        while (i < ZOOM_FACTORS.length) {
            ZoomSetAction action = new ZoomSetAction(i);
            zoomActionMap.put(action.getValue("Name"), (Action)((Object)action));
            zoomMenu.add(this.createMenuItem((Action)((Object)action)));
            ++i;
        }
        return zoomMenu;
    }

    protected JComponent createZoomPane() {
        JPanel zoomPane = new JPanel();
        zoomPane.setLayout(new FlowLayout(0));
        zoomPane.add(this.zoomSelect);
        return zoomPane;
    }

    protected Action createZoomSelectAction() {
        return new ZoomSelectAction();
    }

    protected JComboBox createZoomSelector() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        int i = 0;
        while (i < ZOOM_FACTORS.length) {
            model.addElement(String.valueOf(String.valueOf((int)(ZOOM_FACTORS[i] * 100.0f))) + " %");
            ++i;
        }
        JComboBox zoomSelect = new JComboBox(model);
        zoomSelect.setActionCommand("ZoomSelect");
        zoomSelect.setSelectedIndex(3);
        zoomSelect.addActionListener(this.createZoomSelectAction());
        zoomSelect.setAlignmentX(1.0f);
        return zoomSelect;
    }

    protected void decreasePageNumber() {
        int pn = this.reportPane.getPageNumber();
        if (pn > 1) {
            this.reportPane.setPageNumber(pn - 1);
        }
    }

    protected void decreaseZoom() {
        if (this.zoomIndex > 0) {
            --this.zoomIndex;
        }
        this.zoomSelect.setSelectedIndex(this.zoomIndex);
        this.reportPane.setZoomFactor(this.getZoomFactor());
    }

    protected void disableButtons() {
        this.getGotoAction().setEnabled(false);
        this.getLastPageAction().setEnabled(false);
        this.getNextPageAction().setEnabled(false);
        this.getPreviousPageAction().setEnabled(false);
        this.getFirstPageAction().setEnabled(false);
        Object[] keys = this.zoomActionMap.keys();
        int i = 0;
        while (i < keys.length) {
            this.zoomActionMap.get(keys[i]).setEnabled(false);
            ++i;
        }
        this.zoomSelect.setEnabled(false);
        Iterator it = this.pluginActions.values().iterator();
        while (it.hasNext()) {
            ExportAction ea = (ExportAction)it.next();
            ea.setEnabled(false);
        }
    }

    public void dispose() {
        this.freeResources();
        RepaintManager.currentManager(this).removeInvalidComponent(this);
        RepaintManager.currentManager(this).markCompletelyClean(this);
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            this.close();
        }
        super.finalize();
    }

    protected void firstPage() {
        if (this.reportPane.getPageNumber() != 1) {
            this.reportPane.setPageNumber(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void freeResources() {
        block10: {
            try {
                if (this.repaginationWorker == null) break block10;
                this.repaginationWorker.interrupt();
                Worker worker = this.repaginationWorker;
                synchronized (worker) {
                    while (!this.repaginationWorker.isAvailable()) {
                        try {
                            this.repaginationWorker.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.repaginationWorker = null;
            }
            catch (SecurityException securityException) {}
        }
        if (this.progressDialog.isVisible()) {
            ((Component)this.progressDialog).setVisible(false);
            this.progressDialog.dispose();
        }
        this.reportPane.dispose();
    }

    public Action getAboutAction() {
        return this.baseActionMap.get((Object)ABOUT_ACTION_KEY);
    }

    public DowngradeActionMap getBaseActionMap() {
        return this.baseActionMap;
    }

    public Action getCloseAction() {
        return this.baseActionMap.get((Object)CLOSE_ACTION_KEY);
    }

    public DowngradeActionMap getCustomActionMap() {
        return this.customActionMap;
    }

    public DowngradeActionMap getExportActionMap() {
        return this.exportActionMap;
    }

    protected HashMap getExportActions() {
        return this.pluginActions;
    }

    protected List getExportPlugins() {
        return this.exportPlugIns;
    }

    protected synchronized WorkerPool getExportWorkerPool() {
        if (this.exportWorkerPool == null) {
            this.exportWorkerPool = new WorkerPool(5, "export-worker-");
        }
        return this.exportWorkerPool;
    }

    public Action getFirstPageAction() {
        return this.navigationActionMap.get((Object)FIRSTPAGE_ACTION_KEY);
    }

    public Action getGotoAction() {
        return this.navigationActionMap.get((Object)GOTO_ACTION_KEY);
    }

    public Action getLastPageAction() {
        return this.navigationActionMap.get((Object)LASTPAGE_ACTION_KEY);
    }

    public DowngradeActionMap getNavigationActionMap() {
        return this.navigationActionMap;
    }

    public Action getNextPageAction() {
        return this.navigationActionMap.get((Object)NEXT_PAGE_ACTION_KEY);
    }

    public Pageable getPageable() {
        return this.reportPane;
    }

    public Action getPreviousPageAction() {
        return this.navigationActionMap.get((Object)PREV_PAGE_ACTION_KEY);
    }

    public Printable getPrintable() {
        return this.reportPane;
    }

    protected ReportProgressBar getProgressBar() {
        return this.progressBar;
    }

    protected ReportProgressDialog getProgressDialog() {
        return this.progressDialog;
    }

    protected synchronized Worker getRepaginationWorker() {
        if (this.repaginationWorker == null) {
            this.repaginationWorker = new Worker();
            this.repaginationWorker.setPriority(1);
            this.repaginationWorker.setName("Repagination-Worker");
            this.closed = false;
        }
        return this.repaginationWorker;
    }

    public JFreeReport getReport() {
        return this.reportPane.getReport();
    }

    public ReportControler getReportControler() {
        return this.reportControler;
    }

    public ReportPane getReportPane() {
        return this.reportPane;
    }

    protected ResourceBundleSupport getResources() {
        if (this.resources == null) {
            this.resources = new ResourceBundleSupport("org.jfree.report.modules.gui.base.resources.jfreereport-resources");
        }
        return this.resources;
    }

    public String getStatusText() {
        return this.statusHolder.getText();
    }

    protected final JToolBar getToolbar() {
        return this.toolbar;
    }

    public DowngradeActionMap getZoomActionMap() {
        return this.zoomActionMap;
    }

    public float getZoomFactor() {
        return ZOOM_FACTORS[this.zoomIndex];
    }

    public Action getZoomInAction() {
        return this.zoomActionMap.get((Object)ZOOM_IN_ACTION_KEY);
    }

    public Action getZoomOutAction() {
        return this.zoomActionMap.get((Object)ZOOM_OUT_ACTION_KEY);
    }

    protected JComboBox getZoomSelect() {
        return this.zoomSelect;
    }

    protected void increasePageNumber() {
        int mp;
        int pn = this.reportPane.getPageNumber();
        if (pn < (mp = this.reportPane.getNumberOfPages())) {
            this.reportPane.setPageNumber(pn + 1);
        }
    }

    protected void increaseZoom() {
        if (this.zoomIndex < ZOOM_FACTORS.length - 1) {
            ++this.zoomIndex;
        }
        this.zoomSelect.setSelectedIndex(this.zoomIndex);
        this.reportPane.setZoomFactor(this.getZoomFactor());
    }

    public void init(JFreeReport report) throws ReportProcessingException {
        this.setReport(report);
    }

    protected void initializeToolBar() {
        if (this.toolbar == null) {
            return;
        }
        this.toolbar.removeAll();
        Iterator it = ((AbstractList)this.exportPlugIns).iterator();
        boolean addedItem = it.hasNext();
        if (this.isToolbarActionEnabled(ACTION_CLOSE_PROPERTY)) {
            this.toolbar.add(this.createButton(this.getCloseAction()));
            this.toolbar.addSeparator();
        }
        while (it.hasNext()) {
            ExportPlugin plugIn = (ExportPlugin)it.next();
            if (!plugIn.isAddToToolbar()) continue;
            ExportAction action = (ExportAction)this.pluginActions.get(plugIn);
            if (plugIn.isSeparated()) {
                this.toolbar.addSeparator();
            }
            this.toolbar.add(this.createButton(action));
        }
        if (addedItem) {
            this.toolbar.addSeparator();
        }
        if (this.isToolbarActionEnabled(ACTION_NAVIGATION_PROPERTY)) {
            this.toolbar.add(this.createButton(this.getFirstPageAction()));
            this.toolbar.add(this.createButton(this.getPreviousPageAction()));
            this.toolbar.add(this.createButton(this.getNextPageAction()));
            this.toolbar.add(this.createButton(this.getLastPageAction()));
            this.toolbar.addSeparator();
        }
        if (this.isToolbarActionEnabled(ACTION_ZOOM_PROPERTY)) {
            this.toolbar.add(this.createButton(this.getZoomInAction()));
            this.toolbar.add(this.createButton(this.getZoomOutAction()));
            this.toolbar.addSeparator();
            this.toolbar.add(this.createZoomPane());
            this.toolbar.addSeparator();
        }
        Object[] keys = this.getCustomActionMap().keys();
        int i = 0;
        while (i < keys.length) {
            Action a = this.getCustomActionMap().get(keys[i]);
            this.toolbar.add(this.createButton(a));
            ++i;
        }
        if (keys.length > 0) {
            this.toolbar.addSeparator();
        }
        if (this.isToolbarActionEnabled(ACTION_ABOUT_PROPERTY)) {
            this.toolbar.add(this.createButton(this.getAboutAction()));
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isLargeIconsEnabled() {
        return this.largeIconsEnabled;
    }

    public boolean isLockInterface() {
        return this.lockInterface;
    }

    protected boolean isMenuActionEnabled(String property) {
        Configuration config = JFreeReportBoot.getInstance().getGlobalConfig();
        String value = config.getConfigProperty(property);
        if (value == null) {
            return true;
        }
        if (value.equals(CONF_MENUBAR_ENABLED)) {
            return true;
        }
        return value.equals(CONF_ALL_ENABLED);
    }

    public boolean isProgressBarEnabled() {
        return this.progressBarEnabled;
    }

    public boolean isProgressDialogEnabled() {
        return this.progressDialogEnabled;
    }

    private boolean isPropertySet(String property, boolean defaultValue) {
        Configuration config = JFreeReportBoot.getInstance().getGlobalConfig();
        String value = config.getConfigProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return value.equals(String.valueOf(defaultValue));
    }

    protected boolean isToolbarActionEnabled(String property) {
        Configuration config = JFreeReportBoot.getInstance().getGlobalConfig();
        String value = config.getConfigProperty(property);
        if (value == null) {
            return true;
        }
        if (value.equals(CONF_TOOLBAR_ENABLED)) {
            return true;
        }
        return value.equals(CONF_ALL_ENABLED);
    }

    public boolean isToolbarFloatable() {
        return this.toolbarFloatable;
    }

    protected void lastPage() {
        this.reportPane.setPageNumber(this.reportPane.getNumberOfPages());
    }

    protected float parseRelativeFloat(String value) {
        if (value == null) {
            throw new NumberFormatException();
        }
        String tvalue = value.trim();
        if (tvalue.endsWith("%")) {
            String number = tvalue.substring(0, tvalue.indexOf("%"));
            return Float.parseFloat(number) * -1.0f;
        }
        return Float.parseFloat(tvalue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performPagination() {
        Worker worker;
        this.setLockInterface(true);
        this.setStatusText(this.getResources().getString("statusline.repaginate"));
        this.progressDialog.setTitle(this.getResources().getString("statusline.repaginate"));
        this.progressDialog.setMessage(this.getResources().getString("statusline.repaginate"));
        this.progressDialog.pack();
        Worker worker2 = worker = this.getRepaginationWorker();
        synchronized (worker2) {
            while (true) {
                if (worker.isAvailable()) {
                    this.getRepaginationWorker().setWorkload(new RepaginationRunnable());
                    return;
                }
                try {
                    worker.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void refresh() throws ReportProcessingException {
        JFreeReport report = this.reportPane.getReport();
        this.setReport(report);
    }

    public void refreshControler() {
        this.reinitialize();
        if (this.reportControler != null) {
            JComponent rcp = this.reportControler.getControlPanel();
            if (this.reportControlerComponent != rcp || this.reportControlerInner != this.reportControler.isInnerComponent() || ObjectUtilities.equal((Object)this.reportControlerLocation, (Object)this.reportControler.getControlerLocation())) {
                if (this.reportControlerComponent != null) {
                    this.outerReportControlerHolder.remove(this.reportControlerComponent);
                    this.innerReportControlerHolder.remove(this.reportControlerComponent);
                }
                String sanLocation = this.sanitizeLocation(this.reportControler.getControlerLocation());
                boolean innerComponent = this.reportControler.isInnerComponent();
                if (rcp != null) {
                    if (innerComponent) {
                        this.innerReportControlerHolder.add((Component)rcp, sanLocation);
                    } else {
                        this.outerReportControlerHolder.add((Component)rcp, sanLocation);
                    }
                }
                this.reportControlerComponent = rcp;
                this.reportControlerLocation = sanLocation;
                this.reportControlerInner = innerComponent;
            }
        } else {
            if (this.reportControlerComponent != null) {
                this.outerReportControlerHolder.remove(this.reportControlerComponent);
                this.innerReportControlerHolder.remove(this.reportControlerComponent);
            }
            this.reportControlerComponent = null;
        }
    }

    protected void registerAction(Action action) {
        KeyStroke key = (KeyStroke)action.getValue("AcceleratorKey");
        if (key != null) {
            this.registerKeyboardAction(action, key, 2);
        }
    }

    protected void reinitialize() {
        this.initializeToolBar();
        if (this.isPropertySet(CREATE_MENUBAR_PROPERTY, true)) {
            this.proxy.setJMenuBar(this.createMenuBar());
        } else {
            this.proxy.setJMenuBar(null);
        }
    }

    public void removeRepaginationListener(RepaginationListener listener) {
        this.reportPane.removeRepaginationListener(listener);
    }

    private String sanitizeLocation(String location) {
        if ("North".equals(location)) {
            return "North";
        }
        if ("South".equals(location)) {
            return "South";
        }
        if ("West".equals(location)) {
            return "West";
        }
        if ("East".equals(location)) {
            return "East";
        }
        return "North";
    }

    public void setAboutAction(Action aboutAction) {
        this.baseActionMap.put((Object)ABOUT_ACTION_KEY, aboutAction);
    }

    public void setCloseAction(Action closeAction) {
        this.baseActionMap.put((Object)CLOSE_ACTION_KEY, closeAction);
    }

    public void setFirstPageAction(Action firstPageAction) {
        this.navigationActionMap.put((Object)FIRSTPAGE_ACTION_KEY, firstPageAction);
    }

    public void setGotoAction(Action gotoAction) {
        this.navigationActionMap.put((Object)GOTO_ACTION_KEY, gotoAction);
    }

    public void setLargeIconsEnabled(boolean b) {
        boolean oldValue = this.largeIconsEnabled;
        this.largeIconsEnabled = b;
        this.firePropertyChange(LARGE_ICONS_PROPERTY, oldValue, b);
    }

    public void setLastPageAction(Action lastPageAction) {
        this.navigationActionMap.put((Object)LASTPAGE_ACTION_KEY, lastPageAction);
    }

    public void setLockInterface(boolean lockInterface) {
        boolean oldLockInterface = this.lockInterface;
        this.lockInterface = lockInterface;
        if (lockInterface) {
            this.disableButtons();
        } else {
            this.validateButtons();
        }
        this.firePropertyChange("lockInterface", oldLockInterface, lockInterface);
    }

    public void setNextPageAction(Action nextPageAction) {
        this.navigationActionMap.put((Object)NEXT_PAGE_ACTION_KEY, nextPageAction);
    }

    public void setPreviousPageAction(Action previousPageAction) {
        this.navigationActionMap.put((Object)PREV_PAGE_ACTION_KEY, previousPageAction);
    }

    public void setProgressBarEnabled(boolean progressBarEnabled) {
        this.progressBarEnabled = progressBarEnabled;
    }

    public void setProgressDialogEnabled(boolean progressDialogEnabled) {
        this.progressDialogEnabled = progressDialogEnabled;
    }

    public void setReport(JFreeReport report) throws ReportProcessingException {
        ReportPane oldPane = this.reportPane;
        if (this.reportPane != null) {
            this.freeResources();
            this.reportPane.removeRepaginationListener(this.progressDialog);
            this.reportPane.removePropertyChangeListener(this.reportPanePropertyChangeListener);
            this.reportPaneHolder.remove(this.reportPane);
            this.reportPane = null;
        }
        this.setLargeIconsEnabled(report.getReportConfiguration().getConfigProperty(LARGE_ICONS_ENABLED_PROPERTY, "true").equals("true"));
        this.setToolbarFloatable(report.getReportConfiguration().getConfigProperty(TOOLBAR_FLOATABLE_PROPERTY, "true").equals("true"));
        this.setProgressBarEnabled(report.getReportConfiguration().getConfigProperty(PROGRESS_BAR_ENABLE_PROPERTY, "true").equals("true"));
        this.setProgressDialogEnabled(report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_PROPERTY, "true").equals("true"));
        this.proxy.setTitle(String.valueOf(report.getName()) + " - " + this.getResources().getString("preview-frame.title"));
        this.baseActionMap.put((Object)CLOSE_ACTION_KEY, this.proxy.createDefaultCloseAction());
        this.zoomIndex = 3;
        if (this.toolbar != null) {
            this.closeToolbar();
            this.toolbarHolder.remove(this.toolbar);
        }
        if (this.isPropertySet(CREATE_TOOLBAR_PROPERTY, true)) {
            this.toolbar = this.createToolBar();
            this.toolbar.setFloatable(this.isToolbarFloatable());
            this.toolbar.addPropertyChangeListener(new ToolbarPropertyChangeListener());
            this.toolbarHolder.add((Component)this.toolbar, "North");
        }
        this.reportPane = this.createReportPane(report);
        this.reportPane.addPropertyChangeListener(this.reportPanePropertyChangeListener);
        this.reportPane.setVisible(false);
        this.reportPaneHolder.add(this.reportPane);
        this.buildExportPlugins(report);
        this.reinitialize();
        this.applyDefinedDimension(report);
        this.firePropertyChange(REPORT_PANE_PROPERTY, oldPane, this.reportPane);
        this.performPagination();
        Log.info((Object)"setReport(..): started pagination ...");
    }

    public void setReportControler(ReportControler reportControler) {
        if (this.reportControler != null) {
            this.reportControler.setPreviewBase(null);
        }
        this.reportControler = reportControler;
        if (this.reportControler != null) {
            this.reportControler.setPreviewBase(this);
        }
        this.refreshControler();
    }

    public void setStatusText(String text) {
        this.statusHolder.setText(text);
    }

    public void setToolbarFloatable(boolean b) {
        boolean oldValue = this.toolbarFloatable;
        this.toolbarFloatable = b;
        this.firePropertyChange(TOOLBAR_FLOATABLE_PROPERTYNAME, oldValue, b);
    }

    public void setZoomFactor(int index) {
        this.zoomIndex = index;
        this.reportPane.setZoomFactor(this.getZoomFactor());
        this.zoomSelect.setSelectedIndex(this.zoomIndex);
    }

    public void setZoomInAction(Action zoomInAction) {
        this.zoomActionMap.put((Object)ZOOM_IN_ACTION_KEY, zoomInAction);
    }

    public void setZoomOutAction(Action zoomOutAction) {
        this.zoomActionMap.put((Object)ZOOM_OUT_ACTION_KEY, zoomOutAction);
    }

    protected void showExceptionDialog(String localisationBase, Exception e) {
        ExceptionDialog.showExceptionDialog(this.getResources().getString(String.valueOf(localisationBase) + ".title"), MessageFormat.format(this.getResources().getString(String.valueOf(localisationBase) + ".message"), e.getLocalizedMessage()), e);
    }

    public void updatePageFormat(PageFormat pf) throws ReportProcessingException {
        if (pf == null) {
            throw new NullPointerException("The given pageformat is null.");
        }
        JFreeReport report = this.getReport();
        PageDefinition pageDefinition = report.getPageDefinition();
        if (pageDefinition instanceof SimplePageDefinition) {
            SimplePageDefinition spd = (SimplePageDefinition)pageDefinition;
            report.setPageDefinition(new SimplePageDefinition(pf, spd.getPageCountHorizontal(), spd.getPageCountVertical()));
        } else {
            report.setPageDefinition(new SimplePageDefinition(pf));
        }
        this.setReport(report);
    }

    protected void validateButtons() {
        if (this.lockInterface) {
            this.disableButtons();
            return;
        }
        int pn = this.reportPane.getPageNumber();
        int mp = this.reportPane.getNumberOfPages();
        this.getLastPageAction().setEnabled(pn < mp);
        this.getNextPageAction().setEnabled(pn < mp);
        this.getPreviousPageAction().setEnabled(pn > 1);
        this.getFirstPageAction().setEnabled(pn > 1);
        this.getGotoAction().setEnabled(mp > 1);
        Iterator it = ((AbstractList)this.exportPlugIns).iterator();
        while (it.hasNext()) {
            ExportPlugin ep = (ExportPlugin)it.next();
            ExportAction ea = (ExportAction)this.pluginActions.get(ep);
            if (ep.isControlPlugin()) continue;
            ea.setEnabled(mp > 0);
        }
        this.zoomSelect.setEnabled(true);
        Object[] keys = this.zoomActionMap.keys();
        int i = 0;
        while (i < keys.length) {
            this.zoomActionMap.get(keys[i]).setEnabled(true);
            ++i;
        }
        this.getZoomOutAction().setEnabled(this.zoomSelect.getSelectedIndex() != 0);
        this.getZoomInAction().setEnabled(this.zoomSelect.getSelectedIndex() != ZOOM_FACTORS.length - 1);
    }

    private class ToolbarPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == PreviewProxyBase.this.getToolbar()) {
                if ("floatable".equals(evt.getPropertyName())) {
                    PreviewProxyBase.this.setToolbarFloatable(PreviewProxyBase.this.getToolbar().isFloatable());
                }
            } else if (evt.getSource() == PreviewProxyBase.this) {
                if (PreviewProxyBase.TOOLBAR_FLOATABLE_PROPERTYNAME.equals(evt.getPropertyName())) {
                    PreviewProxyBase.this.getToolbar().setFloatable(PreviewProxyBase.this.isToolbarFloatable());
                } else if (PreviewProxyBase.LARGE_ICONS_ENABLED_PROPERTY.equals(evt.getPropertyName())) {
                    PreviewProxyBase.this.reinitialize();
                }
            }
        }
    }

    private class ReportPanePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getPropertyName();
            ReportPane reportPane = PreviewProxyBase.this.getReportPane();
            if (property.equals("Paginated")) {
                if (reportPane.isPaginated()) {
                    Object[] params = new Object[]{new Integer(reportPane.getPageNumber()), new Integer(reportPane.getNumberOfPages())};
                    PreviewProxyBase.this.setStatusText(MessageFormat.format(PreviewProxyBase.this.getResources().getString("statusline.pages"), params));
                    PreviewProxyBase.this.validateButtons();
                }
            } else if (property.equals("PageNumber") || property.equals("NumberOfPages")) {
                Object[] params = new Object[]{new Integer(reportPane.getPageNumber()), new Integer(reportPane.getNumberOfPages())};
                PreviewProxyBase.this.setStatusText(MessageFormat.format(PreviewProxyBase.this.getResources().getString("statusline.pages"), params));
                PreviewProxyBase.this.validateButtons();
            } else if (property.equals("Error")) {
                if (reportPane.hasError()) {
                    Exception ex = reportPane.getError();
                    ex.printStackTrace();
                    PreviewProxyBase.this.setStatusText(MessageFormat.format(PreviewProxyBase.this.getResources().getString("statusline.error"), ex.getMessage()));
                }
                PreviewProxyBase.this.validateButtons();
            } else if (property.equals("ZoomFactor")) {
                PreviewProxyBase.this.validateButtons();
                PreviewProxyBase.this.validate();
            }
        }
    }

    private class DefaultFirstPageAction
    extends FirstPageAction {
        public DefaultFirstPageAction() {
            super(PreviewProxyBase.this.getResources());
        }

        public void actionPerformed(ActionEvent e) {
            PreviewProxyBase.this.firstPage();
        }
    }

    private class DefaultNextPageAction
    extends NextPageAction {
        public DefaultNextPageAction() {
            super(PreviewProxyBase.this.getResources());
        }

        public void actionPerformed(ActionEvent e) {
            PreviewProxyBase.this.increasePageNumber();
        }
    }

    private class DefaultPreviousPageAction
    extends PreviousPageAction {
        public DefaultPreviousPageAction() {
            super(PreviewProxyBase.this.getResources());
        }

        public void actionPerformed(ActionEvent e) {
            PreviewProxyBase.this.decreasePageNumber();
        }
    }

    private class DefaultLastPageAction
    extends LastPageAction {
        public DefaultLastPageAction() {
            super(PreviewProxyBase.this.getResources());
        }

        public void actionPerformed(ActionEvent e) {
            PreviewProxyBase.this.lastPage();
        }
    }

    private class DefaultZoomInAction
    extends ZoomInAction {
        public DefaultZoomInAction() {
            super(PreviewProxyBase.this.getResources());
        }

        public void actionPerformed(ActionEvent e) {
            PreviewProxyBase.this.increaseZoom();
        }
    }

    private class DefaultZoomOutAction
    extends ZoomOutAction {
        public DefaultZoomOutAction() {
            super(PreviewProxyBase.this.getResources());
        }

        public void actionPerformed(ActionEvent e) {
            PreviewProxyBase.this.decreaseZoom();
        }
    }

    private class DefaultAboutAction
    extends AboutAction {
        private AboutFrame aboutFrame;

        public DefaultAboutAction() {
            super(PreviewProxyBase.this.getResources());
        }

        public void actionPerformed(ActionEvent e) {
            if (this.aboutFrame == null) {
                this.aboutFrame = new AboutFrame(PreviewProxyBase.this.getResources().getString("action.about.name"), (ProjectInfo)JFreeReport.getInfo());
                this.aboutFrame.pack();
                RefineryUtilities.centerFrameOnScreen((Window)this.aboutFrame);
            }
            this.aboutFrame.setVisible(true);
            this.aboutFrame.requestFocus();
        }
    }

    private class DefaultGotoAction
    extends GotoPageAction {
        public DefaultGotoAction() {
            super(PreviewProxyBase.this.getResources());
        }

        public void actionPerformed(ActionEvent e) {
            String result = JOptionPane.showInputDialog(PreviewProxyBase.this, PreviewProxyBase.this.getResources().getString("dialog.gotopage.title"), PreviewProxyBase.this.getResources().getString("dialog.gotopage.message"), 2);
            if (result == null) {
                return;
            }
            try {
                int page = Integer.parseInt(result);
                ReportPane reportPane = PreviewProxyBase.this.getReportPane();
                if (page > 0 && page <= reportPane.getNumberOfPages()) {
                    reportPane.setPageNumber(page);
                }
            }
            catch (Exception exception) {
                Log.info((Object)"DefaultGotoAction: swallowed an exception");
            }
        }
    }

    private class ZoomSelectAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            PreviewProxyBase.this.setZoomFactor(PreviewProxyBase.this.getZoomSelect().getSelectedIndex());
        }
    }

    protected class ZoomSetAction
    extends AbstractActionDowngrade {
        private final int zoomFactor;

        public ZoomSetAction(int factorIndex) {
            this.zoomFactor = factorIndex;
            ((AbstractAction)((Object)this)).putValue("Name", String.valueOf(String.valueOf((int)(ZOOM_FACTORS[factorIndex] * 100.0f))) + " %");
            ((AbstractAction)((Object)this)).putValue("SmallIcon", ImageUtils.createTransparentIcon(16, 16));
            ((AbstractAction)((Object)this)).putValue("ICON24", ImageUtils.createTransparentIcon(24, 24));
        }

        public void actionPerformed(ActionEvent e) {
            PreviewProxyBase.this.setZoomFactor(this.zoomFactor);
        }
    }

    private class ShowHidePaginationRunnable
    implements Runnable {
        private boolean visible;
        private boolean cancel;
        private ReportPane reportPane;
        private ReportProgressDialog progressDialog;
        private ReportProgressBar progressBar;

        public ShowHidePaginationRunnable(ReportPane reportPane, ReportProgressDialog progressDialog, ReportProgressBar progressBar, boolean visible) {
            this.reportPane = reportPane;
            this.progressDialog = progressDialog;
            this.progressBar = progressBar;
            this.visible = visible;
            this.cancel = false;
        }

        public void cancel() {
            this.cancel = true;
        }

        public void run() {
            if (!this.visible) {
                if (!this.cancel) {
                    if (PreviewProxyBase.this.isProgressDialogEnabled()) {
                        this.reportPane.addRepaginationListener(this.progressDialog);
                        RefineryUtilities.positionFrameRandomly((Window)this.progressDialog);
                        ((Component)this.progressDialog).setVisible(true);
                    }
                    if (PreviewProxyBase.this.isProgressBarEnabled()) {
                        this.reportPane.addRepaginationListener(this.progressBar);
                        this.progressBar.setVisible(true);
                    }
                }
                this.reportPane.setHandleInterruptedState(true);
                this.reportPane.setVisible(false);
            } else {
                ((Component)this.progressDialog).setVisible(false);
                this.progressBar.setVisible(false);
                this.reportPane.removeRepaginationListener(this.progressDialog);
                this.reportPane.removeRepaginationListener(this.progressBar);
                this.reportPane.setVisible(true);
                this.reportPane.setHandleInterruptedState(false);
                PreviewProxyBase.this.setLockInterface(false);
            }
        }
    }

    private class RepaginationRunnable
    implements Runnable {
        public void run() {
            ReportPane reportPane = PreviewProxyBase.this.getReportPane();
            ReportProgressDialog progressDialog = PreviewProxyBase.this.getProgressDialog();
            ReportProgressBar progressBar = PreviewProxyBase.this.getProgressBar();
            try {
                ShowHidePaginationRunnable hidePane = new ShowHidePaginationRunnable(reportPane, progressDialog, progressBar, false);
                if (SwingUtilities.isEventDispatchThread()) {
                    hidePane.run();
                } else {
                    SwingUtilities.invokeLater(hidePane);
                }
                reportPane.repaginate();
                ShowHidePaginationRunnable showPane = new ShowHidePaginationRunnable(reportPane, progressDialog, progressBar, true);
                if (SwingUtilities.isEventDispatchThread()) {
                    showPane.run();
                } else {
                    hidePane.cancel();
                    SwingUtilities.invokeLater(showPane);
                }
            }
            catch (ReportInterruptedException reportInterruptedException) {
                ((Component)progressDialog).setVisible(false);
                reportPane.removeRepaginationListener(progressDialog);
                Log.info((Object)"Repagination aborted [ReportInterruptedException]");
            }
            catch (Exception e) {
                ((Component)progressDialog).setVisible(false);
                reportPane.removeRepaginationListener(progressDialog);
                Log.warn((Object)"Failed to repaginate", (Exception)e);
                reportPane.setError(e);
            }
        }
    }
}

