/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.components.FormValidator;
import org.jfree.report.modules.gui.base.components.JStatusBar;
import org.jfree.report.modules.misc.configstore.base.ConfigFactory;
import org.jfree.report.modules.misc.configstore.base.ConfigStorage;
import org.jfree.report.modules.misc.configstore.base.ConfigStoreException;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public abstract class AbstractExportDialog
extends JDialog {
    private Action cancelAction;
    private Action confirmAction;
    private FormValidator formValidator = new ExportDialogValidator();
    private ResourceBundle resources;
    private boolean confirmed;
    private JStatusBar statusBar;

    public AbstractExportDialog() {
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowCloseHandler());
        this.statusBar = new JStatusBar();
    }

    public AbstractExportDialog(Dialog owner) {
        super(owner);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.statusBar = new JStatusBar();
    }

    public AbstractExportDialog(Frame owner) {
        super(owner);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.statusBar = new JStatusBar();
    }

    public abstract void clear();

    protected Action getCancelAction() {
        return this.cancelAction;
    }

    protected abstract String getConfigurationSuffix();

    protected Action getConfirmAction() {
        return this.confirmAction;
    }

    protected abstract Properties getDialogContents();

    protected FormValidator getFormValidator() {
        return this.formValidator;
    }

    protected abstract String getResourceBaseName();

    protected ResourceBundle getResources() {
        if (this.resources == null) {
            this.resources = ResourceBundle.getBundle(this.getResourceBaseName());
        }
        return this.resources;
    }

    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    protected abstract void initFromConfiguration(Configuration var1);

    public boolean isConfirmed() {
        return this.confirmed;
    }

    protected boolean performConfirm() {
        return true;
    }

    public boolean performQueryForExport(JFreeReport report) {
        this.getFormValidator().setEnabled(false);
        this.initFromConfiguration((Configuration)report.getReportConfiguration());
        ConfigStorage storage = ConfigFactory.getInstance().getUserStorage();
        try {
            this.setDialogContents(storage.loadProperties(ConfigFactory.encodePath(String.valueOf(report.getName()) + this.getConfigurationSuffix()), new Properties()));
        }
        catch (Exception exception) {
            Log.debug((Object)("Unable to load the defaults in Export export dialog. [" + this.getClass() + "]"));
        }
        this.getFormValidator().setEnabled(true);
        this.getFormValidator().handleValidate();
        this.setModal(true);
        ((Component)this).setVisible(true);
        if (!this.isConfirmed()) {
            return false;
        }
        this.getFormValidator().setEnabled(false);
        this.storeToConfiguration(report.getReportConfiguration());
        try {
            storage.storeProperties(ConfigFactory.encodePath(String.valueOf(report.getName()) + this.getConfigurationSuffix()), this.getDialogContents());
        }
        catch (ConfigStoreException configStoreException) {
            Log.debug((Object)("Unable to store the defaults in Export export dialog. [" + this.getClass() + "]"));
        }
        this.getFormValidator().setEnabled(true);
        return true;
    }

    protected abstract boolean performValidate();

    protected void setCancelAction(Action cancelAction) {
        this.cancelAction = cancelAction;
    }

    protected void setConfirmAction(Action confirmAction) {
        this.confirmAction = confirmAction;
    }

    protected void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    protected abstract void setDialogContents(Properties var1);

    protected abstract void storeToConfiguration(ModifiableConfiguration var1);

    protected abstract class AbstractConfirmAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (AbstractExportDialog.this.performValidate() && AbstractExportDialog.this.performConfirm()) {
                AbstractExportDialog.this.setConfirmed(true);
                ((Component)AbstractExportDialog.this).setVisible(false);
            }
        }
    }

    protected abstract class AbstractCancelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            AbstractExportDialog.this.setConfirmed(false);
            ((Component)AbstractExportDialog.this).setVisible(false);
        }
    }

    private class ExportDialogValidator
    extends FormValidator {
        public Action getConfirmAction() {
            return AbstractExportDialog.this.getConfirmAction();
        }

        public boolean performValidate() {
            return AbstractExportDialog.this.performValidate();
        }
    }

    private class WindowCloseHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            Action cancelAction = AbstractExportDialog.this.getCancelAction();
            if (cancelAction != null) {
                cancelAction.actionPerformed(null);
            } else {
                AbstractExportDialog.this.setConfirmed(false);
                ((Component)AbstractExportDialog.this).setVisible(false);
            }
        }
    }
}

