/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.config.ConfigTreeRenderer;
import org.jfree.report.modules.gui.config.editor.ConfigEditorPanel;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.ConfigTreeModel;
import org.jfree.report.modules.gui.config.model.ConfigTreeModelException;
import org.jfree.report.modules.gui.config.model.ConfigTreeModuleNode;
import org.jfree.report.util.LineBreakIterator;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.FilesystemFilter;
import org.jfree.ui.action.AbstractActionDowngrade;
import org.jfree.ui.action.ActionButton;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.ResourceBundleSupport;

public class ConfigEditor
extends JFrame {
    private static final int ESCAPE_KEY = 0;
    private static final int ESCAPE_VALUE = 1;
    private static final int ESCAPE_COMMENT = 2;
    public static final String RESOURCE_BUNDLE = "org.jfree.report.modules.gui.config.resources/config-resources";
    private JLabel statusHolder;
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.config.resources/config-resources");
    private final ConfigEditorPanel detailEditorPane;
    private ConfigTreeModel treeModel;
    private final HierarchicalConfiguration currentReportConfiguration = new HierarchicalConfiguration(JFreeReportBoot.getInstance().getGlobalConfig());
    private JFileChooser fileChooser;
    static /* synthetic */ Class class$org$jfree$report$modules$gui$config$ConfigEditor;

    public ConfigEditor() throws ConfigTreeModelException {
        this.detailEditorPane = new ConfigEditorPanel();
        this.setTitle(this.resources.getString("config-editor.title"));
        JSplitPane splitPane = new JSplitPane(1, this.createEntryTree(), this.detailEditorPane);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)splitPane, "Center");
        contentPane.add((Component)this.createButtonPane(), "South");
        JPanel cPaneStatus = new JPanel();
        cPaneStatus.setLayout(new BorderLayout());
        cPaneStatus.add((Component)contentPane, "Center");
        cPaneStatus.add((Component)this.createStatusBar(), "South");
        this.setContentPane(cPaneStatus);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConfigEditor.this.attempClose();
            }
        });
    }

    protected void attempClose() {
        System.exit(0);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private JPanel createButtonPane() {
        CloseAction closeAction = new CloseAction();
        SaveAction saveAction = new SaveAction();
        LoadAction loadAction = new LoadAction();
        NewAction newAction = new NewAction();
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel buttonHolder = new JPanel();
        buttonHolder.setLayout(new GridLayout(1, 4));
        buttonHolder.add((Component)new ActionButton((Action)((Object)newAction)));
        buttonHolder.add((Component)new ActionButton((Action)((Object)loadAction)));
        buttonHolder.add((Component)new ActionButton((Action)((Object)saveAction)));
        buttonHolder.add((Component)new ActionButton((Action)((Object)closeAction)));
        panel.add(buttonHolder);
        return panel;
    }

    private JComponent createEntryTree() throws ConfigTreeModelException {
        InputStream in = ObjectUtilities.getResourceRelativeAsStream((String)"config-description.xml", (Class)(class$org$jfree$report$modules$gui$config$ConfigEditor != null ? class$org$jfree$report$modules$gui$config$ConfigEditor : (class$org$jfree$report$modules$gui$config$ConfigEditor = ConfigEditor.class$("org.jfree.report.modules.gui.config.ConfigEditor"))));
        if (in == null) {
            throw new IllegalStateException("Missing resource 'config-description.xml'");
        }
        this.treeModel = new ConfigTreeModel(in);
        this.treeModel.init(this.currentReportConfiguration);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        JTree tree = new JTree(this.treeModel);
        tree.setSelectionModel(selectionModel);
        tree.setCellRenderer(new ConfigTreeRenderer());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.addTreeSelectionListener(new ModuleTreeSelectionHandler());
        JScrollPane pane = new JScrollPane(tree, 20, 31);
        return pane;
    }

    protected JPanel createStatusBar() {
        JPanel statusPane = new JPanel();
        statusPane.setLayout(new BorderLayout());
        statusPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        statusPane.setMinimumSize(this.statusHolder.getPreferredSize());
        statusPane.add((Component)this.statusHolder, "West");
        return statusPane;
    }

    protected ConfigEditorPanel getDetailEditorPane() {
        return this.detailEditorPane;
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    protected void load() {
        block7: {
            int option;
            this.setStatusText("Loading: Select file ...");
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                FilesystemFilter filter = new FilesystemFilter(".properties", "Properties files");
                this.fileChooser.addChoosableFileFilter((FileFilter)filter);
                this.fileChooser.setMultiSelectionEnabled(false);
            }
            if ((option = this.fileChooser.showSaveDialog(this)) != 0) break block7;
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtil.endsWithIgnoreCase(selFileName, ".properties")) {
                selFileName = String.valueOf(selFileName) + ".properties";
            }
            Properties prop = new Properties();
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(selFileName));
                prop.load(in);
                ((InputStream)in).close();
            }
            catch (IOException ioe) {
                Log.debug((Object)"Failed to load the properties.", (Exception)ioe);
                this.setStatusText("Failed to load the properties." + ioe.getMessage());
                return;
            }
            this.reset();
            Enumeration keys = ((Hashtable)prop).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = prop.getProperty(key);
                this.currentReportConfiguration.setConfigProperty(key, value);
            }
            try {
                this.treeModel.init(this.currentReportConfiguration);
                this.setStatusText("Loading the properties complete.");
            }
            catch (ConfigTreeModelException e) {
                Log.debug((Object)"Failed to update the model.", (Exception)((Object)e));
                this.setStatusText("Failed to update the model.");
            }
        }
    }

    public static void main(String[] args) {
        try {
            JFreeReportBoot.getInstance().start();
            ConfigEditor ed = new ConfigEditor();
            ed.pack();
            ((Component)ed).setVisible(true);
        }
        catch (Exception e) {
            Log.debug((Object)"Failed to init", (Exception)e);
            JOptionPane.showMessageDialog(null, "Failed to initialize.");
        }
    }

    protected void reset() {
        Enumeration defaults = this.currentReportConfiguration.getConfigProperties();
        while (defaults.hasMoreElements()) {
            String key = (String)defaults.nextElement();
            this.currentReportConfiguration.setConfigProperty(key, null);
        }
    }

    protected void save() {
        int option;
        this.setStatusText("Saving: Select file ...");
        this.detailEditorPane.store();
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(".properties", "Properties files");
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        if ((option = this.fileChooser.showSaveDialog(this)) == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtil.endsWithIgnoreCase(selFileName, ".properties")) {
                selFileName = String.valueOf(selFileName) + ".properties";
            }
            this.write(selFileName);
        }
    }

    private void saveConvert(String text, int escapeMode, PrintWriter writer) {
        char[] string = text.toCharArray();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int x = 0;
        while (x < string.length) {
            char aChar = string[x];
            switch (aChar) {
                case ' ': {
                    if (escapeMode != 2 && (x == 0 || escapeMode == 0)) {
                        writer.print('\\');
                    }
                    writer.print(' ');
                    break;
                }
                case '\\': {
                    writer.print('\\');
                    writer.print('\\');
                    break;
                }
                case '\t': {
                    if (escapeMode == 2) {
                        writer.print(aChar);
                        break;
                    }
                    writer.print('\\');
                    writer.print('t');
                    break;
                }
                case '\n': {
                    writer.print('\\');
                    writer.print('n');
                    break;
                }
                case '\r': {
                    writer.print('\\');
                    writer.print('r');
                    break;
                }
                case '\f': {
                    if (escapeMode == 2) {
                        writer.print(aChar);
                        break;
                    }
                    writer.print('\\');
                    writer.print('f');
                    break;
                }
                case '!': 
                case '\"': 
                case '#': 
                case ':': 
                case '=': {
                    if (escapeMode == 2) {
                        writer.print(aChar);
                        break;
                    }
                    writer.print('\\');
                    writer.print(aChar);
                    break;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        writer.print('\\');
                        writer.print('u');
                        writer.print(hexChars[aChar >> 12 & 0xF]);
                        writer.print(hexChars[aChar >> 8 & 0xF]);
                        writer.print(hexChars[aChar >> 4 & 0xF]);
                        writer.print(hexChars[aChar & 0xF]);
                        break;
                    }
                    writer.print(aChar);
                }
            }
            ++x;
        }
    }

    private void setStatusText(String text) {
        this.statusHolder.setText(text);
    }

    private void write(String filename) {
        Properties prop = new Properties();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration defaults = this.currentReportConfiguration.getConfigProperties();
        while (defaults.hasMoreElements()) {
            String key = (String)defaults.nextElement();
            names.add(key);
            prop.setProperty(key, this.currentReportConfiguration.getConfigProperty(key));
        }
        Collections.sort(names);
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(filename))));
            int i = 0;
            while (i < names.size()) {
                String key = (String)names.get(i);
                String value = prop.getProperty(key);
                ConfigDescriptionEntry entry = this.treeModel.getEntryForKey(key);
                if (entry != null) {
                    String description = entry.getDescription();
                    this.writeDescription(description, out);
                }
                this.saveConvert(key, 0, out);
                out.print("=");
                this.saveConvert(value, 1, out);
                out.println();
                ++i;
            }
            out.close();
            this.setStatusText("Saving the properties complete.");
        }
        catch (IOException ioe) {
            Log.debug((Object)"Failed to save the properties.", (Exception)ioe);
            this.setStatusText("Failed to savethe properties." + ioe.getMessage());
        }
    }

    private void writeDescription(String text, PrintWriter writer) {
        if (text.length() == 0) {
            return;
        }
        writer.println("# ");
        LineBreakIterator iterator = new LineBreakIterator(text);
        while (iterator.hasNext()) {
            writer.print("# ");
            this.saveConvert((String)iterator.next(), 2, writer);
            writer.println();
        }
    }

    private class CloseAction
    extends AbstractActionDowngrade {
        public CloseAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigEditor.this.getResources().getString("action.exit.name"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigEditor.this.attempClose();
        }
    }

    private class SaveAction
    extends AbstractActionDowngrade {
        public SaveAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigEditor.this.getResources().getString("action.save.name"));
            ((AbstractAction)((Object)this)).putValue("SmallIcon", ConfigEditor.this.getResources().getIcon("action.save.small-icon"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigEditor.this.save();
        }
    }

    private class LoadAction
    extends AbstractActionDowngrade {
        public LoadAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigEditor.this.getResources().getString("action.load.name"));
            ((AbstractAction)((Object)this)).putValue("SmallIcon", ConfigEditor.this.getResources().getIcon("action.load.small-icon"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigEditor.this.load();
        }
    }

    private class NewAction
    extends AbstractActionDowngrade {
        public NewAction() {
            ((AbstractAction)((Object)this)).putValue("Name", ConfigEditor.this.getResources().getString("action.new.name"));
            ((AbstractAction)((Object)this)).putValue("SmallIcon", ConfigEditor.this.getResources().getIcon("action.new.small-icon"));
        }

        public void actionPerformed(ActionEvent e) {
            ConfigEditor.this.reset();
        }
    }

    private class ModuleTreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getPath();
            Object lastPathElement = path.getLastPathComponent();
            if (lastPathElement instanceof ConfigTreeModuleNode) {
                ConfigTreeModuleNode node = (ConfigTreeModuleNode)lastPathElement;
                ConfigEditorPanel detailEditorPane = ConfigEditor.this.getDetailEditorPane();
                detailEditorPane.store();
                detailEditorPane.editModule(node.getModule(), node.getConfiguration(), node.getAssignedKeys());
            }
        }
    }
}

