/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.PackageManager;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionEntry;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionModel;
import org.jfree.report.modules.gui.config.model.ConfigTreeModelException;
import org.jfree.report.modules.gui.config.model.ConfigTreeModuleNode;
import org.jfree.report.modules.gui.config.model.TextConfigDescriptionEntry;
import org.jfree.util.Log;
import org.xml.sax.SAXException;

public class ModuleNodeFactory {
    private final Module[] activeModules;
    private final ArrayList globalNodes;
    private final ArrayList localNodes;
    private final Hashtable configEntryLookup;
    static /* synthetic */ Class class$org$jfree$report$JFreeReportCoreModule;
    static /* synthetic */ Class class$org$jfree$report$DefaultLogModule;

    private ModuleNodeFactory() {
        JFreeReportBoot.getInstance().start();
        PackageManager pm = JFreeReportBoot.getInstance().getPackageManager();
        this.activeModules = pm.getAllModules();
        Arrays.sort(this.activeModules, new ModuleSorter());
        this.globalNodes = new ArrayList();
        this.localNodes = new ArrayList();
        this.configEntryLookup = new Hashtable();
    }

    public ModuleNodeFactory(InputStream in) throws IOException {
        this();
        ConfigDescriptionModel model = new ConfigDescriptionModel();
        try {
            model.load(in);
        }
        catch (SAXException saxException) {
            Log.error((Object)"Failed to parse the model description.", (Exception)saxException);
            throw new IOException("Failed to parse the model description:" + saxException.getMessage());
        }
        catch (ParserConfigurationException pE) {
            Log.error((Object)"Failed to configure the xml parser.", (Exception)pE);
            throw new IOException("Failed to configure the xml parser:" + pE.getMessage());
        }
        ConfigDescriptionEntry[] entries = model.toArray();
        int i = 0;
        while (i < entries.length) {
            this.configEntryLookup.put(entries[i].getKeyName(), entries[i]);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ConfigDescriptionEntry getEntryForKey(String key) {
        return (ConfigDescriptionEntry)this.configEntryLookup.get(key);
    }

    public ArrayList getGlobalNodes() {
        return this.globalNodes;
    }

    public ArrayList getLocalNodes() {
        return this.localNodes;
    }

    public static String getPackage(Class c) {
        String className = c.getName();
        int idx = className.lastIndexOf(46);
        if (idx <= 0) {
            return "";
        }
        return className.substring(0, idx);
    }

    public void init(HierarchicalConfiguration config) throws ConfigTreeModelException {
        this.globalNodes.clear();
        this.localNodes.clear();
        Enumeration keys = this.configEntryLookup.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.processKey(key, config);
        }
    }

    private Module lookupModule(String key) throws ConfigTreeModelException {
        Module fallback = null;
        int i = 0;
        while (i < this.activeModules.length) {
            String modPackage;
            if (this.activeModules[i].getClass().equals(class$org$jfree$report$JFreeReportCoreModule != null ? class$org$jfree$report$JFreeReportCoreModule : ModuleNodeFactory.class$("org.jfree.report.JFreeReportCoreModule"))) {
                fallback = this.activeModules[i];
            } else if (!this.activeModules[i].getClass().equals(class$org$jfree$report$DefaultLogModule != null ? class$org$jfree$report$DefaultLogModule : ModuleNodeFactory.class$("org.jfree.report.DefaultLogModule")) && key.startsWith(modPackage = ModuleNodeFactory.getPackage(this.activeModules[i].getClass()))) {
                return this.activeModules[i];
            }
            ++i;
        }
        if (fallback == null) {
            throw new ConfigTreeModelException("Core module is not registered.");
        }
        return fallback;
    }

    private ConfigTreeModuleNode lookupNode(Module key, ArrayList nodeList) {
        int i = 0;
        while (i < nodeList.size()) {
            ConfigTreeModuleNode node = (ConfigTreeModuleNode)nodeList.get(i);
            if (key == node.getModule()) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private void processKey(String key, HierarchicalConfiguration config) throws ConfigTreeModelException {
        ConfigTreeModuleNode node;
        ConfigDescriptionEntry cde = (ConfigDescriptionEntry)this.configEntryLookup.get(key);
        Module mod = this.lookupModule(key);
        if (cde == null) {
            try {
                if (((Hashtable)System.getProperties()).containsKey(key)) {
                    Log.debug((Object)("Ignored key from the system properties: " + key));
                    return;
                }
                Log.debug((Object)("Undefined key added on the fly: " + key));
                cde = new TextConfigDescriptionEntry(key);
            }
            catch (SecurityException securityException) {
                Log.debug((Object)("Unsafe key-definition due to security restrictions: " + key));
                cde = new TextConfigDescriptionEntry(key);
            }
        }
        if (cde.isHidden()) {
            return;
        }
        if (!cde.isGlobal()) {
            node = this.lookupNode(mod, this.localNodes);
            if (node == null) {
                node = new ConfigTreeModuleNode(mod, config);
                this.localNodes.add(node);
            }
            node.addAssignedKey(cde);
        }
        if ((node = this.lookupNode(mod, this.globalNodes)) == null) {
            node = new ConfigTreeModuleNode(mod, config);
            this.globalNodes.add(node);
        }
        node.addAssignedKey(cde);
    }

    private static class ModuleSorter
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String name2;
            String name1;
            if (o1.getClass().getPackage() == null || o2.getClass().getPackage() == null) {
                name1 = ModuleNodeFactory.getPackage(o1.getClass());
                name2 = ModuleNodeFactory.getPackage(o2.getClass());
            } else {
                name1 = o1.getClass().getPackage().getName();
                name2 = o2.getClass().getPackage().getName();
            }
            return name1.compareTo(name2);
        }
    }
}

