/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.pdf;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.base.AbstractExportPlugin;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.gui.pdf.PDFExportTask;
import org.jfree.report.modules.gui.pdf.PDFSaveDialog;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ResourceBundleSupport;

public class PDFExportPlugin
extends AbstractExportPlugin {
    private PDFSaveDialog exportDialog;
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.pdf.resources.pdf-export-resources");
    public static final String BASE_RESOURCE_CLASS = "org.jfree.report.modules.gui.pdf.resources.pdf-export-resources";
    public static final String PROGRESS_DIALOG_ENABLE_KEY = "org.jfree.report.modules.gui.pdf.ProgressDialogEnabled";

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setTitle(this.resources.getString("pdf-export.progressdialog.title"));
        progressDialog.setMessage(this.resources.getString("pdf-export.progressdialog.message"));
        progressDialog.pack();
        RefineryUtilities.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getKeyStroke("action.save-as.accelerator");
    }

    public String getDisplayName() {
        return this.resources.getString("action.save-as.name");
    }

    protected synchronized PDFSaveDialog getExportDialog() {
        if (this.exportDialog == null) {
            PreviewProxy proxy = super.getProxy();
            this.exportDialog = proxy instanceof Frame ? new PDFSaveDialog((Frame)((Object)proxy)) : (proxy instanceof Dialog ? new PDFSaveDialog((Dialog)((Object)proxy)) : new PDFSaveDialog());
            this.exportDialog.pack();
        }
        return this.exportDialog;
    }

    public Icon getLargeIcon() {
        return this.resources.getIcon("action.save-as.icon");
    }

    public Integer getMnemonicKey() {
        return this.resources.getMnemonic("action.save-as.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public String getShortDescription() {
        return this.resources.getString("action.save-as.description");
    }

    public Icon getSmallIcon() {
        return this.resources.getIcon("action.save-as.small-icon");
    }

    public boolean isAddToToolbar() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.pdf.AddToToolbar", "false").equals("true");
    }

    public boolean isSeparated() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.pdf.Separated", "false").equals("true");
    }

    public boolean performExport(JFreeReport report) {
        PDFSaveDialog exportDialog = this.getExportDialog();
        boolean result = exportDialog.performQueryForExport(report);
        if (!result) {
            return this.handleExportResult(true);
        }
        ReportProgressDialog progressDialog = report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_KEY, "false").equals("true") ? this.createProgressDialog() : null;
        PDFExportTask task = new PDFExportTask(exportDialog.getFilename(), progressDialog, report);
        task.addExportTaskListener(new AbstractExportPlugin.DefaultExportTaskListener());
        this.delegateTask(task);
        return this.handleExportResult(task);
    }
}

